/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.events;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import github.jorgaomc.CobblemonMastery;
import github.jorgaomc.storage.MasteryManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class CobblemonMasteryEventHandler {
    public static void register() {
        CobblemonEvents.BATTLE_FAINTED.subscribe(Priority.NORMAL, event -> {
            try {
                class_3222 sp;
                Pokemon killer;
                Object killedObj = CobblemonMasteryEventHandler.tryGetMethod(event, "getKilled");
                Pokemon killed = CobblemonMasteryEventHandler.extractPokemon(killedObj);
                if (killed == null) {
                    return Unit.INSTANCE;
                }
                Object contextObj = CobblemonMasteryEventHandler.tryGetMethod(event, "getContext");
                if (contextObj == null) {
                    return Unit.INSTANCE;
                }
                Object originObj = CobblemonMasteryEventHandler.tryGetMethod(contextObj, "getOrigin");
                Pokemon pokemon = killer = originObj != null ? CobblemonMasteryEventHandler.extractPokemon(originObj) : null;
                if (killer != null && killer.getOwnerUUID() != null && (sp = CobblemonMasteryEventHandler.tryResolveOwnerPlayer(killer)) != null) {
                    String attackerSpecies = CobblemonMasteryEventHandler.safeSpeciesName(killer);
                    String targetSpecies = CobblemonMasteryEventHandler.safeSpeciesName(killed);
                    Set<String> typesLower = CobblemonMasteryEventHandler.getSpeciesTypesLower(killed);
                    if (attackerSpecies != null && targetSpecies != null) {
                        MasteryManager.get().handleDefeatWithNotify(sp, sp.method_5667(), attackerSpecies, targetSpecies, typesLower);
                        CobblemonMastery.LOGGER.debug("Defeat: {} defeated {}", (Object)attackerSpecies, (Object)targetSpecies);
                    }
                }
            }
            catch (Exception e) {
                CobblemonMastery.LOGGER.error("Error in battle fainted handler", (Throwable)e);
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.NORMAL, event -> {
            try {
                PokemonCapturedEvent cap = event;
                class_3222 player = cap.getPlayer();
                if (player instanceof class_3222) {
                    class_3222 sp = player;
                    String species = CobblemonMasteryEventHandler.safeSpeciesName(cap.getPokemon());
                    if (species != null) {
                        MasteryManager.get().incrementProgress(sp.method_5667(), species, 1);
                        MasteryManager.get().handleCaptureWithNotify(sp, sp.method_5667(), species);
                    }
                }
            }
            catch (Exception e) {
                CobblemonMastery.LOGGER.error("Error handling mastery captured event", (Throwable)e);
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.EVOLUTION_COMPLETE.subscribe(Priority.NORMAL, event -> {
            try {
                String evolvedSpecies;
                class_3222 sp;
                Pokemon pokemon = event.getPokemon();
                if (pokemon != null && pokemon.getOwnerUUID() != null && (sp = CobblemonMasteryEventHandler.tryResolveOwnerPlayer(pokemon)) != null && (evolvedSpecies = CobblemonMasteryEventHandler.safeSpeciesName(pokemon)) != null) {
                    MasteryManager.get().handleEvolveWithNotify(sp, sp.method_5667(), evolvedSpecies);
                }
            }
            catch (Exception e) {
                CobblemonMastery.LOGGER.error("Error handling evolution event", (Throwable)e);
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.LEVEL_UP_EVENT.subscribe(Priority.NORMAL, event -> {
            try {
                Pokemon pokemon = event.getPokemon();
                if (pokemon != null && pokemon.getOwnerUUID() != null) {
                    int newLevel = event.getNewLevel();
                    int oldLevel = event.getOldLevel();
                    int delta = Math.max(1, newLevel - oldLevel);
                    String species = CobblemonMasteryEventHandler.safeSpeciesName(pokemon);
                    class_3222 sp = CobblemonMasteryEventHandler.tryResolveOwnerPlayer(pokemon);
                    if (species != null && sp != null) {
                        MasteryManager.get().handleLevelUpWithNotify(sp, sp.method_5667(), species, delta);
                    }
                }
            }
            catch (Exception e) {
                CobblemonMastery.LOGGER.error("Error handling level up event", (Throwable)e);
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.FRIENDSHIP_UPDATED.subscribe(Priority.NORMAL, event -> {
            try {
                Pokemon pokemon = event.getPokemon();
                if (pokemon != null && pokemon.getOwnerUUID() != null) {
                    int newFriendship = event.getNewFriendship();
                    String species = CobblemonMasteryEventHandler.safeSpeciesName(pokemon);
                    class_3222 sp = CobblemonMasteryEventHandler.tryResolveOwnerPlayer(pokemon);
                    if (species != null && sp != null) {
                        MasteryManager.get().updateFriendshipWithNotify(sp, sp.method_5667(), species, newFriendship);
                    }
                }
            }
            catch (Exception e) {
                CobblemonMastery.LOGGER.error("Error handling friendship event", (Throwable)e);
            }
            return Unit.INSTANCE;
        });
        try {
            CobblemonEvents.BOBBER_SPAWN_POKEMON_POST.subscribe(Priority.NORMAL, ev -> {
                try {
                    String species;
                    Pokemon pokemon;
                    Object pokemonObj = CobblemonMasteryEventHandler.tryGetMethod(ev, "getPokemon", "getSpawnedPokemon", "getPokemonInstance");
                    if (pokemonObj == null) {
                        return Unit.INSTANCE;
                    }
                    Pokemon pokemon2 = pokemon = pokemonObj instanceof Pokemon ? (Pokemon)pokemonObj : CobblemonMasteryEventHandler.extractPokemon(pokemonObj);
                    if (pokemon == null) {
                        return Unit.INSTANCE;
                    }
                    Object playerObj = CobblemonMasteryEventHandler.tryGetMethod(ev, "getPlayer", "getCatchingPlayer");
                    class_3222 sp = null;
                    if (playerObj instanceof class_3222) {
                        sp = (class_3222)playerObj;
                    }
                    if (sp == null) {
                        Object ownerObj;
                        Object bobberObj = CobblemonMasteryEventHandler.tryGetMethod(ev, "getBobber");
                        Object object = ownerObj = bobberObj != null ? CobblemonMasteryEventHandler.tryGetMethod(bobberObj, "getOwner", "getPlayerOwner") : null;
                        if (ownerObj instanceof class_3222) {
                            sp = (class_3222)ownerObj;
                        }
                    }
                    if (sp == null) {
                        sp = CobblemonMasteryEventHandler.tryResolveOwnerPlayer(pokemon);
                    }
                    if (sp != null && (species = CobblemonMasteryEventHandler.safeSpeciesName(pokemon)) != null) {
                        MasteryManager.get().handleFishingWithNotify(sp, sp.method_5667(), species);
                        CobblemonMastery.LOGGER.debug("Fishing: {} caught {}", (Object)sp.method_5477().getString(), (Object)species);
                    }
                }
                catch (Exception e) {
                    CobblemonMastery.LOGGER.error("Error in fishing handler", (Throwable)e);
                }
                return Unit.INSTANCE;
            });
        }
        catch (Throwable t) {
            CobblemonMastery.LOGGER.warn("BOBBER_SPAWN_POKEMON_POST not available");
        }
        CobblemonMastery.LOGGER.info("Cobblemon Mastery event handlers registered.");
    }

    private static Pokemon extractPokemon(Object battlePokemon) {
        try {
            Object result;
            Field field2;
            Object result22;
            try {
                result22 = battlePokemon.getClass().getMethod("getOriginalPokemon", new Class[0]).invoke(battlePokemon, new Object[0]);
                if (result22 instanceof Pokemon) {
                    return (Pokemon)result22;
                }
            }
            catch (Throwable result22) {
                // empty catch block
            }
            try {
                result22 = battlePokemon.getClass().getMethod("getEffectedPokemon", new Class[0]).invoke(battlePokemon, new Object[0]);
                if (result22 instanceof Pokemon) {
                    return (Pokemon)result22;
                }
            }
            catch (Throwable result3) {
                // empty catch block
            }
            try {
                result22 = battlePokemon.getClass().getMethod("getPokemon", new Class[0]).invoke(battlePokemon, new Object[0]);
                if (result22 instanceof Pokemon) {
                    return (Pokemon)result22;
                }
            }
            catch (Throwable result4) {
                // empty catch block
            }
            try {
                field2 = battlePokemon.getClass().getDeclaredField("originalPokemon");
                field2.setAccessible(true);
                result = field2.get(battlePokemon);
                if (result instanceof Pokemon) {
                    return (Pokemon)result;
                }
            }
            catch (Throwable field2) {
                // empty catch block
            }
            try {
                field2 = battlePokemon.getClass().getDeclaredField("effectedPokemon");
                field2.setAccessible(true);
                result = field2.get(battlePokemon);
                if (result instanceof Pokemon) {
                    return (Pokemon)result;
                }
            }
            catch (Throwable field3) {}
        }
        catch (Throwable t) {
            CobblemonMastery.LOGGER.debug("Failed to extract Pokemon from BattlePokemon", t);
        }
        return null;
    }

    private static Object tryGetMethod(Object target, String ... methodNames) {
        for (String m : methodNames) {
            try {
                Method mm = target.getClass().getMethod(m, new Class[0]);
                return mm.invoke(target, new Object[0]);
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    private static String safeSpeciesName(Pokemon p) {
        try {
            Species species = p.getSpecies();
            if (species == null) {
                return null;
            }
            try {
                String s;
                Object idObj = species.getClass().getMethod("getIdentifier", new Class[0]).invoke((Object)species, new Object[0]);
                if (idObj instanceof class_2960) {
                    class_2960 id = (class_2960)idObj;
                    return id.toString().toLowerCase(Locale.ROOT);
                }
                if (idObj != null && !(s = String.valueOf(idObj)).isBlank()) {
                    return s.toLowerCase(Locale.ROOT);
                }
            }
            catch (Throwable idObj) {
                // empty catch block
            }
            try {
                String name = String.valueOf(species.getClass().getMethod("getName", new Class[0]).invoke((Object)species, new Object[0]));
                if (name != null && !name.isBlank()) {
                    String path = name.toLowerCase(Locale.ROOT);
                    if (path.contains(":")) {
                        return path;
                    }
                    return "cobblemon:" + path;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Set<String> getSpeciesTypesLower(Pokemon pokemon) {
        HashSet<String> set;
        block19: {
            set = new HashSet<String>();
            try {
                String name3;
                Species species;
                block20: {
                    try {
                        Object types = pokemon.getClass().getMethod("getTypes", new Class[0]).invoke((Object)pokemon, new Object[0]);
                        if (types instanceof Iterable) {
                            Iterable it = (Iterable)types;
                            for (Object t : it) {
                                try {
                                    String name2 = String.valueOf(t.getClass().getMethod("getName", new Class[0]).invoke(t, new Object[0]));
                                    if (name2 == null) continue;
                                    set.add(name2.toLowerCase(Locale.ROOT));
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                        if (!set.isEmpty()) {
                            return set;
                        }
                    }
                    catch (Throwable types) {
                        // empty catch block
                    }
                    species = pokemon.getSpecies();
                    if (species == null) break block19;
                    try {
                        Object pt = species.getClass().getMethod("getPrimaryType", new Class[0]).invoke((Object)species, new Object[0]);
                        if (pt == null) break block20;
                        try {
                            name3 = String.valueOf(pt.getClass().getMethod("getName", new Class[0]).invoke(pt, new Object[0]));
                            if (name3 != null) {
                                set.add(name3.toLowerCase(Locale.ROOT));
                            }
                        }
                        catch (Throwable name3) {}
                    }
                    catch (Throwable pt) {
                        // empty catch block
                    }
                }
                try {
                    Object st = species.getClass().getMethod("getSecondaryType", new Class[0]).invoke((Object)species, new Object[0]);
                    if (st == null) break block19;
                    try {
                        name3 = String.valueOf(st.getClass().getMethod("getName", new Class[0]).invoke(st, new Object[0]));
                        if (name3 != null) {
                            set.add(name3.toLowerCase(Locale.ROOT));
                        }
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return set;
    }

    private static class_3222 tryResolveOwnerPlayer(Pokemon p) {
        try {
            UUID owner = p.getOwnerUUID();
            if (owner == null) {
                return null;
            }
            PokemonEntity entity = p.getEntity();
            if (entity != null && entity.method_37908() != null) {
                for (class_1657 pl : entity.method_37908().method_18456()) {
                    class_3222 sp;
                    if (!(pl instanceof class_3222) || !owner.equals((sp = (class_3222)pl).method_5667())) continue;
                    return sp;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

