/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import github.jorgaomc.CobblemonMastery;
import github.jorgaomc.config.ConfigManager;
import github.jorgaomc.storage.PlayerMasteryData;
import github.jorgaomc.storage.SpeciesMastery;
import github.jorgaomc.tasks.SpeciesTasks;
import github.jorgaomc.tasks.TaskConfigLoader;
import github.jorgaomc.tasks.TaskDefinition;
import github.jorgaomc.tasks.TaskType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class MasteryManager {
    private static final MasteryManager INSTANCE = new MasteryManager();
    private final TaskConfigLoader taskLoader = new TaskConfigLoader();
    private Map<String, SpeciesTasks> speciesTasks = Collections.emptyMap();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<String, SpeciesCfg> bySpecies = new ConcurrentHashMap<String, SpeciesCfg>();
    private final Map<UUID, PlayerMasteryData> perPlayer = new ConcurrentHashMap<UUID, PlayerMasteryData>();
    private GlobalRewardsCfg globalRewards = new GlobalRewardsCfg();
    private final Map<String, List<RewardItemCfg>> speciesRewards = new ConcurrentHashMap<String, List<RewardItemCfg>>();

    public static MasteryManager get() {
        return INSTANCE;
    }

    public void refreshTasks() {
        try {
            this.speciesTasks = this.taskLoader.loadAll();
        }
        catch (Exception e) {
            this.speciesTasks = Collections.emptyMap();
            CobblemonMastery.LOGGER.warn("Failed to refresh tasks", (Throwable)e);
        }
    }

    public SpeciesTasks getSpeciesTasks(String speciesKey) {
        if (speciesKey == null) {
            return null;
        }
        String key = speciesKey.toLowerCase(Locale.ROOT);
        if (this.speciesTasks.containsKey(key)) {
            return this.speciesTasks.get(key);
        }
        List<String> candidates = this.buildKeyVariants(key);
        for (String k : candidates) {
            SpeciesTasks st = this.speciesTasks.get(k);
            if (st == null) continue;
            return st;
        }
        return null;
    }

    public synchronized void resetForNewWorld(MinecraftServer server) {
        this.perPlayer.clear();
    }

    private void loadRewardConfigs() {
        try {
            Path dir = ConfigManager.getRewardsDir();
            Files.createDirectories(dir, new FileAttribute[0]);
            this.ensureBundledRewardDefaults(dir);
            Path global = ConfigManager.getGlobalRewardsFile();
            if (Files.exists(global, new LinkOption[0])) {
                try (BufferedReader r = Files.newBufferedReader(global);){
                    GlobalRewardsCfg g = (GlobalRewardsCfg)this.gson.fromJson((Reader)r, GlobalRewardsCfg.class);
                    if (g != null && g.tiers != null) {
                        this.globalRewards = g;
                    }
                    this.globalRewards = new GlobalRewardsCfg();
                }
            } else {
                this.globalRewards = new GlobalRewardsCfg();
            }
            this.speciesRewards.clear();
            Path spDir = ConfigManager.getSpeciesRewardsDir();
            Files.createDirectories(spDir, new FileAttribute[0]);
            try (Stream<Path> stream = Files.list(spDir);){
                stream.filter(p -> p.toString().endsWith(".json")).forEach(p -> {
                    try (BufferedReader r = Files.newBufferedReader(p);){
                        ArrayList<RewardItemCfg> items = new ArrayList<RewardItemCfg>();
                        JsonElement je = JsonParser.parseReader((Reader)r);
                        String speciesField = null;
                        if (je != null && je.isJsonObject()) {
                            JsonObject obj = je.getAsJsonObject();
                            if (obj.has("species") && obj.get("species").isJsonPrimitive()) {
                                speciesField = obj.get("species").getAsString();
                            }
                            JsonArray arr = null;
                            if (obj.has("rewards") && obj.get("rewards").isJsonArray()) {
                                arr = obj.getAsJsonArray("rewards");
                            }
                            if (arr == null && obj.has("items") && obj.get("items").isJsonArray()) {
                                arr = obj.getAsJsonArray("items");
                            }
                            if (arr != null || obj.has("0")) {
                                // empty if block
                            }
                            if (arr == null && je.isJsonArray()) {
                                arr = je.getAsJsonArray();
                            }
                            if (arr != null) {
                                for (JsonElement e : arr) {
                                    try {
                                        JsonObject o = e.getAsJsonObject();
                                        RewardItemCfg ri = new RewardItemCfg();
                                        ri.id = o.get("id").getAsString();
                                        ri.count = o.has("count") ? Math.max(1, o.get("count").getAsInt()) : 1;
                                        items.add(ri);
                                    }
                                    catch (Exception o) {}
                                }
                            }
                        }
                        ArrayList<String> variants = new ArrayList<String>();
                        if (speciesField != null && !speciesField.isBlank()) {
                            String[] bases;
                            String s = speciesField.toLowerCase(Locale.ROOT).trim();
                            String unders = s.replace(' ', '_');
                            String hyph = s.replace(' ', '-');
                            String nospace = s.replace(" ", "");
                            for (String b : bases = new String[]{s, unders, hyph, nospace}) {
                                if (b == null || b.isBlank()) continue;
                                Object withNs = b.contains(":") ? b : "cobblemon:" + b;
                                this.speciesRewards.putIfAbsent((String)withNs, items);
                                this.speciesRewards.putIfAbsent(b, items);
                            }
                        } else {
                            String name = p.getFileName().toString();
                            String stem = name.substring(0, name.length() - 5).toLowerCase(Locale.ROOT);
                            variants.add(stem);
                            variants.add(stem.replace("_", ""));
                            variants.add(stem.replace("_", "-"));
                            variants.add(stem.replace(" ", ""));
                            variants.add(stem.replace(" ", "-"));
                            for (String v : variants) {
                                if (v == null || v.isBlank()) continue;
                                Object withNs = v.contains(":") ? v : "cobblemon:" + v;
                                this.speciesRewards.putIfAbsent((String)withNs, items);
                                this.speciesRewards.putIfAbsent(v, items);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        }
        catch (Exception e) {
            CobblemonMastery.LOGGER.warn("Failed to load rewards config", (Throwable)e);
        }
    }

    private void ensureBundledRewardDefaults(Path dir) {
        block30: {
            try {
                InputStream resG = MasteryManager.class.getResourceAsStream("/data/cobblemonresearchtasks/rewards/global.json");
                if (resG != null && !Files.exists(ConfigManager.getGlobalRewardsFile(), new LinkOption[0])) {
                    Files.createDirectories(dir, new FileAttribute[0]);
                    Files.copy(resG, ConfigManager.getGlobalRewardsFile(), new CopyOption[0]);
                }
                Path spDir = ConfigManager.getSpeciesRewardsDir();
                Files.createDirectories(spDir, new FileAttribute[0]);
                try (InputStream indexStream = MasteryManager.class.getResourceAsStream("/data/cobblemonresearchtasks/rewards/species/index.txt");){
                    if (indexStream != null) {
                        String content = new String(indexStream.readAllBytes(), StandardCharsets.UTF_8);
                        for (String line : content.split("\n")) {
                            Path target;
                            String name = line.trim();
                            if (name.isEmpty() || name.startsWith("#") || !name.endsWith(".json") || Files.exists(target = spDir.resolve(name), new LinkOption[0])) continue;
                            try (InputStream res = MasteryManager.class.getResourceAsStream("/data/cobblemonresearchtasks/rewards/species/" + name);){
                                if (res == null) continue;
                                Files.copy(res, target, new CopyOption[0]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        break block30;
                    }
                    try (InputStream resP = MasteryManager.class.getResourceAsStream("/data/cobblemonresearchtasks/rewards/species/pikachu.json");){
                        Path targetP = spDir.resolve("pikachu.json");
                        if (resP != null && !Files.exists(targetP, new LinkOption[0])) {
                            Files.copy(resP, targetP, new CopyOption[0]);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private JsonElement buildGlobalRewardsJson() {
        JsonObject root = new JsonObject();
        JsonArray tiers = new JsonArray();
        for (int i = 1; i <= 7; ++i) {
            JsonObject tier = new JsonObject();
            tier.addProperty("tier", (Number)i);
            JsonArray items = new JsonArray();
            List<RewardItemCfg> list = this.globalRewards.tiers.get(i);
            if (list != null) {
                for (RewardItemCfg it : list) {
                    JsonObject item = new JsonObject();
                    item.addProperty("id", it.id);
                    item.addProperty("count", (Number)Math.max(1, it.count));
                    items.add((JsonElement)item);
                }
            }
            tier.add("items", (JsonElement)items);
            tiers.add((JsonElement)tier);
        }
        root.add("tiers", (JsonElement)tiers);
        return root;
    }

    private JsonElement buildSpeciesRewardsJson() {
        JsonObject root = new JsonObject();
        for (Map.Entry<String, List<RewardItemCfg>> e : this.speciesRewards.entrySet()) {
            JsonArray items = new JsonArray();
            List<RewardItemCfg> list = e.getValue();
            if (list != null) {
                for (RewardItemCfg it : list) {
                    JsonObject item = new JsonObject();
                    item.addProperty("id", it.id);
                    item.addProperty("count", (Number)Math.max(1, it.count));
                    items.add((JsonElement)item);
                }
            }
            root.add(e.getKey(), (JsonElement)items);
        }
        return root;
    }

    public void claimGlobalTier(class_3222 sp, int tier) {
        if (sp == null || tier < 1 || tier > 7) {
            return;
        }
        UUID uuid = sp.method_5667();
        PlayerMasteryData data = this.perPlayer.computeIfAbsent(uuid, k -> new PlayerMasteryData());
        if (data.claimedGlobalTiers.contains(tier)) {
            return;
        }
        int[] required = new int[]{10, 25, 40, 55, 70, 85, 100};
        float pct = this.computeOverallCompletionPercent(data);
        if ((double)pct + 1.0E-6 < (double)required[tier - 1]) {
            this.sendActionBar(sp, "Not enough completion for tier " + tier);
            return;
        }
        List<RewardItemCfg> items = this.globalRewards.tiers.get(tier);
        if (items == null || items.isEmpty()) {
            this.sendActionBar(sp, "No rewards configured for tier " + tier);
            return;
        }
        this.giveRewards(sp, items);
        data.claimedGlobalTiers.add(tier);
        this.sendActionBar(sp, "Completed Tier " + tier + " of the Research Tasks");
    }

    public void claimSpeciesReward(class_3222 sp, String speciesKey) {
        if (sp == null || speciesKey == null) {
            return;
        }
        Object key = speciesKey.toLowerCase(Locale.ROOT);
        if (!((String)key).contains(":")) {
            key = "cobblemon:" + (String)key;
        }
        UUID uuid = sp.method_5667();
        PlayerMasteryData data = this.perPlayer.computeIfAbsent(uuid, k -> new PlayerMasteryData());
        if (data.claimedSpeciesRewards.contains(key)) {
            return;
        }
        if (!this.isSpeciesComplete(uuid, (String)key)) {
            this.sendActionBar(sp, "Complete all tasks first");
            return;
        }
        List<RewardItemCfg> items = this.speciesRewards.get(key);
        if (items == null || items.isEmpty()) {
            this.sendActionBar(sp, "No rewards configured for this Pok\u00e9mon");
            return;
        }
        this.giveRewards(sp, items);
        data.claimedSpeciesRewards.add((String)key);
        this.sendActionBar(sp, "Claimed species reward");
    }

    private void giveRewards(class_3222 sp, List<RewardItemCfg> items) {
        for (RewardItemCfg it : items) {
            class_1792 item;
            class_2960 id;
            if (it == null || it.id == null || (id = class_2960.method_12829((String)it.id)) == null || (item = (class_1792)class_7923.field_41178.method_17966(id).orElse(null)) == null) continue;
            class_1799 stack = new class_1799((class_1935)item, Math.max(1, it.count));
            boolean added = sp.method_31548().method_7394(stack.method_7972());
            if (added) continue;
            sp.method_7328(stack, false);
        }
    }

    private boolean isSpeciesComplete(UUID player, String speciesKey) {
        SpeciesTasks tasks = this.getSpeciesTasks(speciesKey);
        if (tasks == null || tasks.tasks == null || tasks.tasks.isEmpty()) {
            return false;
        }
        PlayerMasteryData data = this.perPlayer.get(player);
        if (data == null) {
            return false;
        }
        SpeciesMastery sm = data.species.get(speciesKey.toLowerCase(Locale.ROOT));
        if (sm == null) {
            return false;
        }
        Set<String> comp = sm.getTaskCompletedSetCopy();
        Map<String, Integer> prog = sm.getTaskProgressMapCopy();
        int completed = 0;
        for (TaskDefinition t : tasks.tasks) {
            boolean done = comp.contains(t.id);
            if (!done) {
                switch (t.type) {
                    case DEFEAT_ANY_COUNT: 
                    case DEFEAT_SPECIES: 
                    case DEFEAT_TYPE_COUNT: 
                    case LEVEL_UP_COUNT: 
                    case FISH_THIS: {
                        int p = prog.getOrDefault(t.id, 0);
                        if (p < Math.max(1, t.getAmountOrDefault(1))) break;
                        done = true;
                        break;
                    }
                    case FRIENDSHIP_AT_LEAST: {
                        int thr;
                        int p = prog.getOrDefault(t.id, 0);
                        int n = thr = t.friendship != null ? t.friendship.intValue() : t.getAmountOrDefault(1);
                        if (p < Math.max(1, thr)) break;
                        done = true;
                        break;
                    }
                }
            }
            if (!done) continue;
            ++completed;
        }
        return completed >= tasks.tasks.size();
    }

    private SpeciesMastery resolveSpeciesMastery(PlayerMasteryData data, String key) {
        if (data == null || key == null) {
            return null;
        }
        String k = key.toLowerCase(Locale.ROOT);
        SpeciesMastery sm = data.species.get(k);
        if (sm != null) {
            return sm;
        }
        for (String v : this.buildKeyVariants(k)) {
            sm = data.species.get(v);
            if (sm == null) continue;
            return sm;
        }
        return null;
    }

    private float computeOverallCompletionPercent(PlayerMasteryData data) {
        if (data == null) {
            return 0.0f;
        }
        int total = 0;
        int completed = 0;
        for (Map.Entry<String, SpeciesTasks> entry : this.speciesTasks.entrySet()) {
            Set<Object> compSet;
            SpeciesTasks st = entry.getValue();
            if (st == null || st.tasks == null) continue;
            total += st.tasks.size();
            SpeciesMastery sm = this.resolveSpeciesMastery(data, entry.getKey());
            Set<Object> set = compSet = sm != null ? sm.getTaskCompletedSetCopy() : Collections.emptySet();
            if (sm == null) continue;
            Map<String, Integer> prog = sm.getTaskProgressMapCopy();
            for (TaskDefinition t : st.tasks) {
                boolean done = compSet.contains(t.id);
                if (!done) {
                    switch (t.type) {
                        case DEFEAT_ANY_COUNT: 
                        case DEFEAT_SPECIES: 
                        case DEFEAT_TYPE_COUNT: 
                        case LEVEL_UP_COUNT: 
                        case FISH_THIS: {
                            int p = prog.getOrDefault(t.id, 0);
                            if (p < Math.max(1, t.getAmountOrDefault(1))) break;
                            done = true;
                            break;
                        }
                        case FRIENDSHIP_AT_LEAST: {
                            int thr;
                            int p = prog.getOrDefault(t.id, 0);
                            int n = thr = t.friendship != null ? t.friendship.intValue() : t.getAmountOrDefault(1);
                            if (p < Math.max(1, thr)) break;
                            done = true;
                            break;
                        }
                    }
                }
                if (!done) continue;
                ++completed;
            }
        }
        if (total <= 0) {
            return 0.0f;
        }
        return (float)completed * 100.0f / (float)total;
    }

    private List<String> buildKeyVariants(String raw) {
        String base;
        String k = raw == null ? "" : raw.toLowerCase(Locale.ROOT).trim();
        LinkedHashSet<Object> out = new LinkedHashSet<Object>();
        if (k.isEmpty()) {
            return new ArrayList<String>();
        }
        String ns = base = k;
        String path = base;
        int c = base.indexOf(":");
        if (c >= 0) {
            ns = base.substring(0, c);
            path = base.substring(c + 1);
        } else {
            ns = "cobblemon";
            path = base;
        }
        ArrayList<String> pathVars = new ArrayList<String>();
        pathVars.add(path);
        pathVars.add(path.replace(' ', '_'));
        pathVars.add(path.replace(' ', '-'));
        pathVars.add(path.replace(" ", ""));
        pathVars.add(path.replace('_', ' '));
        pathVars.add(path.replace('-', ' '));
        pathVars.add(path.replace("_", ""));
        pathVars.add(path.replace("-", ""));
        for (String p : pathVars) {
            if (p == null || p.isBlank()) continue;
            out.add(p);
            out.add(ns + ":" + p);
            if ("cobblemon".equals(ns)) continue;
            out.add("cobblemon:" + p);
        }
        out.add(base);
        return new ArrayList<String>(out);
    }

    public void sendActionBar(class_3222 sp, String msg) {
        if (sp == null || msg == null) {
            return;
        }
        sp.method_7353((class_2561)class_2561.method_43470((String)msg).method_27692(class_124.field_1065), true);
    }

    private SpeciesMastery getOrCreateSpeciesMastery(UUID player, String speciesKey) {
        PlayerMasteryData data = this.perPlayer.computeIfAbsent(player, k -> new PlayerMasteryData());
        return data.getOrCreate(speciesKey.toLowerCase(Locale.ROOT));
    }

    private String prettifySpecies(String speciesKey) {
        String path;
        if (speciesKey == null) {
            return "this Pok\u00e9mon";
        }
        String k = speciesKey;
        int idx = k.indexOf(":");
        String string = path = idx >= 0 ? k.substring(idx + 1) : k;
        if (path.isEmpty()) {
            return "this Pok\u00e9mon";
        }
        return Character.toUpperCase(path.charAt(0)) + path.substring(1);
    }

    private String buildTaskLabel(String speciesKey, TaskDefinition t) {
        if (t == null || t.type == null) {
            return "Task";
        }
        if (t.title != null && !t.title.isBlank()) {
            return t.title;
        }
        String s = this.prettifySpecies(speciesKey);
        int amt = t.getAmountOrDefault(1);
        String type = t.targetType != null ? t.targetType : "";
        String targetSpecies = t.targetSpecies != null ? t.targetSpecies : "target";
        switch (t.type) {
            case DEFEAT_ANY_COUNT: {
                return "Defeat " + amt + " Pok\u00e9mon using " + s;
            }
            case CAPTURE_THIS: {
                return amt > 1 ? "Capture this Pok\u00e9mon " + amt + "\u00d7" : "Capture this Pok\u00e9mon";
            }
            case EVOLVE_THIS: {
                return "Evolve this Pok\u00e9mon";
            }
            case DEFEAT_SPECIES: {
                return "Defeat " + targetSpecies + " " + amt + "\u00d7 using " + s;
            }
            case DEFEAT_TYPE_COUNT: {
                return "Defeat " + amt + " " + type + "-type Pok\u00e9mon using " + s;
            }
            case FRIENDSHIP_AT_LEAST: {
                return "Reach friendship " + (t.friendship != null ? t.friendship : amt) + "+ with " + s;
            }
            case FISH_THIS: {
                return "Fish up this Pok\u00e9mon " + amt + "\u00d7";
            }
            case LEVEL_UP_COUNT: {
                return "Level up " + s + " " + amt + "\u00d7";
            }
        }
        return "Task";
    }

    public synchronized void handleDefeat(UUID player, String attackerSpecies, String targetSpecies, Set<String> targetTypesLower) {
        this.handleDefeatWithNotify(null, player, attackerSpecies, targetSpecies, targetTypesLower);
    }

    public synchronized void handleDefeatWithNotify(class_3222 sp, UUID player, String attackerSpecies, String targetSpecies, Set<String> targetTypesLower) {
        if (attackerSpecies == null) {
            return;
        }
        String attackerKey = attackerSpecies.toLowerCase(Locale.ROOT);
        SpeciesTasks tasks = this.getSpeciesTasks(attackerKey);
        if (tasks == null || tasks.tasks == null) {
            return;
        }
        PlayerMasteryData data = this.perPlayer.computeIfAbsent(player, k -> new PlayerMasteryData());
        SpeciesMastery sm = data.getOrCreate(attackerKey);
        block5: for (TaskDefinition t : tasks.tasks) {
            switch (t.type) {
                case DEFEAT_ANY_COUNT: {
                    int before = sm.getTaskProgress(t.id);
                    sm.addTaskProgress(t.id, 1);
                    this.maybeNotifyCompleted(sp, attackerKey, t, before);
                    break;
                }
                case DEFEAT_SPECIES: {
                    if (t.targetSpecies == null) break;
                    String tgt = t.targetSpecies.toLowerCase(Locale.ROOT);
                    boolean match = false;
                    if (targetSpecies != null) {
                        String ts = targetSpecies.toLowerCase(Locale.ROOT);
                        if (ts.equals(tgt)) {
                            match = true;
                        }
                        int colon = ts.indexOf(":");
                        if (!match && colon >= 0) {
                            match = ts.substring(colon + 1).equals(tgt);
                        }
                        if (!match && colon < 0) {
                            match = ("cobblemon:" + ts).equals(tgt);
                        }
                    }
                    if (!match) continue block5;
                    int before = sm.getTaskProgress(t.id);
                    sm.addTaskProgress(t.id, 1);
                    this.maybeNotifyCompleted(sp, attackerKey, t, before);
                    break;
                }
                case DEFEAT_TYPE_COUNT: {
                    if (t.targetType == null || targetTypesLower == null || targetTypesLower.isEmpty() || !targetTypesLower.contains(t.targetType.toLowerCase(Locale.ROOT))) break;
                    int before = sm.getTaskProgress(t.id);
                    sm.addTaskProgress(t.id, 1);
                    this.maybeNotifyCompleted(sp, attackerKey, t, before);
                    break;
                }
            }
        }
    }

    public synchronized void handleEvolve(UUID player, String species) {
        this.handleEvolveWithNotify(null, player, species);
    }

    public synchronized void handleEvolveWithNotify(class_3222 sp, UUID player, String species) {
        String key = species.toLowerCase(Locale.ROOT);
        SpeciesTasks tasks = this.getSpeciesTasks(key);
        if (tasks == null || tasks.tasks == null) {
            return;
        }
        PlayerMasteryData data = this.perPlayer.computeIfAbsent(player, k -> new PlayerMasteryData());
        SpeciesMastery sm = data.getOrCreate(key);
        for (TaskDefinition t : tasks.tasks) {
            if (t.type != TaskType.EVOLVE_THIS) continue;
            boolean was = sm.isTaskCompleted(t.id);
            sm.setTaskCompleted(t.id);
            if (was || sp == null) continue;
            this.sendActionBar(sp, "Completed: " + this.buildTaskLabel(key, t));
        }
    }

    public synchronized void handleLevelUp(UUID player, String species, int levelsGained) {
        this.handleLevelUpWithNotify(null, player, species, levelsGained);
    }

    public synchronized void handleLevelUpWithNotify(class_3222 sp, UUID player, String species, int levelsGained) {
        String key;
        SpeciesTasks tasks;
        if (levelsGained <= 0) {
            levelsGained = 1;
        }
        if ((tasks = this.getSpeciesTasks(key = species.toLowerCase(Locale.ROOT))) == null || tasks.tasks == null) {
            return;
        }
        PlayerMasteryData data = this.perPlayer.computeIfAbsent(player, k -> new PlayerMasteryData());
        SpeciesMastery sm = data.getOrCreate(key);
        for (TaskDefinition t : tasks.tasks) {
            if (t.type != TaskType.LEVEL_UP_COUNT) continue;
            int before = sm.getTaskProgress(t.id);
            sm.addTaskProgress(t.id, levelsGained);
            this.maybeNotifyCompleted(sp, key, t, before);
        }
    }

    private void maybeNotifyCompleted(class_3222 sp, String speciesKey, TaskDefinition t, int before) {
        boolean completedNow;
        if (sp == null) {
            return;
        }
        int target = 1;
        target = t.type == TaskType.FRIENDSHIP_AT_LEAST ? Math.max(1, t.friendship != null ? t.friendship.intValue() : t.getAmountOrDefault(1)) : (t.type == TaskType.EVOLVE_THIS ? 1 : (t.type == TaskType.CAPTURE_THIS ? Math.max(1, t.getAmountOrDefault(1)) : Math.max(1, t.getAmountOrDefault(1))));
        PlayerMasteryData data = this.perPlayer.computeIfAbsent(sp.method_5667(), k -> new PlayerMasteryData());
        SpeciesMastery sm = data.getOrCreate(speciesKey);
        int after = sm.getTaskProgress(t.id);
        boolean bl = completedNow = before < target && after >= target;
        if (completedNow) {
            this.sendActionBar(sp, "Completed: " + this.buildTaskLabel(speciesKey, t));
        }
    }

    public synchronized void handleFishing(UUID player, String species) {
        this.handleFishingWithNotify(null, player, species);
    }

    public synchronized void handleFishingWithNotify(class_3222 sp, UUID player, String species) {
        if (species == null) {
            return;
        }
        String key = species.toLowerCase(Locale.ROOT);
        SpeciesTasks tasks = this.getSpeciesTasks(key);
        if (tasks == null || tasks.tasks == null) {
            return;
        }
        PlayerMasteryData data = this.perPlayer.computeIfAbsent(player, k -> new PlayerMasteryData());
        SpeciesMastery sm = data.getOrCreate(key);
        for (TaskDefinition t : tasks.tasks) {
            if (t.type != TaskType.FISH_THIS) continue;
            int before = sm.getTaskProgress(t.id);
            sm.addTaskProgress(t.id, 1);
            this.maybeNotifyCompleted(sp, key, t, before);
        }
    }

    public synchronized void updateFriendship(UUID player, String species, int friendship) {
        this.updateFriendshipWithNotify(null, player, species, friendship);
    }

    public synchronized void updateFriendshipWithNotify(class_3222 sp, UUID player, String species, int friendship) {
        String key = species.toLowerCase(Locale.ROOT);
        SpeciesTasks tasks = this.getSpeciesTasks(key);
        if (tasks == null || tasks.tasks == null) {
            return;
        }
        PlayerMasteryData data = this.perPlayer.computeIfAbsent(player, k -> new PlayerMasteryData());
        SpeciesMastery sm = data.getOrCreate(key);
        for (TaskDefinition t : tasks.tasks) {
            boolean crossed;
            if (t.type != TaskType.FRIENDSHIP_AT_LEAST) continue;
            int before = sm.getTaskProgress(t.id);
            if (friendship > before) {
                sm.addTaskProgress(t.id, friendship - before);
            }
            int thr = t.friendship != null ? t.friendship.intValue() : t.getAmountOrDefault(1);
            boolean wasCompleted = sm.isTaskCompleted(t.id);
            if (friendship >= thr) {
                sm.setTaskCompleted(t.id);
            }
            if (sp == null) continue;
            int after = sm.getTaskProgress(t.id);
            boolean bl = crossed = before < thr && after >= thr;
            if (wasCompleted || !crossed) continue;
            this.sendActionBar(sp, "Completed: " + this.buildTaskLabel(key, t));
        }
    }

    public void scanAndUpdateFriendship(MinecraftServer server) {
        try {
            List playerList = server.method_3760().method_14571();
            for (class_3222 sp : playerList) {
                try {
                    List<?> list;
                    Object party = this.getParty(sp);
                    if (party == null || (list = this.getPartyList(party)) == null) continue;
                    for (Object p : list) {
                        try {
                            String speciesKey = this.getSpeciesIdentifierFromPokemon(p);
                            if (speciesKey == null) continue;
                            int fs = this.getFriendshipFromPokemon(p);
                            this.updateFriendship(sp.method_5667(), speciesKey, fs);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Object getParty(class_3222 sp) {
        try {
            Class<?> prov = Class.forName("com.cobblemon.mod.common.api.storage.party.PartyProvider");
            try {
                return prov.getMethod("get", class_3222.class).invoke(null, sp);
            }
            catch (NoSuchMethodException e) {
                Object comp = prov.getField("Companion").get(null);
                return comp.getClass().getMethod("get", class_3222.class).invoke(comp, sp);
            }
        }
        catch (Throwable t) {
            return null;
        }
    }

    private List<?> getPartyList(Object party) {
        try {
            Object list = party.getClass().getMethod("getAll", new Class[0]).invoke(party, new Object[0]);
            if (list instanceof List) {
                List l = (List)list;
                return l;
            }
        }
        catch (Throwable list) {
            // empty catch block
        }
        try {
            Object arr = party.getClass().getMethod("toList", new Class[0]).invoke(party, new Object[0]);
            if (arr instanceof List) {
                List l = (List)arr;
                return l;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private int getFriendshipFromPokemon(Object pokemon) {
        try {
            Object val = pokemon.getClass().getMethod("getFriendship", new Class[0]).invoke(pokemon, new Object[0]);
            if (val instanceof Number) {
                Number n = (Number)val;
                return n.intValue();
            }
            return Integer.parseInt(String.valueOf(val));
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private String getSpeciesIdentifierFromPokemon(Object pokemon) {
        try {
            Object species = pokemon.getClass().getMethod("getSpecies", new Class[0]).invoke(pokemon, new Object[0]);
            if (species == null) {
                return null;
            }
            try {
                Object idObj = species.getClass().getMethod("getIdentifier", new Class[0]).invoke(species, new Object[0]);
                if (idObj instanceof class_2960) {
                    class_2960 id = (class_2960)idObj;
                    return id.toString().toLowerCase(Locale.ROOT);
                }
                if (idObj != null) {
                    return String.valueOf(idObj).toLowerCase(Locale.ROOT);
                }
            }
            catch (Throwable idObj) {
                // empty catch block
            }
            try {
                String name = String.valueOf(species.getClass().getMethod("getName", new Class[0]).invoke(species, new Object[0]));
                if (name != null && !name.isBlank()) {
                    String path = name.toLowerCase(Locale.ROOT);
                    if (path.contains(":")) {
                        return path;
                    }
                    return "cobblemon:" + path;
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private MasteryManager() {
        try {
            this.loadDefaultConfigs();
            this.loadSpeciesConfigs();
            this.refreshTasks();
            this.loadRewardConfigs();
        }
        catch (Exception e) {
            CobblemonMastery.LOGGER.error("Failed loading mastery species configs", (Throwable)e);
        }
    }

    private void loadDefaultConfigs() {
        try {
            String[] defaultConfigs;
            for (String configFile : defaultConfigs = new String[]{"pikachu.json", "charizard.json", "mewtwo.json", "articuno.json", "bulbasaur.json", "squirtle.json", "charmander.json", "eevee.json", "lucario.json", "garchomp.json", "rayquaza.json", "dialga.json"}) {
                try (InputStream is = this.getClass().getResourceAsStream("/data/cobblemonresearchtasks/pokemon_configs/" + configFile);){
                    if (is == null) continue;
                    try (InputStreamReader r = new InputStreamReader(is);){
                        SpeciesCfg cfg = (SpeciesCfg)this.gson.fromJson((Reader)r, SpeciesCfg.class);
                        if (cfg == null || cfg.species == null) continue;
                        cfg.species = cfg.species.toLowerCase(Locale.ROOT);
                        this.ensureDefaultLevels(cfg);
                        this.bySpecies.put(cfg.species, cfg);
                    }
                }
                catch (Exception e) {
                    CobblemonMastery.LOGGER.debug("Couldn't load default config: {}", (Object)configFile);
                }
            }
            this.copyDefaultConfigsToFolder();
        }
        catch (Exception e) {
            CobblemonMastery.LOGGER.warn("Failed to load bundled defaults", (Throwable)e);
        }
    }

    private void copyDefaultConfigsToFolder() {
        try {
            Path configDir = ConfigManager.getPokemonConfigDir();
            Files.createDirectories(configDir, new FileAttribute[0]);
            for (String speciesName : this.bySpecies.keySet()) {
                Path targetFile = configDir.resolve(speciesName + ".json");
                if (Files.exists(targetFile, new LinkOption[0])) continue;
                BufferedWriter w = Files.newBufferedWriter(targetFile, new OpenOption[0]);
                try {
                    this.gson.toJson((Object)this.bySpecies.get(speciesName), (Appendable)w);
                    CobblemonMastery.LOGGER.info("Created default config: {}.json", (Object)speciesName);
                }
                finally {
                    if (w == null) continue;
                    ((Writer)w).close();
                }
            }
        }
        catch (Exception e) {
            CobblemonMastery.LOGGER.warn("Failed to copy default configs", (Throwable)e);
        }
    }

    private void ensureDefaultLevels(SpeciesCfg cfg) {
        int maxLevel = cfg.is_legendary ? 3 : 5;
        for (int i = 1; i <= maxLevel; ++i) {
            cfg.levels.putIfAbsent(i, this.defaultLevel(i, cfg.is_legendary));
        }
    }

    private LevelCfg defaultLevel(int idx, boolean isLegendary) {
        LevelCfg l = new LevelCfg();
        if (isLegendary) {
            switch (idx) {
                case 1: {
                    l.required_amount = 25;
                    l.reward_id = "minecraft:diamond_block";
                    l.reward_count = 2;
                    break;
                }
                case 2: {
                    l.required_amount = 75;
                    l.reward_id = "minecraft:netherite_ingot";
                    l.reward_count = 4;
                    break;
                }
                case 3: {
                    l.required_amount = 150;
                    l.reward_id = "minecraft:nether_star";
                    l.reward_count = 1;
                }
            }
        } else {
            switch (idx) {
                case 1: {
                    l.required_amount = 10;
                    l.reward_id = "minecraft:iron_ingot";
                    l.reward_count = 8;
                    break;
                }
                case 2: {
                    l.required_amount = 25;
                    l.reward_id = "minecraft:gold_ingot";
                    l.reward_count = 8;
                    break;
                }
                case 3: {
                    l.required_amount = 50;
                    l.reward_id = "minecraft:diamond";
                    l.reward_count = 4;
                    break;
                }
                case 4: {
                    l.required_amount = 100;
                    l.reward_id = "minecraft:emerald";
                    l.reward_count = 8;
                    break;
                }
                case 5: {
                    l.required_amount = 150;
                    l.reward_id = "minecraft:netherite_scrap";
                    l.reward_count = 2;
                }
            }
        }
        return l;
    }

    private void loadSpeciesConfigs() throws Exception {
        Path dir = ConfigManager.getPokemonConfigDir();
        Files.createDirectories(dir, new FileAttribute[0]);
        try (Stream<Path> stream = Files.list(dir);){
            stream.filter(p -> p.toString().endsWith(".json")).forEach(path -> {
                try (BufferedReader r = Files.newBufferedReader(path);){
                    SpeciesCfg cfg = (SpeciesCfg)this.gson.fromJson((Reader)r, SpeciesCfg.class);
                    if (cfg != null && cfg.species != null) {
                        cfg.species = cfg.species.toLowerCase(Locale.ROOT);
                        this.ensureDefaultLevels(cfg);
                        this.bySpecies.put(cfg.species, cfg);
                        CobblemonMastery.LOGGER.debug("Loaded user config: {}", (Object)cfg.species);
                    }
                }
                catch (Exception e) {
                    CobblemonMastery.LOGGER.warn("Bad species config {}: {}", (Object)path.getFileName(), (Object)e.toString());
                }
            });
        }
    }

    public SpeciesCfg getSpeciesCfg(String species, int dexIfKnown) {
        String key = species.toLowerCase(Locale.ROOT);
        SpeciesCfg cfg = this.bySpecies.get(key);
        if (cfg == null) {
            cfg = new SpeciesCfg();
            cfg.species = key;
            cfg.dex = dexIfKnown;
            cfg.is_legendary = false;
            this.ensureDefaultLevels(cfg);
            this.bySpecies.put(key, cfg);
        }
        return cfg;
    }

    public synchronized void incrementProgress(UUID player, String species, int amount) {
        PlayerMasteryData data = this.perPlayer.computeIfAbsent(player, k -> new PlayerMasteryData());
        data.addProgress(species, amount);
    }

    public synchronized void handleCapture(UUID player, String species) {
        this.handleCaptureWithNotify(null, player, species);
    }

    public synchronized void handleCaptureWithNotify(class_3222 sp, UUID player, String species) {
        String key = species.toLowerCase(Locale.ROOT);
        SpeciesTasks tasks = this.getSpeciesTasks(key);
        if (tasks == null || tasks.tasks == null) {
            return;
        }
        PlayerMasteryData data = this.perPlayer.computeIfAbsent(player, k -> new PlayerMasteryData());
        SpeciesMastery sm = data.getOrCreate(key);
        for (TaskDefinition t : tasks.tasks) {
            if (t.type != TaskType.CAPTURE_THIS) continue;
            int before = sm.getTaskProgress(t.id);
            sm.addTaskProgress(t.id, 1);
            int target = Math.max(1, t.getAmountOrDefault(1));
            if (sm.getTaskProgress(t.id) >= target) {
                sm.setTaskCompleted(t.id);
            }
            this.maybeNotifyCompleted(sp, key, t, before);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String buildPlayerSnapshotJson(UUID player) {
        void var6_11;
        PlayerMasteryData data = this.perPlayer.get(player);
        JsonObject root = new JsonObject();
        JsonObject speciesObj = new JsonObject();
        if (data != null) {
            for (Map.Entry<String, SpeciesMastery> entry : data.species.entrySet()) {
                boolean bl;
                String species = entry.getKey();
                SpeciesMastery sm = entry.getValue();
                JsonObject sObj = new JsonObject();
                JsonObject prog = new JsonObject();
                for (Map.Entry<String, Integer> entry2 : sm.getTaskProgressMapCopy().entrySet()) {
                    prog.addProperty(entry2.getKey(), (Number)entry2.getValue());
                }
                sObj.add("progress", (JsonElement)prog);
                JsonArray comp = new JsonArray();
                for (String id : sm.getTaskCompletedSetCopy()) {
                    comp.add(id);
                }
                sObj.add("completed", (JsonElement)comp);
                boolean bl2 = false;
                SpeciesTasks stasks = this.getSpeciesTasks(species);
                if (stasks != null && stasks.tasks != null && !stasks.tasks.isEmpty()) {
                    Set<String> compSet = sm.getTaskCompletedSetCopy();
                    Map<String, Integer> pmap = sm.getTaskProgressMapCopy();
                    int done = 0;
                    for (TaskDefinition t : stasks.tasks) {
                        boolean ok = compSet.contains(t.id);
                        if (!ok) {
                            switch (t.type) {
                                case DEFEAT_ANY_COUNT: 
                                case DEFEAT_SPECIES: 
                                case DEFEAT_TYPE_COUNT: 
                                case LEVEL_UP_COUNT: 
                                case FISH_THIS: 
                                case CAPTURE_THIS: {
                                    int p = pmap.getOrDefault(t.id, 0);
                                    if (p < Math.max(1, t.getAmountOrDefault(1))) break;
                                    ok = true;
                                    break;
                                }
                                case FRIENDSHIP_AT_LEAST: {
                                    int thr;
                                    int p = pmap.getOrDefault(t.id, 0);
                                    int n = thr = t.friendship != null ? t.friendship.intValue() : t.getAmountOrDefault(1);
                                    if (p < Math.max(1, thr)) break;
                                    ok = true;
                                    break;
                                }
                            }
                        }
                        if (!ok) continue;
                        ++done;
                    }
                    bl = done >= stasks.tasks.size();
                }
                sObj.addProperty("allCompleted", Boolean.valueOf(bl));
                speciesObj.add(species, (JsonElement)sObj);
            }
            JsonArray claimedGlobal = new JsonArray();
            for (int tier : data.claimedGlobalTiers) {
                claimedGlobal.add((Number)tier);
            }
            root.add("claimedGlobal", (JsonElement)claimedGlobal);
            JsonArray jsonArray = new JsonArray();
            for (String sp : data.claimedSpeciesRewards) {
                jsonArray.add(sp);
            }
            root.add("claimedSpecies", (JsonElement)jsonArray);
        }
        root.add("species", (JsonElement)speciesObj);
        int totalTasks = 0;
        boolean bl = false;
        for (Map.Entry<String, SpeciesTasks> entry : this.speciesTasks.entrySet()) {
            Set<Object> compSet;
            SpeciesTasks st = entry.getValue();
            if (st == null || st.tasks == null) continue;
            totalTasks += st.tasks.size();
            SpeciesMastery sm = data != null ? this.resolveSpeciesMastery(data, entry.getKey()) : null;
            Set<Object> set = compSet = sm != null ? sm.getTaskCompletedSetCopy() : Collections.emptySet();
            if (sm == null) continue;
            Map<String, Integer> map = sm.getTaskProgressMapCopy();
            for (TaskDefinition t : st.tasks) {
                boolean done = compSet.contains(t.id);
                if (!done) {
                    switch (t.type) {
                        case DEFEAT_ANY_COUNT: 
                        case DEFEAT_SPECIES: 
                        case DEFEAT_TYPE_COUNT: 
                        case LEVEL_UP_COUNT: 
                        case FISH_THIS: 
                        case CAPTURE_THIS: {
                            int p = map.getOrDefault(t.id, 0);
                            if (p < Math.max(1, t.getAmountOrDefault(1))) break;
                            done = true;
                            break;
                        }
                        case FRIENDSHIP_AT_LEAST: {
                            int thr;
                            int p = map.getOrDefault(t.id, 0);
                            int n = thr = t.friendship != null ? t.friendship.intValue() : t.getAmountOrDefault(1);
                            if (p < Math.max(1, thr)) break;
                            done = true;
                            break;
                        }
                        case EVOLVE_THIS: {
                            break;
                        }
                    }
                }
                if (!done) continue;
                ++var6_11;
            }
        }
        root.addProperty("totalTasks", (Number)totalTasks);
        root.addProperty("completedTasks", (Number)((int)var6_11));
        root.add("globalRewards", this.buildGlobalRewardsJson());
        root.add("speciesRewards", this.buildSpeciesRewardsJson());
        return new Gson().toJson((JsonElement)root);
    }

    public synchronized int getProgress(UUID player, String species) {
        PlayerMasteryData data = this.perPlayer.get(player);
        if (data == null) {
            return 0;
        }
        return data.getProgress(species);
    }

    public synchronized SpeciesMastery getPlayerMastery(UUID player, String species) {
        PlayerMasteryData data = this.perPlayer.get(player);
        if (data == null) {
            return null;
        }
        return data.species.get(species.toLowerCase(Locale.ROOT));
    }

    public synchronized boolean claim(UUID player, String species, int level) {
        PlayerMasteryData data = this.perPlayer.computeIfAbsent(player, k -> new PlayerMasteryData());
        SpeciesMastery sm = data.getOrCreate(species);
        if (sm.isClaimed(level)) {
            return false;
        }
        SpeciesCfg cfg = this.getSpeciesCfg(species, 0);
        LevelCfg l = cfg.levels.get(level);
        if (l == null) {
            return false;
        }
        if (sm.getProgress() < l.required_amount) {
            return false;
        }
        sm.setClaimed(level);
        return true;
    }

    public class_1799 rewardStack(String species, int level) {
        SpeciesCfg cfg = this.getSpeciesCfg(species, 0);
        LevelCfg l = cfg.levels.get(level);
        if (l == null) {
            return class_1799.field_8037;
        }
        class_2960 id = class_2960.method_12829((String)l.reward_id);
        if (id == null) {
            return class_1799.field_8037;
        }
        class_1792 item = class_7923.field_41178.method_17966(id).orElse(null);
        if (item == null) {
            return class_1799.field_8037;
        }
        return new class_1799((class_1935)item, Math.max(1, l.reward_count));
    }

    public class_2487 toNbt(UUID uuid) {
        PlayerMasteryData data = this.perPlayer.get(uuid);
        return data == null ? new class_2487() : data.toNbt();
    }

    public void fromNbt(UUID uuid, class_2487 tag) {
        this.perPlayer.put(uuid, PlayerMasteryData.fromNbt(tag));
    }

    public void loadBackup(Path worldDir, UUID uuid) {
        block9: {
            try {
                Path dir = ConfigManager.getBackupPlayerDataDir(worldDir);
                Path file = dir.resolve(uuid.toString() + ".json");
                if (!Files.exists(file, new LinkOption[0])) break block9;
                try (BufferedReader r = Files.newBufferedReader(file);){
                    PlayerMasteryData d = (PlayerMasteryData)this.gson.fromJson((Reader)r, PlayerMasteryData.class);
                    if (d != null) {
                        this.perPlayer.put(uuid, d);
                    }
                }
            }
            catch (Exception e) {
                CobblemonMastery.LOGGER.warn("Failed to load backup for {}", (Object)uuid, (Object)e);
            }
        }
    }

    public void saveBackup(Path worldDir, UUID uuid) {
        try {
            PlayerMasteryData d = this.perPlayer.get(uuid);
            if (d == null) {
                return;
            }
            Path dir = ConfigManager.getBackupPlayerDataDir(worldDir);
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve(uuid.toString() + ".json");
            try (BufferedWriter w = Files.newBufferedWriter(file, new OpenOption[0]);){
                this.gson.toJson((Object)d, (Appendable)w);
            }
        }
        catch (Exception e) {
            CobblemonMastery.LOGGER.warn("Failed to save backup for {}", (Object)uuid, (Object)e);
        }
    }

    public void autosave(MinecraftServer server) {
        Path worldDir = server.method_27050(class_5218.field_24188);
        for (class_3222 player : server.method_3760().method_14571()) {
            this.saveBackup(worldDir, player.method_5667());
        }
    }

    public void ensureResearchBookGranted(class_3222 sp, Path worldDir) {
        if (sp == null) {
            return;
        }
        UUID uuid = sp.method_5667();
        PlayerMasteryData data = this.perPlayer.computeIfAbsent(uuid, k -> new PlayerMasteryData());
        if (data.gaveResearchBook) {
            return;
        }
        class_1792 item = class_7923.field_41178.method_17966(class_2960.method_60655((String)"cobblemonresearchtasks", (String)"research_book")).orElse(null);
        if (item != null) {
            class_1799 stack = new class_1799((class_1935)item, 1);
            boolean added = sp.method_31548().method_7394(stack.method_7972());
            if (!added) {
                sp.method_7328(stack, false);
            }
            data.gaveResearchBook = true;
            this.saveBackup(worldDir, uuid);
        }
    }

    public static class GlobalRewardsCfg {
        public Map<Integer, List<RewardItemCfg>> tiers = new HashMap<Integer, List<RewardItemCfg>>();
    }

    public static class RewardItemCfg {
        public String id;
        public int count = 1;
    }

    public static class SpeciesCfg {
        public String species = "";
        public int dex = 0;
        public boolean is_legendary = false;
        public Map<Integer, LevelCfg> levels = new HashMap<Integer, LevelCfg>();
    }

    public static class LevelCfg {
        public int required_amount = 10;
        public String reward_id = "minecraft:air";
        public int reward_count = 0;
    }

    public static class SpeciesRewardCfg {
        public Map<String, List<RewardItemCfg>> rewards = new HashMap<String, List<RewardItemCfg>>();
    }
}

