/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.storage;

import github.jorgaomc.storage.SpeciesMastery;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class PlayerMasteryData {
    public Map<String, SpeciesMastery> species = new HashMap<String, SpeciesMastery>();
    public Set<Integer> claimedGlobalTiers = new HashSet<Integer>();
    public Set<String> claimedSpeciesRewards = new HashSet<String>();
    public boolean gaveResearchBook = false;

    public SpeciesMastery getOrCreate(String speciesName) {
        String key = speciesName.toLowerCase(Locale.ROOT);
        return this.species.computeIfAbsent(key, k -> new SpeciesMastery());
    }

    public void addProgress(String speciesName, int amt) {
        this.getOrCreate(speciesName).addProgress(amt);
    }

    public int getProgress(String speciesName) {
        SpeciesMastery s = this.species.get(speciesName.toLowerCase(Locale.ROOT));
        return s == null ? 0 : s.getProgress();
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        for (Map.Entry<String, SpeciesMastery> entry : this.species.entrySet()) {
            tag.method_10566(entry.getKey(), (class_2520)entry.getValue().toNbt());
        }
        class_2487 rewards = new class_2487();
        for (int tier : this.claimedGlobalTiers) {
            rewards.method_10556("g" + tier, true);
        }
        class_2487 class_24872 = new class_2487();
        for (String s : this.claimedSpeciesRewards) {
            class_24872.method_10556(s, true);
        }
        rewards.method_10566("species", (class_2520)class_24872);
        tag.method_10566("rewards", (class_2520)rewards);
        tag.method_10556("gaveBook", this.gaveResearchBook);
        return tag;
    }

    public static PlayerMasteryData fromNbt(class_2487 tag) {
        PlayerMasteryData d = new PlayerMasteryData();
        if (tag == null) {
            return d;
        }
        for (Object key : tag.method_10541()) {
            if ("rewards".equals(key)) continue;
            d.species.put((String)key, SpeciesMastery.fromNbt(tag.method_10562((String)key)));
        }
        if (tag.method_10545("rewards")) {
            class_2487 rewards = tag.method_10562("rewards");
            for (String k : rewards.method_10541()) {
                if (!k.startsWith("g")) continue;
                try {
                    d.claimedGlobalTiers.add(Integer.parseInt(k.substring(1)));
                }
                catch (Exception exception) {}
            }
            if (rewards.method_10545("species")) {
                class_2487 sp = rewards.method_10562("species");
                for (String s : sp.method_10541()) {
                    if (!sp.method_10577(s)) continue;
                    d.claimedSpeciesRewards.add(s);
                }
            }
        }
        d.gaveResearchBook = tag.method_10577("gaveBook");
        return d;
    }
}

