/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.storage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class SpeciesMastery {
    private int progress;
    private final Set<Integer> claimed = new HashSet<Integer>();
    final Map<String, Integer> taskProgress = new HashMap<String, Integer>();
    final Set<String> taskCompleted = new HashSet<String>();

    public int getProgress() {
        return this.progress;
    }

    public void addProgress(int amt) {
        this.progress += Math.max(0, amt);
    }

    public boolean isClaimed(int level) {
        return this.claimed.contains(level);
    }

    public void setClaimed(int level) {
        this.claimed.add(level);
    }

    public int getTaskProgress(String taskId) {
        return this.taskProgress.getOrDefault(taskId, 0);
    }

    public void addTaskProgress(String taskId, int amt) {
        this.taskProgress.put(taskId, this.getTaskProgress(taskId) + Math.max(0, amt));
    }

    public boolean isTaskCompleted(String taskId) {
        return this.taskCompleted.contains(taskId);
    }

    public void setTaskCompleted(String taskId) {
        this.taskCompleted.add(taskId);
    }

    public Map<String, Integer> getTaskProgressMapCopy() {
        return new HashMap<String, Integer>(this.taskProgress);
    }

    public Set<String> getTaskCompletedSetCopy() {
        return new HashSet<String>(this.taskCompleted);
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        tag.method_10569("progress", this.progress);
        for (int lvl : this.claimed) {
            tag.method_10556("c" + lvl, true);
        }
        class_2487 tasksTag = new class_2487();
        for (Map.Entry<String, Integer> e : this.taskProgress.entrySet()) {
            tasksTag.method_10569(e.getKey(), e.getValue().intValue());
        }
        tag.method_10566("tasks", (class_2520)tasksTag);
        class_2487 completedTag = new class_2487();
        for (String id : this.taskCompleted) {
            completedTag.method_10556(id, true);
        }
        tag.method_10566("tasks_completed", (class_2520)completedTag);
        return tag;
    }

    public static SpeciesMastery fromNbt(class_2487 tag) {
        SpeciesMastery s = new SpeciesMastery();
        if (tag == null) {
            return s;
        }
        s.progress = tag.method_10550("progress");
        for (int lvl = 1; lvl <= 5; ++lvl) {
            if (!tag.method_10577("c" + lvl)) continue;
            s.claimed.add(lvl);
        }
        if (tag.method_10545("tasks")) {
            class_2487 tasks = tag.method_10562("tasks");
            for (String key : tasks.method_10541()) {
                s.taskProgress.put(key, tasks.method_10550(key));
            }
        }
        if (tag.method_10545("tasks_completed")) {
            class_2487 comp = tag.method_10562("tasks_completed");
            for (String key : comp.method_10541()) {
                if (!comp.method_10577(key)) continue;
                s.taskCompleted.add(key);
            }
        }
        return s;
    }
}

