/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.tasks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import github.jorgaomc.CobblemonMastery;
import github.jorgaomc.config.ConfigManager;
import github.jorgaomc.tasks.SpeciesTasks;
import github.jorgaomc.tasks.TaskDefinition;
import github.jorgaomc.tasks.TaskType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;

public class TaskConfigLoader {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<String, SpeciesTasks> bySpecies = new HashMap<String, SpeciesTasks>();

    public Map<String, SpeciesTasks> loadAll() {
        this.bySpecies.clear();
        try {
            Path dir = ConfigManager.getPokemonConfigDir();
            Files.createDirectories(dir, new FileAttribute[0]);
            this.ensureBundledDefaults(dir);
            this.ensureExample(dir);
            try (Stream<Path> stream = Files.list(dir);){
                stream.filter(p -> p.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".json")).forEach(p -> {
                    try (BufferedReader r = Files.newBufferedReader(p);){
                        SpeciesTasks tasks = (SpeciesTasks)this.gson.fromJson((Reader)r, SpeciesTasks.class);
                        if (tasks != null && tasks.species != null && !tasks.species.isBlank()) {
                            if (tasks.tasks != null) {
                                tasks.tasks.removeIf(t -> t == null || t.type == null);
                            }
                            String key = tasks.species.toLowerCase(Locale.ROOT);
                            this.bySpecies.put(key, tasks);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        }
        catch (Exception e) {
            CobblemonMastery.LOGGER.warn("Failed loading task configs", (Throwable)e);
        }
        return new HashMap<String, SpeciesTasks>(this.bySpecies);
    }

    private void ensureBundledDefaults(Path dir) {
        try {
            String indexPath = "/data/cobblemonresearchtasks/pokemon_tasks/index.txt";
            InputStream is = TaskConfigLoader.class.getResourceAsStream(indexPath);
            if (is == null && !"cobblemonmastery".equals("cobblemonresearchtasks")) {
                indexPath = "/data/cobblemonmastery/pokemon_tasks/index.txt";
                is = TaskConfigLoader.class.getResourceAsStream(indexPath);
            }
            try (InputStream is2 = is;){
                if (is2 == null) {
                    return;
                }
                String content = new String(is2.readAllBytes(), StandardCharsets.UTF_8);
                for (String line : content.split("\n")) {
                    Path target;
                    String name = line.trim();
                    if (name.isEmpty() || name.startsWith("#") || !name.endsWith(".json") || Files.exists(target = dir.resolve(name), new LinkOption[0])) continue;
                    try (InputStream res1 = TaskConfigLoader.class.getResourceAsStream("/data/cobblemonresearchtasks/pokemon_tasks/" + name);){
                        InputStream res = res1;
                        if (res == null && !"cobblemonmastery".equals("cobblemonresearchtasks")) {
                            res = TaskConfigLoader.class.getResourceAsStream("/data/cobblemonmastery/pokemon_tasks/" + name);
                        }
                        if (res == null) continue;
                        Files.copy(res, target, new CopyOption[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ensureReadme(Path dir) {
        block8: {
            try {
                Path readme = dir.resolve("README.md");
                if (Files.exists(readme, new LinkOption[0])) break block8;
                try (BufferedWriter w = Files.newBufferedWriter(readme, StandardCharsets.UTF_8, new OpenOption[0]);){
                    w.write(this.readmeText());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void ensureExample(Path dir) {
        block8: {
            try {
                Path example = dir.resolve("pikachu.json");
                if (Files.exists(example, new LinkOption[0])) break block8;
                SpeciesTasks ex = this.examplePikachu();
                try (BufferedWriter w = Files.newBufferedWriter(example, StandardCharsets.UTF_8, new OpenOption[0]);){
                    this.gson.toJson((Object)ex, (Appendable)w);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private SpeciesTasks examplePikachu() {
        SpeciesTasks s = new SpeciesTasks();
        s.species = "pikachu";
        s.dex = 25;
        s.tasks.add(this.task("capture", TaskType.CAPTURE_THIS, 1, null, null, null, 0));
        s.tasks.add(this.task("evolve", TaskType.EVOLVE_THIS, 1, null, null, null, 0));
        s.tasks.add(this.task("defeat_any_25", TaskType.DEFEAT_ANY_COUNT, 25, null, null, null, 0));
        s.tasks.add(this.task("defeat_species_geodude", TaskType.DEFEAT_SPECIES, 5, "geodude", null, null, 0));
        s.tasks.add(this.task("defeat_type_water_15", TaskType.DEFEAT_TYPE_COUNT, 15, null, "water", null, 0));
        s.tasks.add(this.task("friendship_200", TaskType.FRIENDSHIP_AT_LEAST, 200, null, null, null, 200));
        s.tasks.add(this.task("fish_1", TaskType.FISH_THIS, 1, null, null, null, 0));
        s.tasks.add(this.task("level_up_10", TaskType.LEVEL_UP_COUNT, 10, null, null, null, 0));
        return s;
    }

    private TaskDefinition task(String id, TaskType type, int amount, String targetSpecies, String targetType, String move, int friendship) {
        TaskDefinition t = new TaskDefinition();
        t.id = id;
        t.type = type;
        t.amount = amount;
        t.targetSpecies = targetSpecies;
        t.targetType = targetType;
        t.move = move;
        t.friendship = friendship > 0 ? Integer.valueOf(friendship) : null;
        return t;
    }

    private String readmeText() {
        return "# Cobblemon Mastery Species Tasks\nPlace one JSON per species in this folder. The filename is not important, but set the 'species' field.\n\nExample: see pikachu.json.\n\nSchema (Java-ish):\n\n{\n  \"species\": \"pikachu\",            // required. Use species path/name (e.g., 'pikachu', 'cobblemon:pikachu')\n  \"dex\": 25,                     // optional dex number (for docs only)\n  \"tasks\": [\n    {\n      \"id\": \"capture\",            // required unique id per species\n      \"type\": \"CAPTURE_THIS\",     // one of: DEFEAT_ANY_COUNT, CAPTURE_THIS, EVOLVE_THIS, DEFEAT_SPECIES, DEFEAT_TYPE_COUNT, FRIENDSHIP_AT_LEAST, LEVEL_UP_COUNT, FISH_THIS\n      \"title\": \"Catch a Pikachu\", // optional label override for UI\n      \"amount\": 1,                  // for *_COUNT tasks: how many. For FRIENDSHIP_AT_LEAST: threshold (or use 'friendship')\n      \"targetSpecies\": \"geodude\", // for DEFEAT_SPECIES only (optional)\n      \"targetType\": \"water\",      // for DEFEAT_TYPE_COUNT only (pokemon type in lowercase)\n      \"friendship\": 200              // FRIENDSHIP_AT_LEAST threshold (alternative to amount)\n    }\n  ]\n}\n\nTask types explained:\n- CAPTURE_THIS: Capture this Pok\u00e9mon X times (set 'amount', default 1).\n- EVOLVE_THIS: Evolve this Pok\u00e9mon once (e.g., Pikachu -> Raichu).\n- DEFEAT_ANY_COUNT: Defeat X Pok\u00e9mon using this species.\n- DEFEAT_SPECIES: Defeat X of a specific target species (set targetSpecies).\n- DEFEAT_TYPE_COUNT: Defeat X Pok\u00e9mon of a given type (set targetType).\n- FRIENDSHIP_AT_LEAST: Reach the given friendship value (set friendship or amount).\n- LEVEL_UP_COUNT: Level up this Pok\u00e9mon X times.\n- HEAL_COUNT: Heal this Pok\u00e9mon X times (counts heals via Cobblemon's POKEMON_HEALED).\n- EV_GAINED_AMOUNT: Gain X EV points with this Pok\u00e9mon (sum across stats).\n- FISH_THIS: Catch this Pok\u00e9mon via fishing X times (Cobblemon's BOBBER_SPAWN_POKEMON_POST).\n\nNotes:\n- Do NOT assign tasks to specific individual Pok\u00e9mon here. These tasks apply to the species as a whole for the player.\n- Defeat tracking credits only the killer Pok\u00e9mon using Cobblemon's BATTLE_FAINTED context.origin.\n- Friendship thresholds are checked against the Pok\u00e9mon's friendship stat.\n- Evolving or Capturing this Pok\u00e9mon completes those tasks once.\n- All fields are optional unless marked required; irrelevant fields for a type are ignored.\n";
    }
}

