/*
 * Decompiled with CFR 0.152.
 */
package gd.rf.adrianvictor.lib;

import gd.rf.adrianvictor.lib.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.config.Configuration;

public class ConfigurationEx
extends Configuration {
    private final File configFile;
    private Log logger;
    JavaPlugin plugin;

    public ConfigurationEx(JavaPlugin _plugin, String fileName, Log _logger) {
        super(new File(_plugin.getDataFolder(), fileName));
        this.plugin = _plugin;
        this.logger = _logger;
        this.configFile = new File(this.plugin.getDataFolder(), fileName);
    }

    public void load() {
        this.createParentDirectories();
        if (!this.configFile.exists()) {
            this.copyDefaultConfig();
        }
        try {
            super.load();
        }
        catch (Exception e) {
            this.logger.severe(String.format("Failed to load config '%s': %s", this.configFile.getName(), e.getMessage()));
        }
    }

    private void createParentDirectories() {
        try {
            Files.createDirectories(this.configFile.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.logger.severe(String.format("Failed to generate default config directory: %s", e.getMessage()));
        }
    }

    private void copyDefaultConfig() {
        String resourcePath = "/" + this.configFile.getName();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream input = this.plugin.getClass().getResourceAsStream(resourcePath);){
                if (input == null) {
                    this.logger.severe(String.format("Default config '%s' wasn't found in the JAR.", this.configFile.getName()));
                    return;
                }
                Files.copy(input, this.configFile.toPath(), new CopyOption[0]);
                if (Files.exists(this.configFile.toPath(), new LinkOption[0])) {
                    this.logger.info(String.format("Default config '%s' generated successfully.", this.configFile.getName()));
                } else {
                    this.logger.warning("We tried to generate the default config file, but it was not found even after the creation. Maybe your permissions are broken?");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.severe(String.format("Failed to generate default config '%s': %s", this.configFile.getName(), e.getMessage()));
        }
    }

    public void loadConfig() {
        try {
            this.load();
            this.logger.info(String.format("Config '%s' loaded successfully.", this.configFile.getName()));
        }
        catch (Exception e) {
            this.logger.severe(String.format("Failed to load config '%s': %s", this.configFile.getName(), e.getMessage()));
        }
    }

    public void saveConfig() {
        try {
            this.save();
            this.logger.info(String.format("Config '%s' saved successfully.", this.configFile.getName()));
        }
        catch (Exception e) {
            this.logger.severe(String.format("Failed to save config '%s': %s", this.configFile.getName(), e.getMessage()));
        }
    }

    public File getConfig() {
        return this.configFile;
    }
}

