/*
 * Decompiled with CFR 0.152.
 */
package gd.rf.adrianvictor.lib;

import gd.rf.adrianvictor.lib.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.bukkit.plugin.java.JavaPlugin;

public class Configuration
extends org.bukkit.util.config.Configuration {
    private final File configFile;
    private final String pluginName;

    public Configuration(JavaPlugin plugin, String fileName) {
        super(new File(plugin.getDataFolder(), fileName));
        this.configFile = new File(plugin.getDataFolder(), fileName);
        this.pluginName = plugin.getDescription().getName();
    }

    public void load() {
        this.createParentDirectories();
        if (!this.configFile.exists()) {
            this.copyDefaultConfig();
        }
        try {
            super.load();
        }
        catch (Exception e) {
            Log.severe(String.format("[%s] Failed to load config '%s': %s", this.pluginName, this.configFile.getName(), e.getMessage()));
        }
    }

    private void createParentDirectories() {
        try {
            Files.createDirectories(this.configFile.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            Log.severe(String.format("[%s] Failed to generate default config directory: %s", this.pluginName, e.getMessage()));
        }
    }

    private void copyDefaultConfig() {
        String resourcePath = "/" + this.configFile.getName();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream(resourcePath);){
                if (input == null) {
                    Log.severe(String.format("[%s] Default config '%s' wasn't found.", this.pluginName, this.configFile.getName()));
                    return;
                }
                Files.copy(input, this.configFile.toPath(), new CopyOption[0]);
                Log.info(String.format("[%s] Default config '%s' generated successfully.", this.pluginName, this.configFile.getName()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Log.severe(String.format("[%s] Failed to generate default config '%s': %s", this.pluginName, this.configFile.getName(), e.getMessage()));
        }
    }

    public void loadConfig() {
        try {
            this.load();
            Log.info(String.format("[%s] Config '%s' loaded successfully.", this.pluginName, this.configFile.getName()));
        }
        catch (Exception e) {
            Log.severe(String.format("[%s] Failed to load config '%s': %s", this.pluginName, this.configFile.getName(), e.getMessage()));
        }
    }

    public void saveConfig() {
        try {
            this.save();
            Log.info(String.format("[%s] Config '%s' saved successfully.", this.pluginName, this.configFile.getName()));
        }
        catch (Exception e) {
            Log.severe(String.format("[%s] Failed to save config '%s': %s", this.pluginName, this.configFile.getName(), e.getMessage()));
        }
    }

    public File getConfig() {
        return this.configFile;
    }
}

