/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft;

import com.github.quiltservertools.ledger.Ledger;
import com.github.quiltservertools.ledger.actions.ActionType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import us.mikebartosh.minecraft.actionutils.ActionFactory;

public class InventoryChangeTracker {
    private static final Map<class_3222, class_1799[]> snapshots = new HashMap<class_3222, class_1799[]>();

    public static void capture(class_3222 player) {
        class_1661 inv = player.method_31548();
        class_1799[] copy = new class_1799[inv.method_5439()];
        for (int i = 0; i < inv.method_5439(); ++i) {
            copy[i] = inv.method_5438(i).method_7972();
        }
        snapshots.put(player, copy);
    }

    public static void checkAndLog(class_3222 player) {
        class_1661 inv = player.method_31548();
        class_1799[] prev = snapshots.get(player);
        if (prev == null) {
            InventoryChangeTracker.capture(player);
            return;
        }
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 oldStack = prev[i];
            class_1799 newStack = inv.method_5438(i);
            if (class_1799.method_7973((class_1799)oldStack, (class_1799)newStack)) continue;
            if (oldStack.method_7960() && !newStack.method_7960()) {
                Ledger.getApi().logAction((ActionType)ActionFactory.INSTANCE.playerInventoryAddAction(player.method_37908(), newStack, player.method_24515(), (class_1657)player));
                continue;
            }
            if (oldStack.method_7960() || !newStack.method_7960()) continue;
            Ledger.getApi().logAction((ActionType)ActionFactory.INSTANCE.playerInventoryRemoveAction(player.method_37908(), oldStack, player.method_24515(), (class_1657)player));
        }
        InventoryChangeTracker.capture(player);
    }
}

