/*
 * Decompiled with CFR 0.152.
 */
package org.powell.ACC.commands;

import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.powell.ACC.ACC;

public class TogglePvPCommand
implements CommandExecutor,
Listener {
    private ACC plugin;
    private boolean pvpEnabled;

    public TogglePvPCommand(ACC plugin) {
        this.plugin = plugin;
        this.pvpEnabled = plugin.getConfig().getBoolean("pvp-enabled", true);
    }

    @EventHandler
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player && event.getEntity() instanceof Player && !this.pvpEnabled) {
            event.setCancelled(true);
            ((Player)event.getDamager()).sendMessage(String.valueOf(ChatColor.RED) + "PvP is disabled!");
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        FileConfiguration config = this.plugin.getConfig();
        if (sender instanceof ConsoleCommandSender) {
            if (command.getName().equalsIgnoreCase("enablepvp")) {
                if (this.pvpEnabled) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "PvP is already enabled!");
                    return true;
                }
                this.pvpEnabled = true;
                config.set("pvp-enabled", (Object)true);
                this.plugin.saveConfig();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "PvP has been enabled!");
                return true;
            }
            if (command.getName().equalsIgnoreCase("disablepvp")) {
                if (!this.pvpEnabled) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "PvP is already disabled!");
                    return true;
                }
                this.pvpEnabled = false;
                config.set("pvp-enabled", (Object)false);
                this.plugin.saveConfig();
                sender.sendMessage(String.valueOf(ChatColor.RED) + "PvP has been disabled!");
                return true;
            }
        }
        return false;
    }
}

