/*
 * Decompiled with CFR 0.152.
 */
package org.powell.ACC.main.gui.guis;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.powell.ACC.main.gui.components.GuiAction;
import org.powell.ACC.main.gui.components.util.ItemNbt;

public class GuiItem {
    private GuiAction<InventoryClickEvent> action;
    private ItemStack itemStack;
    private final UUID uuid = UUID.randomUUID();

    public GuiItem(@NotNull ItemStack itemStack, @Nullable GuiAction<@NotNull InventoryClickEvent> action) {
        Preconditions.checkNotNull((Object)itemStack, (Object)"The ItemStack for the GUI Item cannot be null!");
        this.action = action;
        this.itemStack = ItemNbt.setString(itemStack.clone(), "mf-gui", this.uuid.toString());
    }

    public GuiItem(@NotNull ItemStack itemStack) {
        this(itemStack, null);
    }

    public GuiItem(@NotNull Material material) {
        this(new ItemStack(material), null);
    }

    public GuiItem(@NotNull Material material, @Nullable GuiAction<@NotNull InventoryClickEvent> action) {
        this(new ItemStack(material), action);
    }

    public void setItemStack(@NotNull ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack, (Object)"The ItemStack for the GUI Item cannot be null!");
        this.itemStack = ItemNbt.setString(itemStack.clone(), "mf-gui", this.uuid.toString());
    }

    public void setAction(@Nullable GuiAction<@NotNull InventoryClickEvent> action) {
        this.action = action;
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @NotNull
    UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    GuiAction<InventoryClickEvent> getAction() {
        return this.action;
    }
}

