/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.scala_lib;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface ModClassData {
    public String className();

    public String modID();

    default public boolean isScalaObj() {
        return this.className().endsWith("$");
    }

    public static <T extends ModClassData> List<T> findInstance(Collection<T> targets) {
        Map<String, List<ModClassData>> byModId = targets.stream().collect(Collectors.groupingBy(ModClassData::modID));
        return byModId.values().stream().map(ts -> {
            if (ts.size() == 1) {
                return (ModClassData)ts.getFirst();
            }
            List<ModClassData> objectData = ts.stream().filter(ModClassData::isScalaObj).toList();
            if (objectData.size() == 1) {
                return objectData.getFirst();
            }
            throw new RuntimeException("Exception in loading mods. %s".formatted(targets));
        }).toList();
    }
}

