/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.scala_lib;

import cpw.mods.jarhandling.SecureJar;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.jar.Attributes;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.unsafe.UnsafeHacks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class ModuleOpener {
    private static final Logger LOGGER = LogManager.getLogger(ModuleOpener.class);
    static final String OPEN_KEY = "Add-Opens";
    static final String EXPORT_KEY = "Add-Exports";
    private static Method implAddExportsOrOpens;

    ModuleOpener() {
    }

    static void openModule(ModuleLayer layer, Module self, SecureJar jar) throws Exception {
        Attributes manifest = jar.moduleDataProvider().getManifest().getMainAttributes();
        ModuleOpener.addOpenOrExports(layer, self, true, manifest);
        ModuleOpener.addOpenOrExports(layer, self, false, manifest);
    }

    private static void addOpenOrExports(ModuleLayer layer, Module self, boolean open, Attributes attrs) throws Exception {
        String key = open ? OPEN_KEY : EXPORT_KEY;
        String entry = attrs.getValue(key);
        if (entry == null) {
            return;
        }
        for (String pair : entry.split(" ")) {
            String[] pts = pair.trim().split("/");
            if (pts.length == 2) {
                String module = pts[0];
                String packageName = pts[1];
                Module target = layer.findModule(module).orElse(null);
                if (target == null || !target.getDescriptor().packages().contains(packageName)) continue;
                ModuleOpener.addOpenOrExport(target, packageName, self, open);
                continue;
            }
            LOGGER.warn(Logging.LOADING, "Invalid {} entry in {}: {}", (Object)key, (Object)self.getName(), (Object)pair);
        }
    }

    private static void addOpenOrExport(Module target, String pkg, Module reader, boolean open) throws Exception {
        if (implAddExportsOrOpens == null) {
            implAddExportsOrOpens = Module.class.getDeclaredMethod("implAddExportsOrOpens", String.class, Module.class, Boolean.TYPE, Boolean.TYPE);
            UnsafeHacks.setAccessible((AccessibleObject)implAddExportsOrOpens);
        }
        LOGGER.info(Logging.LOADING, "{} {}/{} to {}", (Object)(open ? "Opening" : "Exporting"), (Object)target.getName(), (Object)pkg, (Object)reader.getName());
        implAddExportsOrOpens.invoke((Object)target, pkg, reader, open, true);
    }
}

