/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.scala_lib;

import com.kotori316.scala_lib.ModClassData;
import com.kotori316.scala_lib.ScalaLanguageTarget;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.forgespi.language.ILifecycleEvent;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public final class ScalaLanguageProvider
implements IModLanguageProvider {
    private static final Type MOD_ANNOTATION = Type.getType((String)"Lnet/minecraftforge/fml/common/Mod;");
    static final Logger LOGGER = LogManager.getLogger(ScalaLanguageProvider.class);

    public String name() {
        return "kotori_scala";
    }

    public Consumer<ModFileScanData> getFileVisitor() {
        return scanData -> {
            List<ScalaLanguageTarget> annotatedClasses = scanData.getAnnotations().stream().filter(t -> t.annotationType().equals((Object)MOD_ANNOTATION)).map(data -> {
                String className = data.clazz().getClassName();
                String id = (String)data.annotationData().get("value");
                return new ScalaLanguageTarget(className, id);
            }).toList();
            List<ScalaLanguageTarget> targets = ModClassData.findInstance(annotatedClasses);
            Map map = targets.stream().peek(a -> LOGGER.debug(Logging.SCAN, "Found @Mod class {} with id {}", (Object)a.className(), (Object)a.modID())).collect(Collectors.toMap(ModClassData::modID, Function.identity()));
            scanData.addLanguageLoader(map);
        };
    }

    public <R extends ILifecycleEvent<R>> void consumeLifecycleEvent(Supplier<R> consumeEvent) {
    }
}

