/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.scala_lib;

import com.kotori316.scala_lib.ModuleOpener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.fml.javafmlmod.AutomaticEventSubscriber;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.unsafe.UnsafeHacks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScalaModContainer
extends ModContainer {
    private static final Logger LOGGER = LogManager.getLogger(ScalaModContainer.class);
    private final String className;
    private final ModuleLayer gameLayer;
    private final ModFileScanData scanData;
    private final boolean isScalaObject;
    private final BusGroup eventBusGroup;
    private Class<?> modClass;
    private Object modInstance;
    private final FMLJavaModLoadingContext context;

    public ScalaModContainer(IModInfo info, String className, ModFileScanData modFileScanResults, ModuleLayer gameLayer) {
        super(info);
        this.className = className;
        this.gameLayer = gameLayer;
        LOGGER.debug(Logging.LOADING, "Creating scala container Class: {}, with classLoader {}", (Object)className, (Object)((Object)((Object)this)).getClass().getClassLoader());
        this.scanData = modFileScanResults;
        this.isScalaObject = className.endsWith("$");
        this.activityMap.put(ModLoadingStage.CONSTRUCT, this::constructMod);
        this.eventBusGroup = BusGroup.create((String)("modBusFor" + info.getModId()));
        this.context = ScalaModContainer.createContext(this.getModBusGroup());
        this.contextExtension = () -> this.context;
    }

    private void constructMod() {
        try {
            Module module = this.gameLayer.findModule(this.modInfo.getOwningFile().moduleName()).orElseThrow();
            ModuleOpener.openModule(this.gameLayer, module, this.modInfo.getOwningFile().getFile().getSecureJar());
            this.modClass = Class.forName(module, this.className);
            LOGGER.trace(Logging.LOADING, "Scala Class Loaded {} with {}.", this.modClass, (Object)this.modClass.getClassLoader());
        }
        catch (Throwable e) {
            LOGGER.error(Logging.LOADING, "Failed to load class {}", (Object)this.className, (Object)e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmodclass", e, new Object[0]);
        }
        try {
            if (this.isScalaObject) {
                LOGGER.trace(Logging.LOADING, "Scala Mod instance object for {} is about to get via MODULE$ field. {}", (Object)this.modId, (Object)this.modClass.getName());
                this.modInstance = this.modClass.getField("MODULE$").get(null);
                LOGGER.trace(Logging.LOADING, "Scala Mod instance for {} was got. {}", (Object)this.modId, this.modInstance);
            } else {
                LOGGER.trace(Logging.LOADING, "Scala Mod instance for {} is about to create. {}", (Object)this.modId, (Object)this.modClass.getName());
                Map.Entry<Constructor<?>, Object[]> constructors = ScalaModContainer.getConstructor(this.modClass, this.modId, this.getModBusGroup(), this, FMLLoader.getDist(), this.context);
                constructors.getKey().setAccessible(true);
                this.modInstance = constructors.getKey().newInstance(constructors.getValue());
                LOGGER.trace(Logging.LOADING, "Scala Mod instance for {} created. {}", (Object)this.modId, this.modInstance);
            }
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error(Logging.LOADING, "Failed to create/get mod instance. ModID: {}, class {}", (Object)this.modId, (Object)this.modClass.getName(), (Object)e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", (Throwable)e, new Object[]{this.modClass});
        }
        try {
            LOGGER.trace(Logging.LOADING, "Injecting Automatic event subscribers for {}", (Object)this.modId);
            AutomaticEventSubscriber.inject((ModContainer)this, (ModFileScanData)this.scanData, (ClassLoader)this.modClass.getClassLoader());
            LOGGER.trace(Logging.LOADING, "Completed Automatic event subscribers for {}", (Object)this.modId);
        }
        catch (Throwable e) {
            LOGGER.error(Logging.LOADING, "Failed to register automatic subscribers. ModID: {}, class {}", (Object)this.modId, (Object)this.modClass.getName(), (Object)e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", e, new Object[]{this.modClass});
        }
    }

    public BusGroup getModBusGroup() {
        return this.eventBusGroup;
    }

    public boolean matches(Object mod) {
        return mod == this.modInstance;
    }

    public Object getMod() {
        return this.modInstance;
    }

    protected <T extends IModBusEvent> void acceptEvent(T event) {
        LOGGER.trace(Logging.LOADING, "Firing event for modid {} : {}", (Object)this.modId, event);
        try {
            EventBus eventBus = IModBusEvent.getBus((BusGroup)this.eventBusGroup, (Class)event.getClass());
            eventBus.post(event);
            LOGGER.trace(Logging.LOADING, "Fired event for modid {} : {}", (Object)this.modId, event);
        }
        catch (Throwable e) {
            LOGGER.error(Logging.LOADING, "Caught exception during event {} dispatch for modid {}", event, (Object)this.modId, (Object)e);
            throw new ModLoadingException(this.modInfo, this.modLoadingStage, "fml.modloading.errorduringevent", e, new Object[0]);
        }
    }

    public void dispatchConfigEvent(IConfigEvent event) {
        EventBus eventBus = EventBus.create((BusGroup)this.eventBusGroup, event.self().getClass());
        eventBus.post((Event)event.self());
    }

    private static FMLJavaModLoadingContext createContext(BusGroup busGroup) {
        try {
            FMLJavaModLoadingContext instance = (FMLJavaModLoadingContext)UnsafeHacks.newInstance(FMLJavaModLoadingContext.class);
            FMLModContainer container = (FMLModContainer)UnsafeHacks.newInstance(FMLModContainer.class);
            UnsafeHacks.setField((Field)FMLModContainer.class.getDeclaredField("eventBusGroup"), (Object)container, (Object)busGroup);
            UnsafeHacks.setField((Field)FMLJavaModLoadingContext.class.getDeclaredField("container"), (Object)instance, (Object)container);
            return instance;
        }
        catch (ReflectiveOperationException e) {
            LOGGER.fatal("Error happened in creating dummy instance.", (Throwable)e);
            return null;
        }
    }

    static Map.Entry<Constructor<?>, Object[]> getConstructor(Class<?> modClass, String modId, BusGroup busGroup, ModContainer container, Dist dist, FMLJavaModLoadingContext context) {
        Constructor<?>[] constructors = modClass.getDeclaredConstructors();
        LOGGER.trace(Logging.LOADING, "Found {} constructors for {}", (Object)constructors.length, (Object)modId);
        Map<Class<FMLJavaModLoadingContext>, FMLJavaModLoadingContext> args = Map.of(BusGroup.class, busGroup, ModContainer.class, container, Dist.class, dist, FMLJavaModLoadingContext.class, context);
        Constructor constructor = Stream.of(constructors).filter(c -> Stream.of(c.getParameterTypes()).allMatch(args::containsKey)).max(Comparator.comparingInt(Constructor::getParameterCount)).orElseThrow(() -> new RuntimeException("No mod constructor with allowed arg types were found for " + modId));
        Object[] constructorArgs = Stream.of(constructor.getParameterTypes()).map(args::get).toArray();
        return Map.entry(constructor, constructorArgs);
    }

    public String toString() {
        return "ScalaModContainer{modId='" + this.modId + "', className='" + this.className + "', modClass=" + String.valueOf(this.modClass == null ? "<not initialized>" : this.modClass) + "}";
    }
}

