/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.scala_lib;

import com.kotori316.scala_lib.ModClassDataImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.neoforged.api.distmarker.Dist;
import org.objectweb.asm.Type;

public interface ModClassData {
    public String className();

    public String modID();

    public Set<Dist> availableDistSet();

    default public boolean isScalaObj() {
        return this.className().endsWith("$");
    }

    public static <T extends ModClassData> List<T> findInstance(Collection<T> targets) {
        return ModClassData.findInstance(targets, t -> {
            throw new RuntimeException("Exception in loading mods. %s".formatted(targets));
        });
    }

    public static <T extends ModClassData> List<T> findInstance(Collection<T> targets, Consumer<Collection<T>> onError) {
        Map<String, List<ModClassData>> byModId = targets.stream().collect(Collectors.groupingBy(ModClassData::modID));
        return byModId.values().stream().mapMulti((ts, c) -> {
            if (ts.size() == 1) {
                c.accept((ModClassData)ts.getFirst());
            } else {
                List<ModClassData> objectData = ts.stream().filter(ModClassData::isScalaObj).toList();
                if (objectData.size() == 1) {
                    c.accept(objectData.getFirst());
                } else {
                    onError.accept(objectData);
                }
            }
        }).toList();
    }

    public static ModClassData of(Type t, String modId, Set<Dist> availableDistSet) {
        return new ModClassDataImpl(t.getClassName(), modId, availableDistSet);
    }
}

