/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.scala_lib;

import com.kotori316.scala_lib.ModClassData;
import com.kotori316.scala_lib.ScalaModContainer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.javafmlmod.AutomaticEventSubscriber;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforgespi.IIssueReporting;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.IModLanguageLoader;
import net.neoforged.neoforgespi.language.ModFileScanData;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public final class ScalaLanguageProvider
implements IModLanguageLoader {
    static final Logger LOGGER = LogManager.getLogger(ScalaLanguageProvider.class);

    public String name() {
        return "kotori_scala";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String version() {
        String versionFromMeta = this.getClass().getPackage().getImplementationVersion();
        if (versionFromMeta != null) {
            return versionFromMeta;
        }
        InputStream versionStream = ScalaLanguageProvider.class.getResourceAsStream("/version.txt");
        if (versionStream == null) {
            throw new IllegalStateException("Could not find version.txt");
        }
        try (InputStream stream = versionStream;){
            String string;
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(stream));){
                string = buffer.readLine();
            }
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not read version from version.txt", e);
        }
    }

    public ModContainer loadMod(IModInfo info, ModFileScanData modFileScanResults, ModuleLayer layer) throws ModLoadingException {
        List<ModClassData> annotatedClasses = modFileScanResults.getAnnotatedBy(Mod.class, ElementType.TYPE).map(data -> {
            Type clazz = data.clazz();
            String id = (String)data.annotationData().get("value");
            Object dist = data.annotationData().get("dist");
            return ModClassData.of(clazz, id, AutomaticEventSubscriber.getSides(dist));
        }).toList();
        List<String> modClasses = ModClassData.findInstance(annotatedClasses, t -> LOGGER.error("Error in loading {}. No acceptable class found", t)).stream().filter(d -> d.availableDistSet().contains(FMLLoader.getCurrent().getDist())).map(ModClassData::className).toList();
        return new ScalaModContainer(info, modClasses, modFileScanResults, layer);
    }

    public void validate(IModFile file, Collection<ModContainer> loadedContainers, IIssueReporting reporter) {
        super.validate(file, loadedContainers, reporter);
        Set modIdSet = file.getModInfos().stream().filter(m -> m.getLoader() == this).map(IModInfo::getModId).collect(Collectors.toUnmodifiableSet());
        Map<String, List<ModClassData>> mods = file.getScanResult().getAnnotatedBy(Mod.class, ElementType.TYPE).map(data -> {
            Type clazz = data.clazz();
            String id = (String)data.annotationData().get("value");
            Object dist = data.annotationData().get("dist");
            return ModClassData.of(clazz, id, AutomaticEventSubscriber.getSides(dist));
        }).peek(a -> LOGGER.debug(Logging.SCAN, "Found @Mod class {} with id {}", (Object)a.className(), (Object)a.modID())).collect(Collectors.groupingBy(ModClassData::modID));
        mods.keySet().stream().filter(Predicate.not(modIdSet::contains)).forEach(modId -> {
            List data = (List)mods.get(modId);
            List<String> classes = data.stream().map(ModClassData::className).toList();
            ModLoadingIssue issue = ModLoadingIssue.error((String)"fml.modloadingissue.javafml.dangling_entrypoint", (Object[])new Object[]{modId, classes, file.getFilePath()}).withAffectedModFile(file);
            reporter.addIssue(issue);
        });
        mods.values().stream().filter(dataList -> dataList.size() != 1 && dataList.stream().filter(ModClassData::isScalaObj).count() != 1L).forEach(dataList -> {
            String modId = ((ModClassData)dataList.getFirst()).modID();
            List<String> classes = dataList.stream().map(ModClassData::className).toList();
            ModLoadingIssue issue = ModLoadingIssue.error((String)"Duplicated mod classes for %s, found: %s".formatted(modId, classes), (Object[])new Object[0]);
            reporter.addIssue(issue);
        });
    }
}

