/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.scala_lib;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.EventBusErrorMessage;
import net.neoforged.bus.api.BusBuilder;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.fml.javafmlmod.AutomaticEventSubscriber;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ScalaModContainer
extends ModContainer {
    private static final Logger LOGGER = LogManager.getLogger(ScalaModContainer.class);
    private final List<String> entryPoints;
    private final Module layer;
    private final ModFileScanData scanData;
    private final IEventBus eventBus;
    private List<Class<?>> modClasses;

    public ScalaModContainer(IModInfo info, List<String> entryPoints, ModFileScanData modFileScanResults, ModuleLayer gameLayer) {
        super(info);
        this.entryPoints = entryPoints;
        this.layer = gameLayer.findModule(info.getOwningFile().getFile().getId()).orElseThrow();
        LOGGER.debug(Logging.LOADING, "Creating scala container for {}, with classLoader {}", entryPoints, (Object)((Object)((Object)this)).getClass().getClassLoader());
        this.scanData = modFileScanResults;
        this.eventBus = BusBuilder.builder().setExceptionHandler(this::onEventFailed).markerType(IModBusEvent.class).allowPerPhasePost().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void constructMod() {
        this.modClasses = new ArrayList();
        ModLoadingContext context = ModLoadingContext.get();
        try {
            context.setActiveContainer((ModContainer)this);
            for (String string : this.entryPoints) {
                Class<?> modClass;
                try {
                    modClass = Class.forName(this.layer, string);
                    LOGGER.trace(Logging.LOADING, "Scala Class Loaded {} with {}.", modClass, (Object)modClass.getClassLoader());
                }
                catch (Throwable e) {
                    LOGGER.error(Logging.LOADING, "Failed to load class {}", (Object)string, (Object)e);
                    throw new ModLoadingException(ModLoadingIssue.error((String)"fml.modloadingissue.failedtoloadmodclass", (Object[])new Object[0]).withAffectedMod(this.modInfo).withCause(e));
                }
                this.modClasses.add(modClass);
            }
        }
        finally {
            context.setActiveContainer(null);
        }
        for (Class clazz : this.modClasses) {
            boolean isScalaObject = clazz.getName().endsWith("$");
            try {
                Object modInstance;
                if (isScalaObject) {
                    LOGGER.trace(Logging.LOADING, "Scala Mod instance object for {} is about to get via MODULE$ field. {}", (Object)this.modId, (Object)clazz.getName());
                    modInstance = clazz.getField("MODULE$").get(null);
                    LOGGER.trace(Logging.LOADING, "Scala Mod instance for {} was got. {}", (Object)this.modId, modInstance);
                    continue;
                }
                LOGGER.trace(Logging.LOADING, "Scala Mod instance for {} is about to create. {}", (Object)this.modId, (Object)clazz.getName());
                Map.Entry<Constructor<?>, Object[]> constructors = ScalaModContainer.getConstructor(clazz, this.modId, this.getEventBus(), this, FMLLoader.getCurrent().getDist());
                constructors.getKey().setAccessible(true);
                modInstance = constructors.getKey().newInstance(constructors.getValue());
                LOGGER.trace(Logging.LOADING, "Scala Mod instance for {} created. {}", (Object)this.modId, modInstance);
            }
            catch (ReflectiveOperationException e) {
                Throwable cause;
                if (e instanceof InvocationTargetException) {
                    InvocationTargetException i = (InvocationTargetException)e;
                    cause = i.getCause();
                } else {
                    cause = e;
                }
                LOGGER.error(Logging.LOADING, "Failed to create/get mod instance. ModID: {}, class {}", (Object)this.modId, (Object)clazz.getName(), (Object)cause);
                throw new ModLoadingException(ModLoadingIssue.error((String)"fml.modloadingissue.failedtoloadmod", (Object[])new Object[]{cause, clazz}).withAffectedMod(this.modInfo).withCause(cause));
            }
        }
        try {
            LOGGER.trace(Logging.LOADING, "Injecting Automatic event subscribers for {}", (Object)this.modId);
            AutomaticEventSubscriber.inject((ModContainer)this, (ModFileScanData)this.scanData, (Module)this.layer);
            LOGGER.trace(Logging.LOADING, "Completed Automatic event subscribers for {}", (Object)this.modId);
        }
        catch (Throwable e) {
            LOGGER.error(Logging.LOADING, "Failed to register automatic subscribers. ModID: {}, Classes: {}", (Object)this.modId, this.entryPoints, (Object)e);
            throw new ModLoadingException(ModLoadingIssue.error((String)"fml.modloadingissue.failedtoloadmod", (Object[])new Object[]{e, this.entryPoints}).withAffectedMod(this.modInfo).withCause(e));
        }
    }

    private void onEventFailed(IEventBus bus, Event event, EventListener[] listeners, int i, Throwable throwable) {
        LOGGER.error((Message)new EventBusErrorMessage(event, i, listeners, throwable));
    }

    public IEventBus getEventBus() {
        return this.eventBus;
    }

    static Map.Entry<Constructor<?>, Object[]> getConstructor(Class<?> modClass, String modId, IEventBus bus, ModContainer container, Dist dist) {
        Constructor<?>[] constructors = modClass.getDeclaredConstructors();
        LOGGER.trace(Logging.LOADING, "Found {} constructors for {}", (Object)constructors.length, (Object)modId);
        Map<Class<Dist>, Dist> args = Map.of(IEventBus.class, bus, ModContainer.class, container, Dist.class, dist);
        Constructor constructor = Stream.of(constructors).filter(c -> Stream.of(c.getParameterTypes()).allMatch(args::containsKey)).max(Comparator.comparingInt(Constructor::getParameterCount)).orElseThrow(() -> new RuntimeException("No mod constructor with allowed arg types were found for " + modId));
        Object[] constructorArgs = Stream.of(constructor.getParameterTypes()).map(args::get).toArray();
        return Map.entry(constructor, constructorArgs);
    }

    public String toString() {
        return "ScalaModContainer{modId='" + this.modId + "', entryPoints='" + String.valueOf(this.entryPoints) + "', modClasses=" + String.valueOf(this.modClasses == null ? "<not initialized>" : this.modClasses) + "}";
    }
}

