/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.common.effect;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import mobchampions.MobChampions;
import mobchampions.common.effect.ChampionMobEffect;
import mobchampions.network.MobChampion;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;

public class MobChampionsEffects {
    public static final MobEffect UNCOMMON_CHAMPION_EFFECT = new ChampionMobEffect(MobChampion.Rank.UNCOMMON);
    public static final ResourceLocation UNCOMMON_CHAMPION_EFFECT_ID = MobChampions.prefix("uncommon_champion_effect");
    public static Holder<MobEffect> UNCOMMON_CHAMPION_EFFECT_HOLDER = null;
    public static final MobEffect RARE_CHAMPION_EFFECT = new ChampionMobEffect(MobChampion.Rank.RARE);
    public static final ResourceLocation RARE_CHAMPION_EFFECT_ID = MobChampions.prefix("rare_champion_effect");
    public static Holder<MobEffect> RARE_CHAMPION_EFFECT_HOLDER = null;
    public static final MobEffect EPIC_CHAMPION_EFFECT = new ChampionMobEffect(MobChampion.Rank.EPIC);
    public static final ResourceLocation EPIC_CHAMPION_EFFECT_ID = MobChampions.prefix("epic_champion_effect");
    public static Holder<MobEffect> EPIC_CHAMPION_EFFECT_HOLDER = null;
    public static final MobEffect LEGENDARY_CHAMPION_EFFECT = new ChampionMobEffect(MobChampion.Rank.LEGENDARY);
    public static final ResourceLocation LEGENDARY_CHAMPION_EFFECT_ID = MobChampions.prefix("legendary_champion_effect");
    public static Holder<MobEffect> LEGENDARY_CHAMPION_EFFECT_HOLDER = null;
    public static final List<Holder<MobEffect>> ALL_CHAMPION_EFFECT_HOLDERS = new ArrayList<Holder<MobEffect>>(4);

    public static void init(BiConsumer<MobEffect, ResourceLocation> consumer) {
        MobChampionsEffects.register(consumer, MobChampion.Rank.UNCOMMON);
        MobChampionsEffects.register(consumer, MobChampion.Rank.RARE);
        MobChampionsEffects.register(consumer, MobChampion.Rank.EPIC);
        MobChampionsEffects.register(consumer, MobChampion.Rank.LEGENDARY);
    }

    private static void register(BiConsumer<MobEffect, ResourceLocation> consumer, MobChampion.Rank rank) {
        switch (rank) {
            case UNCOMMON: {
                consumer.accept(UNCOMMON_CHAMPION_EFFECT, UNCOMMON_CHAMPION_EFFECT_ID);
                UNCOMMON_CHAMPION_EFFECT_HOLDER = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)UNCOMMON_CHAMPION_EFFECT);
                ALL_CHAMPION_EFFECT_HOLDERS.add(UNCOMMON_CHAMPION_EFFECT_HOLDER);
                break;
            }
            case RARE: {
                consumer.accept(RARE_CHAMPION_EFFECT, RARE_CHAMPION_EFFECT_ID);
                RARE_CHAMPION_EFFECT_HOLDER = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)RARE_CHAMPION_EFFECT);
                ALL_CHAMPION_EFFECT_HOLDERS.add(RARE_CHAMPION_EFFECT_HOLDER);
                break;
            }
            case EPIC: {
                consumer.accept(EPIC_CHAMPION_EFFECT, EPIC_CHAMPION_EFFECT_ID);
                EPIC_CHAMPION_EFFECT_HOLDER = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)EPIC_CHAMPION_EFFECT);
                ALL_CHAMPION_EFFECT_HOLDERS.add(EPIC_CHAMPION_EFFECT_HOLDER);
                break;
            }
            case LEGENDARY: {
                consumer.accept(LEGENDARY_CHAMPION_EFFECT, LEGENDARY_CHAMPION_EFFECT_ID);
                LEGENDARY_CHAMPION_EFFECT_HOLDER = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)LEGENDARY_CHAMPION_EFFECT);
                ALL_CHAMPION_EFFECT_HOLDERS.add(LEGENDARY_CHAMPION_EFFECT_HOLDER);
            }
        }
    }

    public static Holder<MobEffect> getChampionEffectHolderByRank(MobChampion.Rank rank) {
        return switch (rank) {
            default -> throw new MatchException(null, null);
            case MobChampion.Rank.COMMON -> null;
            case MobChampion.Rank.UNCOMMON -> UNCOMMON_CHAMPION_EFFECT_HOLDER;
            case MobChampion.Rank.RARE -> RARE_CHAMPION_EFFECT_HOLDER;
            case MobChampion.Rank.EPIC -> EPIC_CHAMPION_EFFECT_HOLDER;
            case MobChampion.Rank.LEGENDARY -> LEGENDARY_CHAMPION_EFFECT_HOLDER;
        };
    }
}

