/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.data.loot;

import java.util.List;
import java.util.function.BiConsumer;
import mobchampions.loot.MobChampionsLootTables;
import mobchampions.util.LootTableHelper;
import mobchampions.util.TranslationHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class MobChampionsGenericLoot
implements LootTableSubProvider {
    private final HolderLookup.Provider lookupProvider;
    private final HolderLookup.RegistryLookup<Enchantment> enchantmentRegistryLookup;

    public MobChampionsGenericLoot(HolderLookup.Provider lookupProvider) {
        this.lookupProvider = lookupProvider;
        this.enchantmentRegistryLookup = lookupProvider.lookupOrThrow(Registries.ENCHANTMENT);
    }

    public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        this.generateUncommonGenericLoot(consumer);
        this.generateRareGenericLoot(consumer);
        this.generateEpicGenericLoot(consumer);
        this.generateLegendaryGenericLoot(consumer);
    }

    private void generateUncommonGenericLoot(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        consumer.accept(MobChampionsLootTables.UNCOMMON_GENERIC_LOOT, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(this.createRandomBook(25)).add(this.createPotion("medkit", 75, ChatFormatting.LIGHT_PURPLE, (Holder<Potion>)Potions.STRONG_HEALING, List.of(new MobEffectInstance(MobEffects.REGENERATION, 200, 2, false, true))))));
    }

    private void generateRareGenericLoot(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        consumer.accept(MobChampionsLootTables.RARE_GENERIC_LOOT, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(this.createBookWithLevels(25, 5.0f, 15.0f)).add(this.createPotion("advanced_medkit", 75, ChatFormatting.LIGHT_PURPLE, (Holder<Potion>)Potions.STRONG_HEALING, List.of(new MobEffectInstance(MobEffects.REGENERATION, 200, 3, false, true))))));
    }

    private void generateEpicGenericLoot(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        consumer.accept(MobChampionsLootTables.EPIC_GENERIC_LOOT, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(this.createBookWithLevels(25, 15.0f, 25.0f)).add(this.createItemDrop(Items.DIAMOND, 30, 1.0f, 4.0f)).add(this.createPotion("elite_medkit", 40, ChatFormatting.LIGHT_PURPLE, (Holder<Potion>)Potions.STRONG_HEALING, List.of(new MobEffectInstance(MobEffects.INSTANT_HEALTH, 0, 3, false, true)))).add(this.createPotion("adrenaline_shot", 30, ChatFormatting.RED, (Holder<Potion>)Potions.STRONG_SWIFTNESS, List.of(new MobEffectInstance(MobEffects.STRENGTH, 600, 2, false, true)))).add(LootTableHelper.addEffectsItem(Items.TOTEM_OF_UNDYING, "lucky_charm", 10, ChatFormatting.GREEN, List.of(new MobEffectInstance(MobEffects.LUCK, 6000)), List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.PROTECTION, (NumberProvider)ConstantValue.exactly((float)1.0f))), this.enchantmentRegistryLookup))));
    }

    private void generateLegendaryGenericLoot(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        consumer.accept(MobChampionsLootTables.LEGENDARY_GENERIC_LOOT, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(this.createBookWithLevels(50, 30.0f, 50.0f)).add(this.createItemDrop(Items.DIAMOND, 50, 2.0f, 5.0f)).add(this.createPotion("legendary_medkit", 40, ChatFormatting.LIGHT_PURPLE, (Holder<Potion>)Potions.STRONG_HEALING, List.of(new MobEffectInstance(MobEffects.INSTANT_HEALTH, 0, 5, false, true)))).add(this.createPotion("energy_drink", 30, ChatFormatting.GOLD, (Holder<Potion>)Potions.STRONG_SWIFTNESS, List.of(new MobEffectInstance(MobEffects.HASTE, 3600, 3, false, true)))).add(LootTableHelper.addItem(Items.TOTEM_OF_UNDYING, "yolt", 10, ChatFormatting.DARK_RED, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.VANISHING_CURSE, (NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))), this.enchantmentRegistryLookup))));
    }

    private LootPoolSingletonContainer.Builder<?> createPotion(String name, int weight, ChatFormatting color, Holder<Potion> potion, List<MobEffectInstance> effects) {
        LootPoolSingletonContainer.Builder<?> builder = LootItem.lootTableItem((ItemLike)Items.POTION).apply((LootItemFunction.Builder)SetNameFunction.setName((Component)TranslationHelper.getLootComponent(name, color), (SetNameFunction.Target)SetNameFunction.Target.ITEM_NAME)).setWeight(weight).apply((LootItemFunction.Builder)SetPotionFunction.setPotion(potion));
        builder = LootTableHelper.addEffects(builder, effects);
        return LootTableHelper.addLore(builder);
    }

    private LootPoolSingletonContainer.Builder<?> createItemDrop(Item item, int weight, float min, float max) {
        return LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max), (boolean)true)).setWeight(weight);
    }

    private LootPoolSingletonContainer.Builder<?> createRandomBook(int weight) {
        LootPoolSingletonContainer.Builder builder = LootItem.lootTableItem((ItemLike)Items.BOOK).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomEnchantment()).setWeight(weight);
        return LootTableHelper.addLore(builder);
    }

    private LootPoolSingletonContainer.Builder<?> createBookWithLevels(int weight, float min, float max) {
        LootPoolSingletonContainer.Builder builder = LootItem.lootTableItem((ItemLike)Items.BOOK).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)this.lookupProvider, (NumberProvider)UniformGenerator.between((float)min, (float)max))).setWeight(weight);
        return LootTableHelper.addLore(builder);
    }
}

