/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.data.loot;

import java.util.List;
import java.util.function.BiConsumer;
import mobchampions.loot.MobChampionsLootTables;
import mobchampions.util.LootTableHelper;
import mobchampions.util.TranslationHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetBannerPatternFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class MobChampionsWeaponLoot
implements LootTableSubProvider {
    private final HolderLookup.RegistryLookup<Enchantment> enchantmentRegistryLookup;
    private final HolderLookup.RegistryLookup<BannerPattern> bannerPatternLookup;

    public MobChampionsWeaponLoot(HolderLookup.Provider lookupProvider) {
        this.enchantmentRegistryLookup = lookupProvider.lookupOrThrow(Registries.ENCHANTMENT);
        this.bannerPatternLookup = lookupProvider.lookupOrThrow(Registries.BANNER_PATTERN);
    }

    public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        this.generateUncommonWeaponLoot(consumer);
        this.generateRareWeaponLoot(consumer);
        this.generateEpicWeaponLoot(consumer);
        this.generateLegendaryWeaponLoot(consumer);
    }

    private void generateUncommonWeaponLoot(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        LootPool.Builder lootPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(this.addShieldItem("riot_shield", 100, ChatFormatting.BLUE, DyeColor.WHITE, List.of(new ShieldPattern((ResourceKey<BannerPattern>)BannerPatterns.GRADIENT_UP, DyeColor.CYAN), new ShieldPattern((ResourceKey<BannerPattern>)BannerPatterns.HALF_HORIZONTAL_MIRROR, DyeColor.LIGHT_GRAY), new ShieldPattern((ResourceKey<BannerPattern>)BannerPatterns.STRIPE_MIDDLE, DyeColor.GRAY), new ShieldPattern((ResourceKey<BannerPattern>)BannerPatterns.BORDER, DyeColor.GRAY)), List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.UNBREAKING, (NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f))))).add(LootTableHelper.addItem(Items.STICK, "knockback_stick", 100, ChatFormatting.GOLD, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.KNOCKBACK, (NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.GOLDEN_AXE, "greed", 80, ChatFormatting.GOLD, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.LOOTING, (NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.WOODEN_SWORD, "matchstick", 100, ChatFormatting.RED, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT, (NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.CROSSBOW, "multiplier", 90, ChatFormatting.LIGHT_PURPLE, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.PIERCING, (NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.MULTISHOT, (NumberProvider)ConstantValue.exactly((float)1.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.IRON_AXE, "mjolnir", 90, ChatFormatting.YELLOW, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.SMITE, (NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.STONE_AXE, "primitive_chainsaw", 90, ChatFormatting.DARK_GRAY, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.EFFICIENCY, (NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.GOLDEN_PICKAXE, "primitive_mining_drill", 90, ChatFormatting.GRAY, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.EFFICIENCY, (NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f))), this.enchantmentRegistryLookup));
        consumer.accept(MobChampionsLootTables.UNCOMMON_WEAPON_LOOT, LootTable.lootTable().withPool(lootPool));
    }

    private void generateRareWeaponLoot(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        LootPool.Builder lootPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootTableHelper.addItem(Items.IRON_SWORD, "apocalypse_blade", 100, ChatFormatting.RED, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.SHARPNESS, (NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.SMITE, (NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.IRON_AXE, "chainsaw", 90, ChatFormatting.DARK_GRAY, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.EFFICIENCY, (NumberProvider)UniformGenerator.between((float)5.0f, (float)6.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.UNBREAKING, (NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.IRON_PICKAXE, "mining_drill", 90, ChatFormatting.GRAY, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.EFFICIENCY, (NumberProvider)UniformGenerator.between((float)5.0f, (float)6.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.UNBREAKING, (NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.IRON_PICKAXE, "gem_magnet", 70, ChatFormatting.AQUA, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.FORTUNE, (NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))), this.enchantmentRegistryLookup));
        consumer.accept(MobChampionsLootTables.RARE_WEAPON_LOOT, LootTable.lootTable().withPool(lootPool));
    }

    private void generateEpicWeaponLoot(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        LootPool.Builder lootPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootTableHelper.addItem(Items.BOW, "cornucopia_bow", 30, ChatFormatting.DARK_GREEN, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.LOOTING, (NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.PUNCH, (NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))), this.enchantmentRegistryLookup)).add(this.addShieldItem("basher", 30, ChatFormatting.GOLD, DyeColor.YELLOW, List.of(new ShieldPattern((ResourceKey<BannerPattern>)BannerPatterns.PIGLIN, DyeColor.ORANGE), new ShieldPattern((ResourceKey<BannerPattern>)BannerPatterns.BORDER, DyeColor.ORANGE)), List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.UNBREAKING, (NumberProvider)ConstantValue.exactly((float)5.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.MENDING, (NumberProvider)ConstantValue.exactly((float)1.0f))))).add(LootTableHelper.addItem(Items.TRIDENT, "ripper", 20, ChatFormatting.DARK_PURPLE, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.RIPTIDE, (NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.NETHERITE_HOE, "reapers_scythe", 70, ChatFormatting.RED, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.SHARPNESS, (NumberProvider)ConstantValue.exactly((float)10.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.VANISHING_CURSE, (NumberProvider)ConstantValue.exactly((float)1.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.TRIDENT, "poseidons_trident", 30, ChatFormatting.DARK_AQUA, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.SHARPNESS, (NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.LOYALTY, (NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))), this.enchantmentRegistryLookup));
        consumer.accept(MobChampionsLootTables.EPIC_WEAPON_LOOT, LootTable.lootTable().withPool(lootPool));
    }

    private void generateLegendaryWeaponLoot(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        LootPool.Builder lootPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootTableHelper.addItem(Items.NETHERITE_AXE, "axecalibur", 10, ChatFormatting.GOLD, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.SHARPNESS, (NumberProvider)ConstantValue.exactly((float)5.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.UNBREAKING, (NumberProvider)ConstantValue.exactly((float)5.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.MENDING, (NumberProvider)ConstantValue.exactly((float)1.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.BOW, "robins_bow", 20, ChatFormatting.DARK_GREEN, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.MENDING, (NumberProvider)ConstantValue.exactly((float)1.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.LOOTING, (NumberProvider)UniformGenerator.between((float)3.0f, (float)4.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.INFINITY, (NumberProvider)ConstantValue.exactly((float)1.0f))), this.enchantmentRegistryLookup));
        consumer.accept(MobChampionsLootTables.LEGENDARY_WEAPON_LOOT, LootTable.lootTable().withPool(lootPool));
    }

    private LootPoolSingletonContainer.Builder<?> addShieldItem(String id, int weight, ChatFormatting color, DyeColor baseColor, List<ShieldPattern> patterns, List<LootTableHelper.ItemEnchantment> enchantments) {
        LootPoolSingletonContainer.Builder<?> builder = LootItem.lootTableItem((ItemLike)Items.SHIELD).apply((LootItemFunction.Builder)SetNameFunction.setName((Component)TranslationHelper.getLootComponent(id, color), (SetNameFunction.Target)SetNameFunction.Target.ITEM_NAME)).apply((LootItemFunction.Builder)SetComponentsFunction.setComponent((DataComponentType)DataComponents.BASE_COLOR, (Object)baseColor)).setWeight(weight);
        builder = this.addShieldPatterns(builder, patterns);
        builder = LootTableHelper.addItemEnchantments(builder, this.enchantmentRegistryLookup, enchantments);
        return LootTableHelper.addLore(builder);
    }

    private LootPoolSingletonContainer.Builder<?> addShieldPatterns(LootPoolSingletonContainer.Builder<?> builder, List<ShieldPattern> patterns) {
        SetBannerPatternFunction.Builder patternBuilder = SetBannerPatternFunction.setBannerPattern((boolean)true);
        for (ShieldPattern shieldPattern : patterns) {
            patternBuilder.addPattern((Holder)this.bannerPatternLookup.getOrThrow(shieldPattern.pattern), shieldPattern.color);
        }
        builder = builder.apply((LootItemFunction.Builder)patternBuilder);
        return builder;
    }

    private static class ShieldPattern {
        public ResourceKey<BannerPattern> pattern;
        public DyeColor color;

        public ShieldPattern(ResourceKey<BannerPattern> pattern, DyeColor color) {
            this.pattern = pattern;
            this.color = color;
        }
    }
}

