/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.mixin;

import mobchampions.config.ConfigHandler;
import mobchampions.platform.Services;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Creeper.class})
public abstract class CreeperMixin {
    @Shadow
    private int explosionRadius;

    @Inject(method={"explodeCreeper"}, at={@At(value="HEAD")})
    private void mobchampions$explodeCreeper(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (!livingEntity.level().isClientSide()) {
            Services.PLATFORM.getMobChampionData(livingEntity).ifPresent(data -> {
                if (data.getRank().ordinal() > 0) {
                    this.explosionRadius = (int)((double)this.explosionRadius * ConfigHandler.Common.getCreeperExplosionRadiusMultiplier(data.getRank()));
                }
            });
        }
    }

    @Inject(method={"spawnLingeringCloud"}, at={@At(value="HEAD")}, cancellable=true)
    private void mobchampions$spawnLingeringCloud(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (!livingEntity.level().isClientSide()) {
            Services.PLATFORM.getMobChampionData(livingEntity).ifPresent(data -> {
                if (data.getRank().ordinal() > 0) {
                    ci.cancel();
                }
            });
        }
    }
}

