/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.platform;

import java.util.Optional;
import mobchampions.attachments.MobChampionDataAttachment;
import mobchampions.network.IMobChampion;
import mobchampions.network.LaunchFireworksPacket;
import mobchampions.network.SyncMobChampionData;
import mobchampions.platform.services.IPlatform;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector3f;

public class NeoForgePlatform
implements IPlatform {
    @Override
    public void sendLaunchFireworksPacket(LivingEntity entity) {
        Vector3f location = entity.getEyePosition().toVector3f();
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new LaunchFireworksPacket(location), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public Optional<? extends IMobChampion> getMobChampionData(LivingEntity entity) {
        return MobChampionDataAttachment.getData((Entity)entity);
    }

    @Override
    public void syncMobChampionData(ServerPlayer player, LivingEntity entity) {
        this.getMobChampionData(entity).ifPresent(data -> PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncMobChampionData(data.getEntityId(), data.getRank()), (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.getCurrent().isProduction();
    }
}

