/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.data.loot;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import mobchampions.loot.MobChampionsLootTables;
import mobchampions.util.LootTableHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorMaterials;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.item.equipment.trim.TrimPatterns;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;
import technology.roughness.whitenoise.util.ColorHelper;

public class MobChampionsWearableLoot
implements LootTableSubProvider {
    private final HolderLookup.RegistryLookup<Enchantment> enchantmentRegistryLookup;
    private final HolderLookup.RegistryLookup<TrimPattern> patternRegistry;
    private final HolderLookup.RegistryLookup<TrimMaterial> materialRegistry;
    private final Map<ArmorMaterial, List<Item>> armorItems = Map.of(ArmorMaterials.LEATHER, List.of(Items.LEATHER_HELMET, Items.LEATHER_CHESTPLATE, Items.LEATHER_LEGGINGS, Items.LEATHER_BOOTS), ArmorMaterials.CHAINMAIL, List.of(Items.CHAINMAIL_HELMET, Items.CHAINMAIL_CHESTPLATE, Items.CHAINMAIL_LEGGINGS, Items.CHAINMAIL_BOOTS), ArmorMaterials.IRON, List.of(Items.IRON_HELMET, Items.IRON_CHESTPLATE, Items.IRON_LEGGINGS, Items.IRON_BOOTS), ArmorMaterials.GOLD, List.of(Items.GOLDEN_HELMET, Items.GOLDEN_CHESTPLATE, Items.GOLDEN_LEGGINGS, Items.GOLDEN_BOOTS), ArmorMaterials.DIAMOND, List.of(Items.DIAMOND_HELMET, Items.DIAMOND_CHESTPLATE, Items.DIAMOND_LEGGINGS, Items.DIAMOND_BOOTS), ArmorMaterials.NETHERITE, List.of(Items.NETHERITE_HELMET, Items.NETHERITE_CHESTPLATE, Items.NETHERITE_LEGGINGS, Items.NETHERITE_BOOTS));

    public MobChampionsWearableLoot(HolderLookup.Provider lookupProvider) {
        this.enchantmentRegistryLookup = lookupProvider.lookupOrThrow(Registries.ENCHANTMENT);
        this.patternRegistry = lookupProvider.lookupOrThrow(Registries.TRIM_PATTERN);
        this.materialRegistry = lookupProvider.lookupOrThrow(Registries.TRIM_MATERIAL);
    }

    private void init() {
    }

    public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        this.generateUncommonWearableLoot(consumer);
        this.generateRareWearableLoot(consumer);
        this.generateEpicWearableLoot(consumer);
        this.generateLegendaryWearableLoot(consumer);
    }

    private void generateUncommonWearableLoot(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        LootPool.Builder lootPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootTableHelper.addDyedItem(Items.LEATHER_HELMET, "propeller_hat", 100, ChatFormatting.GREEN, DyeColor.RED.getTextColor(), List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.FEATHER_FALLING, (NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.GOLDEN_CHESTPLATE, "cactus_armor", 100, ChatFormatting.DARK_GREEN, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.THORNS, (NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f))), this.enchantmentRegistryLookup));
        List<LootPoolSingletonContainer.Builder<?>> leatherArmorSet = LootTableHelper.createDyedArmorSet(this.getTrim((ResourceKey<TrimPattern>)TrimPatterns.WILD, (ResourceKey<TrimMaterial>)TrimMaterials.COPPER), "wildling", 80, ChatFormatting.DARK_GREEN, this.armorItems.get(ArmorMaterials.LEATHER), List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.PROTECTION, (NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.UNBREAKING, (NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))), this.enchantmentRegistryLookup, ColorHelper.Colors.DARK_GREEN.toRGBA());
        for (LootPoolSingletonContainer.Builder<?> armorPiece : leatherArmorSet) {
            lootPool.add(armorPiece);
        }
        consumer.accept(MobChampionsLootTables.UNCOMMON_WEARABLE_LOOT, LootTable.lootTable().withPool(lootPool));
    }

    private void generateRareWearableLoot(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        LootPool.Builder lootPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootTableHelper.addItem(Items.GOLDEN_CHESTPLATE, "sticky_chestplate", 80, ChatFormatting.YELLOW, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.PROTECTION, (NumberProvider)UniformGenerator.between((float)4.0f, (float)7.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.BINDING_CURSE, (NumberProvider)ConstantValue.exactly((float)1.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.GOLDEN_LEGGINGS, "sticky_leggings", 80, ChatFormatting.YELLOW, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.PROTECTION, (NumberProvider)UniformGenerator.between((float)4.0f, (float)7.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.BINDING_CURSE, (NumberProvider)ConstantValue.exactly((float)1.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.IRON_BOOTS, "long_fall_boots", 80, ChatFormatting.YELLOW, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.FEATHER_FALLING, (NumberProvider)UniformGenerator.between((float)5.0f, (float)6.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.CHAINMAIL_BOOTS, "soul_walkers", 100, ChatFormatting.GRAY, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.SOUL_SPEED, (NumberProvider)UniformGenerator.between((float)4.0f, (float)5.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.UNBREAKING, (NumberProvider)ConstantValue.exactly((float)2.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.LEATHER_BOOTS, "winter_flippers", 90, ChatFormatting.DARK_AQUA, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.FROST_WALKER, (NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.DEPTH_STRIDER, (NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.TURTLE_HELMET, "diving_helmet", 100, ChatFormatting.AQUA, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.RESPIRATION, (NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.DEPTH_STRIDER, (NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.CHAINMAIL_CHESTPLATE, "bulletproof_vest", 100, ChatFormatting.DARK_RED, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.PROJECTILE_PROTECTION, (NumberProvider)UniformGenerator.between((float)4.0f, (float)6.0f))), this.enchantmentRegistryLookup));
        List<LootPoolSingletonContainer.Builder<?>> ironArmorSet = LootTableHelper.createArmorSet(this.getTrim((ResourceKey<TrimPattern>)TrimPatterns.SENTRY, (ResourceKey<TrimMaterial>)TrimMaterials.EMERALD), "knight", 80, ChatFormatting.GRAY, this.armorItems.get(ArmorMaterials.IRON), List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.PROTECTION, (NumberProvider)UniformGenerator.between((float)3.0f, (float)4.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.UNBREAKING, (NumberProvider)UniformGenerator.between((float)3.0f, (float)4.0f))), this.enchantmentRegistryLookup);
        for (LootPoolSingletonContainer.Builder<?> armorPiece : ironArmorSet) {
            lootPool.add(armorPiece);
        }
        consumer.accept(MobChampionsLootTables.RARE_WEARABLE_LOOT, LootTable.lootTable().withPool(lootPool));
    }

    private void generateEpicWearableLoot(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        LootPool.Builder lootPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
        List<LootPoolSingletonContainer.Builder<?>> diamondArmorSet = LootTableHelper.createArmorSet(this.getTrim((ResourceKey<TrimPattern>)TrimPatterns.WARD, (ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ), "shiny", 20, ChatFormatting.DARK_AQUA, this.armorItems.get(ArmorMaterials.DIAMOND), List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.PROTECTION, (NumberProvider)UniformGenerator.between((float)4.0f, (float)5.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.BLAST_PROTECTION, (NumberProvider)UniformGenerator.between((float)4.0f, (float)5.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.FIRE_PROTECTION, (NumberProvider)UniformGenerator.between((float)4.0f, (float)5.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.UNBREAKING, (NumberProvider)UniformGenerator.between((float)4.0f, (float)5.0f))), this.enchantmentRegistryLookup);
        for (LootPoolSingletonContainer.Builder<?> armorPiece : diamondArmorSet) {
            lootPool.add(armorPiece);
        }
        consumer.accept(MobChampionsLootTables.EPIC_WEARABLE_LOOT, LootTable.lootTable().withPool(lootPool));
    }

    private void generateLegendaryWearableLoot(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        LootPool.Builder lootPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootTableHelper.addItem(Items.ELYTRA, "plated_elytra", 10, ChatFormatting.WHITE, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.PROTECTION, (NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))), this.enchantmentRegistryLookup)).add(LootTableHelper.addItem(Items.DIAMOND_CHESTPLATE, "warding_chestplate", 20, ChatFormatting.LIGHT_PURPLE, List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.PROTECTION, (NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.BLAST_PROTECTION, (NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.PROJECTILE_PROTECTION, (NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.FIRE_PROTECTION, (NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))), this.enchantmentRegistryLookup));
        List<LootPoolSingletonContainer.Builder<?>> netheriteArmorSet = LootTableHelper.createArmorSet(this.getTrim((ResourceKey<TrimPattern>)TrimPatterns.SNOUT, (ResourceKey<TrimMaterial>)TrimMaterials.GOLD), "champions", 10, ChatFormatting.GOLD, this.armorItems.get(ArmorMaterials.NETHERITE), List.of(new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.PROTECTION, (NumberProvider)UniformGenerator.between((float)6.0f, (float)7.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.BLAST_PROTECTION, (NumberProvider)UniformGenerator.between((float)6.0f, (float)7.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.FIRE_PROTECTION, (NumberProvider)UniformGenerator.between((float)6.0f, (float)7.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.PROJECTILE_PROTECTION, (NumberProvider)UniformGenerator.between((float)6.0f, (float)7.0f)), new LootTableHelper.ItemEnchantment((ResourceKey<Enchantment>)Enchantments.UNBREAKING, (NumberProvider)UniformGenerator.between((float)6.0f, (float)7.0f))), this.enchantmentRegistryLookup);
        for (LootPoolSingletonContainer.Builder<?> armorPiece : netheriteArmorSet) {
            lootPool.add(armorPiece);
        }
        consumer.accept(MobChampionsLootTables.LEGENDARY_WEARABLE_LOOT, LootTable.lootTable().withPool(lootPool));
    }

    private ArmorTrim getTrim(ResourceKey<TrimPattern> pattern, ResourceKey<TrimMaterial> material) {
        Holder.Reference tidePattern = (Holder.Reference)this.patternRegistry.get(pattern).orElseThrow();
        Holder.Reference goldMaterial = (Holder.Reference)this.materialRegistry.get(material).orElseThrow();
        return new ArmorTrim((Holder)goldMaterial, (Holder)tidePattern);
    }
}

