/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.mixin;

import mobchampions.config.ConfigHandler;
import mobchampions.event.MobChampionEventHandler;
import mobchampions.network.MobChampion;
import mobchampions.platform.Services;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin {
    @Inject(method={"finalizeSpawn"}, at={@At(value="RETURN")})
    public void mobchampions$onFinalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, SpawnGroupData spawnGroupData, CallbackInfoReturnable<SpawnGroupData> cir) {
        if (!ConfigHandler.Common.getSpawnReasonBlacklistEnums().contains(spawnReason)) {
            LivingEntity livingEntity = (LivingEntity)this;
            MobChampionEventHandler.addRandomChampion(livingEntity);
        } else {
            LivingEntity livingEntity = (LivingEntity)this;
            MobChampionEventHandler.addNormalMob(livingEntity);
        }
    }

    @Inject(method={"getBaseExperienceReward"}, at={@At(value="RETURN")}, cancellable=true)
    public void mobchampions$modifyExperienceReward(CallbackInfoReturnable<Integer> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        int baseXP = (Integer)cir.getReturnValue();
        if (baseXP <= 0) {
            return;
        }
        Services.PLATFORM.getMobChampionData(livingEntity).ifPresent(data -> {
            if (data.getEntityId() != -1 && data.getRank() != MobChampion.Rank.COMMON) {
                int modifiedXP = (int)((double)baseXP * ConfigHandler.Common.getExperienceMultiplierForRank(data.getRank()));
                cir.setReturnValue((Object)modifiedXP);
            }
        });
    }
}

