/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mobchampions.MobChampions;
import mobchampions.common.effect.MobChampionsEffects;
import mobchampions.common.stats.ChampionStats;
import mobchampions.common.stats.ChampionStatsManager;
import mobchampions.config.ConfigHandler;
import mobchampions.loot.MobChampionsLootTables;
import mobchampions.network.MobChampion;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.commons.lang3.tuple.Pair;

public class MobChampionBuilder {
    private static final ChampionStats uncommonStats = ChampionStatsManager.getStatsForRank(MobChampion.Rank.UNCOMMON);
    private static final ChampionStats rareStats = ChampionStatsManager.getStatsForRank(MobChampion.Rank.RARE);
    private static final ChampionStats epicStats = ChampionStatsManager.getStatsForRank(MobChampion.Rank.EPIC);
    private static final ChampionStats legendaryStats = ChampionStatsManager.getStatsForRank(MobChampion.Rank.LEGENDARY);
    private static final AttributeModifier UNCOMMON_HEALTH_MODIFIER = new AttributeModifier(MobChampions.prefix("uncommon_health_multiplier"), (double)uncommonStats.getHealthMultiplier(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final AttributeModifier UNCOMMON_ARMOR_MODIFIER = new AttributeModifier(MobChampions.prefix("uncommon_armor_addition"), (double)uncommonStats.getArmorAddition(), AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier UNCOMMON_MOVEMENT_SPEED_MODIFIER = new AttributeModifier(MobChampions.prefix("uncommon_movement_speed_multiplier"), (double)uncommonStats.getMovementSpeedMultiplier(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final AttributeModifier UNCOMMON_ATTACK_DAMAGE_MODIFIER = new AttributeModifier(MobChampions.prefix("uncommon_attack_damage_multiplier"), (double)uncommonStats.getAttackDamageMultiplier(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final AttributeModifier UNCOMMON_KNOCKBACK_RESISTANCE_MODIFIER = new AttributeModifier(MobChampions.prefix("uncommon_knockback_resistance_addition"), (double)uncommonStats.getKnockbackResistanceAddition(), AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier RARE_HEALTH_MODIFIER = new AttributeModifier(MobChampions.prefix("rare_health_multiplier"), (double)rareStats.getHealthMultiplier(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final AttributeModifier RARE_ARMOR_MODIFIER = new AttributeModifier(MobChampions.prefix("rare_armor_addition"), (double)rareStats.getArmorAddition(), AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier RARE_MOVEMENT_SPEED_MODIFIER = new AttributeModifier(MobChampions.prefix("rare_movement_speed_multiplier"), (double)rareStats.getMovementSpeedMultiplier(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final AttributeModifier RARE_ATTACK_DAMAGE_MODIFIER = new AttributeModifier(MobChampions.prefix("rare_attack_damage_multiplier"), (double)rareStats.getAttackDamageMultiplier(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final AttributeModifier RARE_KNOCKBACK_RESISTANCE_MODIFIER = new AttributeModifier(MobChampions.prefix("rare_knockback_resistance_addition"), (double)rareStats.getKnockbackResistanceAddition(), AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier EPIC_HEALTH_MODIFIER = new AttributeModifier(MobChampions.prefix("epic_health_multiplier"), (double)epicStats.getHealthMultiplier(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final AttributeModifier EPIC_ARMOR_MODIFIER = new AttributeModifier(MobChampions.prefix("epic_armor_addition"), (double)epicStats.getArmorAddition(), AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier EPIC_MOVEMENT_SPEED_MODIFIER = new AttributeModifier(MobChampions.prefix("epic_movement_speed_multiplier"), (double)epicStats.getMovementSpeedMultiplier(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final AttributeModifier EPIC_ATTACK_DAMAGE_MODIFIER = new AttributeModifier(MobChampions.prefix("epic_attack_damage_multiplier"), (double)epicStats.getAttackDamageMultiplier(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final AttributeModifier EPIC_KNOCKBACK_RESISTANCE_MODIFIER = new AttributeModifier(MobChampions.prefix("epic_knockback_resistance_addition"), (double)epicStats.getKnockbackResistanceAddition(), AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier LEGENDARY_HEALTH_MODIFIER = new AttributeModifier(MobChampions.prefix("legendary_health_multiplier"), (double)legendaryStats.getHealthMultiplier(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final AttributeModifier LEGENDARY_ARMOR_MODIFIER = new AttributeModifier(MobChampions.prefix("legendary_armor_addition"), (double)legendaryStats.getArmorAddition(), AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier LEGENDARY_MOVEMENT_SPEED_MODIFIER = new AttributeModifier(MobChampions.prefix("legendary_movement_speed_multiplier"), (double)legendaryStats.getMovementSpeedMultiplier(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final AttributeModifier LEGENDARY_ATTACK_DAMAGE_MODIFIER = new AttributeModifier(MobChampions.prefix("legendary_attack_damage_multiplier"), (double)legendaryStats.getAttackDamageMultiplier(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final AttributeModifier LEGENDARY_KNOCKBACK_RESISTANCE_MODIFIER = new AttributeModifier(MobChampions.prefix("legendary_knockback_resistance_addition"), (double)legendaryStats.getKnockbackResistanceAddition(), AttributeModifier.Operation.ADD_VALUE);
    private static final AttributeModifier SAFE_FALL_DISTANCE_MODIFIER = new AttributeModifier(MobChampions.prefix("safe_fall_distance_addition"), 320.0, AttributeModifier.Operation.ADD_VALUE);

    public static void build(LivingEntity entity, MobChampion.Rank rank) {
        switch (rank) {
            case UNCOMMON: {
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.MAX_HEALTH), UNCOMMON_HEALTH_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.ARMOR), UNCOMMON_ARMOR_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.MOVEMENT_SPEED), UNCOMMON_MOVEMENT_SPEED_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.ATTACK_DAMAGE), UNCOMMON_ATTACK_DAMAGE_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.KNOCKBACK_RESISTANCE), UNCOMMON_KNOCKBACK_RESISTANCE_MODIFIER);
                break;
            }
            case RARE: {
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.MAX_HEALTH), RARE_HEALTH_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.ARMOR), RARE_ARMOR_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.MOVEMENT_SPEED), RARE_MOVEMENT_SPEED_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.ATTACK_DAMAGE), RARE_ATTACK_DAMAGE_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.KNOCKBACK_RESISTANCE), RARE_KNOCKBACK_RESISTANCE_MODIFIER);
                break;
            }
            case EPIC: {
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.MAX_HEALTH), EPIC_HEALTH_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.ARMOR), EPIC_ARMOR_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.MOVEMENT_SPEED), EPIC_MOVEMENT_SPEED_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.ATTACK_DAMAGE), EPIC_ATTACK_DAMAGE_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.KNOCKBACK_RESISTANCE), EPIC_KNOCKBACK_RESISTANCE_MODIFIER);
                break;
            }
            case LEGENDARY: {
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.MAX_HEALTH), LEGENDARY_HEALTH_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.ARMOR), LEGENDARY_ARMOR_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.MOVEMENT_SPEED), LEGENDARY_MOVEMENT_SPEED_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.ATTACK_DAMAGE), LEGENDARY_ATTACK_DAMAGE_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.KNOCKBACK_RESISTANCE), LEGENDARY_KNOCKBACK_RESISTANCE_MODIFIER);
                break;
            }
        }
        if (rank != MobChampion.Rank.COMMON) {
            MobChampionBuilder.addChampionAttribute(entity.getAttribute(Attributes.SAFE_FALL_DISTANCE), SAFE_FALL_DISTANCE_MODIFIER);
        }
        MobChampionBuilder.updateMaxHealth(entity);
        MobChampionBuilder.applyChampionEffect(entity, rank);
        MobChampionBuilder.applyGlowingEffectIfNeeded(entity, rank);
        MobChampionBuilder.applyInfestedEffectIfNeeded(entity, rank);
        MobChampionBuilder.applyWeavingEffectIfNeeded(entity, rank);
        MobChampionBuilder.applyWindChargedEffectIfNeeded(entity, rank);
        MobChampionBuilder.applyFireResistanceEffectIfNeeded(entity, rank);
        MobChampionBuilder.equipChampionWeaponIfNeeded(entity, rank);
        MobChampionBuilder.equipChampionGearIfNeeded(entity, rank);
    }

    private static void equipChampionWeaponIfNeeded(LivingEntity entity, MobChampion.Rank rank) {
        EquipmentSlot weaponSlot = EquipmentSlot.MAINHAND;
        if (entity.canUseSlot(weaponSlot)) {
            ItemStack standardWeapon = ConfigHandler.Common.getWeaponForRank(rank);
            Pair<Boolean, ItemStack> maybeWeapon = MobChampionBuilder.maybeUpgradeWeaponToLootTableWeapon(entity, standardWeapon, rank);
            if (((Boolean)maybeWeapon.getLeft()).booleanValue()) {
                if (maybeWeapon.getRight() != null && ((ItemStack)maybeWeapon.getRight()).getItem() instanceof ShieldItem) {
                    weaponSlot = EquipmentSlot.OFFHAND;
                }
                entity.setItemSlot(weaponSlot, (ItemStack)maybeWeapon.getRight());
            } else if (standardWeapon != null) {
                if (standardWeapon.getItem() instanceof ShieldItem) {
                    weaponSlot = EquipmentSlot.OFFHAND;
                }
                entity.setItemSlot(weaponSlot, standardWeapon);
            }
            MobChampionBuilder.finalizeChampionWeapon(entity, rank, (Boolean)maybeWeapon.getLeft(), weaponSlot);
        }
    }

    private static Pair<Boolean, ItemStack> maybeUpgradeWeaponToLootTableWeapon(LivingEntity entity, ItemStack weapon, MobChampion.Rank rank) {
        double chanceToUpgrade = ConfigHandler.Common.getLootableWeaponSpawnChanceForRank(rank);
        ResourceKey<LootTable> equipmentLootTable = MobChampionsLootTables.getWeaponLootTable(rank);
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ObjectArrayList list;
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(equipmentLootTable);
            LootParams params = MobChampionBuilder.createEquipmentParams(entity, serverLevel);
            if (lootTable != LootTable.EMPTY && (double)MobChampions.RANDOM.nextFloat() < chanceToUpgrade && !(list = lootTable.getRandomItems(params, 0L)).isEmpty()) {
                return Pair.of((Object)true, (Object)((ItemStack)list.getFirst()));
            }
        }
        return Pair.of((Object)false, (Object)weapon);
    }

    private static LootParams createEquipmentParams(LivingEntity livingEntity, ServerLevel level) {
        return new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)livingEntity.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)livingEntity).create(LootContextParamSets.EQUIPMENT);
    }

    private static void finalizeChampionWeapon(LivingEntity entity, MobChampion.Rank rank, boolean hasLootTableWeapon, EquipmentSlot weaponSlot) {
        if (!entity.getItemBySlot(weaponSlot).isEmpty() && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            Level level = entity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                DifficultyInstance difficultyInstance = serverLevel.getCurrentDifficultyAt(entity.blockPosition());
                MobChampionBuilder.enchantSpawnedWeapon((LivingEntity)mob, rank, (ServerLevelAccessor)serverLevel, RandomSource.createNewThreadLocalInstance(), difficultyInstance);
            }
            if (hasLootTableWeapon) {
                mob.setDropChance(weaponSlot, ConfigHandler.Common.getLootDropChance(rank));
            } else {
                mob.setDropChance(weaponSlot, (float)ConfigHandler.Common.getStandardWeaponDropChance());
            }
        }
    }

    private static void equipChampionGearIfNeeded(LivingEntity entity, MobChampion.Rank rank) {
        for (EquipmentSlot slot : MobChampionBuilder.getArmorSlots()) {
            ItemStack armor;
            if (!entity.canUseSlot(slot) || (armor = ConfigHandler.Common.getArmorForRankAndSlot(rank, slot)) == null) continue;
            entity.setItemSlot(slot, armor);
        }
        Pair<EquipmentSlot, ItemStack> upgrade = MobChampionBuilder.maybeUpgradeArmorToLootTableArmor(entity, rank);
        if (upgrade.getLeft() != null) {
            entity.setItemSlot((EquipmentSlot)upgrade.getLeft(), (ItemStack)upgrade.getRight());
        }
        MobChampionBuilder.finalizeChampionArmor(entity, rank, (EquipmentSlot)upgrade.getLeft());
    }

    private static Pair<EquipmentSlot, ItemStack> maybeUpgradeArmorToLootTableArmor(LivingEntity livingEntity, MobChampion.Rank rank) {
        double chanceToUpgrade = ConfigHandler.Common.getLootableArmorSpawnChanceForRank(rank);
        ResourceKey<LootTable> equipmentLootTable = MobChampionsLootTables.getWearableLootTable(rank);
        Level level = livingEntity.level();
        if (level instanceof ServerLevel) {
            ItemStack armorItem;
            Equippable equippable;
            ObjectArrayList list;
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(equipmentLootTable);
            LootParams params = MobChampionBuilder.createEquipmentParams(livingEntity, serverLevel);
            if (lootTable != LootTable.EMPTY && (double)MobChampions.RANDOM.nextFloat() < chanceToUpgrade && !(list = lootTable.getRandomItems(params, 0L)).isEmpty() && (equippable = (Equippable)(armorItem = (ItemStack)list.getFirst()).get(DataComponents.EQUIPPABLE)) != null) {
                return Pair.of((Object)equippable.slot(), (Object)armorItem);
            }
        }
        return Pair.of(null, null);
    }

    private static void finalizeChampionArmor(LivingEntity entity, MobChampion.Rank rank, EquipmentSlot lootTableArmorSlot) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            Level level = entity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                DifficultyInstance difficultyInstance = serverLevel.getCurrentDifficultyAt(entity.blockPosition());
                for (EquipmentSlot slot : MobChampionBuilder.getArmorSlots()) {
                    if (entity.getItemBySlot(slot).isEmpty()) continue;
                    MobChampionBuilder.enchantSpawnedArmor((LivingEntity)mob, rank, (ServerLevelAccessor)serverLevel, serverLevel.getRandom(), slot, difficultyInstance);
                    if (slot == lootTableArmorSlot) {
                        mob.setDropChance(slot, ConfigHandler.Common.getLootDropChance(rank));
                        continue;
                    }
                    mob.setDropChance(slot, (float)ConfigHandler.Common.getStandardArmorDropChance());
                }
            }
        }
    }

    private static void enchantSpawnedWeapon(LivingEntity entity, MobChampion.Rank rank, ServerLevelAccessor level, RandomSource random, DifficultyInstance difficulty) {
        MobChampionBuilder.enchantSpawnedEquipment(entity, level, EquipmentSlot.MAINHAND, random, switch (rank) {
            case MobChampion.Rank.RARE -> 0.3f;
            case MobChampion.Rank.EPIC -> 0.6f;
            case MobChampion.Rank.LEGENDARY -> 0.8f;
            default -> 0.15f;
        }, difficulty, rank);
    }

    private static void enchantSpawnedArmor(LivingEntity entity, MobChampion.Rank rank, ServerLevelAccessor level, RandomSource random, EquipmentSlot slot, DifficultyInstance difficulty) {
        MobChampionBuilder.enchantSpawnedEquipment(entity, level, slot, random, switch (rank) {
            case MobChampion.Rank.RARE -> 0.5f;
            case MobChampion.Rank.EPIC -> 0.75f;
            case MobChampion.Rank.LEGENDARY -> 1.0f;
            default -> 0.25f;
        }, difficulty, rank);
    }

    private static void enchantSpawnedEquipment(LivingEntity entity, ServerLevelAccessor level, EquipmentSlot slot, RandomSource random, float enchantChance, DifficultyInstance difficulty, MobChampion.Rank rank) {
        ItemStack itemstack = entity.getItemBySlot(slot);
        if (!itemstack.isEmpty() && random.nextFloat() < enchantChance * difficulty.getSpecialMultiplier()) {
            EnchantmentHelper.enchantItemFromProvider((ItemStack)itemstack, (RegistryAccess)level.registryAccess(), (ResourceKey)VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, (DifficultyInstance)difficulty, (RandomSource)random);
            entity.setItemSlot(slot, itemstack);
        }
    }

    private static void applyChampionEffect(LivingEntity entity, MobChampion.Rank rank) {
        Holder<MobEffect> mobEffectHolder = MobChampionsEffects.getChampionEffectHolderByRank(rank);
        if (mobEffectHolder != null) {
            entity.forceAddEffect(new MobEffectInstance(mobEffectHolder, -1), (Entity)entity);
        }
    }

    private static void applyGlowingEffectIfNeeded(LivingEntity entity, MobChampion.Rank rank) {
        int glowingEffectMinimumRankOrdinal = ConfigHandler.Common.getGlowingEffectMinimumRank().ordinal();
        if (rank.ordinal() >= glowingEffectMinimumRankOrdinal) {
            int glowingEffectDuration = ConfigHandler.Common.getGlowingEffectDuration();
            if (glowingEffectDuration < 0) {
                glowingEffectDuration = Integer.MAX_VALUE;
            }
            entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, glowingEffectDuration, 1, false, false));
        }
    }

    private static void applyInfestedEffectIfNeeded(LivingEntity entity, MobChampion.Rank rank) {
        int infestedEffectMinimumRankOrdinal = ConfigHandler.Common.getInfestedEffectMinimumRank().ordinal();
        if (rank.ordinal() >= infestedEffectMinimumRankOrdinal) {
            double infestedEffectChance = ConfigHandler.Common.getInfestedEffectChance();
            double bonusMultiplier = 1.0 + ConfigHandler.Common.getLegendaryEffectBonusMultiplier();
            if (rank == MobChampion.Rank.LEGENDARY) {
                infestedEffectChance *= bonusMultiplier;
            }
            if ((double)MobChampions.RANDOM.nextFloat() <= infestedEffectChance) {
                MobEffectInstance infestedEffect = new MobEffectInstance(MobEffects.INFESTED, -1);
                entity.addEffect(infestedEffect);
            }
        }
    }

    private static void applyWeavingEffectIfNeeded(LivingEntity entity, MobChampion.Rank rank) {
        int weavingEffectMinimumRankOrdinal = ConfigHandler.Common.getWeavingEffectMinimumRank().ordinal();
        if (rank.ordinal() >= weavingEffectMinimumRankOrdinal) {
            double weavingEffectChance = ConfigHandler.Common.getWeavingEffectChance();
            double bonusMultiplier = 1.0 + ConfigHandler.Common.getLegendaryEffectBonusMultiplier();
            if (rank == MobChampion.Rank.LEGENDARY) {
                weavingEffectChance *= bonusMultiplier;
            }
            if ((double)MobChampions.RANDOM.nextFloat() <= weavingEffectChance) {
                MobEffectInstance weavingEffect = new MobEffectInstance(MobEffects.WEAVING, -1);
                entity.addEffect(weavingEffect);
            }
        }
    }

    private static void applyWindChargedEffectIfNeeded(LivingEntity entity, MobChampion.Rank rank) {
        int windChargedEffectMinimumRankOrdinal = ConfigHandler.Common.getWindChargedEffectMinimumRank().ordinal();
        if (rank.ordinal() >= windChargedEffectMinimumRankOrdinal) {
            double windChargedEffectChance = ConfigHandler.Common.getWindChargedEffectChance();
            double bonusMultiplier = 1.0 + ConfigHandler.Common.getLegendaryEffectBonusMultiplier();
            if (rank == MobChampion.Rank.LEGENDARY) {
                windChargedEffectChance *= bonusMultiplier;
            }
            if ((double)MobChampions.RANDOM.nextFloat() <= windChargedEffectChance) {
                MobEffectInstance windChargedEffect = new MobEffectInstance(MobEffects.WIND_CHARGED, -1);
                entity.addEffect(windChargedEffect);
            }
        }
    }

    private static void applyFireResistanceEffectIfNeeded(LivingEntity entity, MobChampion.Rank rank) {
        int fireResistanceEffectMinimumRankOrdinal = ConfigHandler.Common.getFireResistanceEffectMinimumRank().ordinal();
        if (rank.ordinal() >= fireResistanceEffectMinimumRankOrdinal) {
            double fireResistanceEffectChance = ConfigHandler.Common.getFireResistanceEffectChance();
            if ((double)MobChampions.RANDOM.nextFloat() <= fireResistanceEffectChance) {
                MobEffectInstance fireResistanceEffect = new MobEffectInstance(MobEffects.FIRE_RESISTANCE, -1, 1, false, false);
                entity.addEffect(fireResistanceEffect);
            }
        }
    }

    public static void updateMaxHealth(LivingEntity entity) {
        AttributeInstance maxHealthAttribute = entity.getAttribute(Attributes.MAX_HEALTH);
        if (maxHealthAttribute != null) {
            entity.setHealth((float)maxHealthAttribute.getValue());
        }
    }

    public static void addChampionAttribute(AttributeInstance attributeInstance, AttributeModifier modifier) {
        if (attributeInstance != null && !attributeInstance.hasModifier(modifier.id())) {
            attributeInstance.addPermanentModifier(modifier);
        }
    }

    public static List<EquipmentSlot> getArmorSlots() {
        return List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
    }
}

