/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.config;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mobchampions.MobChampions;
import mobchampions.common.Translations;
import mobchampions.common.stats.ChampionStatsManager;
import mobchampions.network.MobChampion;
import mobchampions.platform.Services;
import mobchampions.util.ColorHelper;
import mobchampions.util.MobChampionBuilder;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_5151;
import net.minecraft.class_7923;
import net.minecraft.class_9283;
import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;

public class ConfigHandler {
    public static final WhiteNoiseConfigSpec CLIENT_SPEC;
    public static final WhiteNoiseConfigSpec COMMON_SPEC;
    private static final Client CLIENT;
    private static final Common COMMON;

    public static void clientInit() {
        Client.decodedColors.clear();
        ((List)ConfigHandler.CLIENT.fireworksColors.get()).forEach(colorString -> Client.decodedColors.add(ColorHelper.decode(colorString).getRGB()));
    }

    public static void commonInit() {
        Common.totalWeight = (Integer)ConfigHandler.COMMON.commonMobWeight.get() + (Integer)ConfigHandler.COMMON.uncommonWeight.get() + (Integer)ConfigHandler.COMMON.rareWeight.get() + (Integer)ConfigHandler.COMMON.epicWeight.get() + (Integer)ConfigHandler.COMMON.legendaryWeight.get();
        Common.championWeightMap.clear();
        block13: for (MobChampion.Rank rank : MobChampion.Rank.values()) {
            switch (rank) {
                case COMMON: {
                    if ((Integer)ConfigHandler.COMMON.commonMobWeight.get() < 0) continue block13;
                    Common.championWeightMap.put(0, rank);
                    continue block13;
                }
                case UNCOMMON: {
                    if ((Integer)ConfigHandler.COMMON.commonMobWeight.get() < 0) continue block13;
                    Common.championWeightMap.put((Integer)ConfigHandler.COMMON.commonMobWeight.get(), rank);
                    continue block13;
                }
                case RARE: {
                    if ((Integer)ConfigHandler.COMMON.commonMobWeight.get() < 0) continue block13;
                    Common.championWeightMap.put((Integer)ConfigHandler.COMMON.commonMobWeight.get() + (Integer)ConfigHandler.COMMON.uncommonWeight.get(), rank);
                    continue block13;
                }
                case EPIC: {
                    if ((Integer)ConfigHandler.COMMON.commonMobWeight.get() < 0) continue block13;
                    Common.championWeightMap.put((Integer)ConfigHandler.COMMON.commonMobWeight.get() + (Integer)ConfigHandler.COMMON.uncommonWeight.get() + (Integer)ConfigHandler.COMMON.rareWeight.get(), rank);
                    continue block13;
                }
                case LEGENDARY: {
                    if ((Integer)ConfigHandler.COMMON.commonMobWeight.get() < 0) continue block13;
                    Common.championWeightMap.put((Integer)ConfigHandler.COMMON.commonMobWeight.get() + (Integer)ConfigHandler.COMMON.uncommonWeight.get() + (Integer)ConfigHandler.COMMON.rareWeight.get() + (Integer)ConfigHandler.COMMON.epicWeight.get(), rank);
                }
            }
        }
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            MobChampions.LOGGER.warn("Configured champion rank weights: {} {}", Common.championWeightMap, (Object)Common.getTotalWeight());
            MobChampions.LOGGER.warn("Odds: Common: {}%, Uncommon: {}%, Rare: {}%, Epic: {}%, Legendary: {}%", new Object[]{Float.valueOf((float)((Integer)ConfigHandler.COMMON.commonMobWeight.get()).intValue() * 100.0f / (float)Common.getTotalWeight()), Float.valueOf((float)((Integer)ConfigHandler.COMMON.uncommonWeight.get()).intValue() * 100.0f / (float)Common.getTotalWeight()), Float.valueOf((float)((Integer)ConfigHandler.COMMON.rareWeight.get()).intValue() * 100.0f / (float)Common.getTotalWeight()), Float.valueOf((float)((Integer)ConfigHandler.COMMON.epicWeight.get()).intValue() * 100.0f / (float)Common.getTotalWeight()), Float.valueOf((float)((Integer)ConfigHandler.COMMON.legendaryWeight.get()).intValue() * 100.0f / (float)Common.getTotalWeight())});
        }
        Common.spawnTypeBlacklistEnums.clear();
        ((List)ConfigHandler.COMMON.spawnTypeBlacklistSource.get()).forEach(spawnTypeString -> Common.spawnTypeBlacklistEnums.add((Enum<class_3730>)Enum.valueOf(class_3730.class, spawnTypeString)));
        Common.uncommonWeaponItemsMap.clear();
        Common.rareWeaponItemsMap.clear();
        Common.epicWeaponItemsMap.clear();
        Common.legendaryWeaponItemsMap.clear();
        int[] lastUncommonWeight = new int[]{0};
        int[] lastRareWeight = new int[]{0};
        int[] lastEpicWeight = new int[]{0};
        int[] lastLegendaryWeight = new int[]{0};
        ((List)ConfigHandler.COMMON.weapons.get()).forEach(weaponString -> {
            String[] weaponParts = weaponString.split("-", 3);
            MobChampion.Rank rank = switch (weaponParts[0]) {
                case "2" -> MobChampion.Rank.RARE;
                case "3" -> MobChampion.Rank.EPIC;
                case "4" -> MobChampion.Rank.LEGENDARY;
                default -> MobChampion.Rank.UNCOMMON;
            };
            int weight = Integer.parseInt(weaponParts[1]);
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)weaponParts[2]));
            if (item == class_1802.field_8162) {
                MobChampions.LOGGER.warn("Invalid item '{}' in weapons list, skipping...", (Object)weaponParts[2]);
                return;
            }
            class_1799 itemStack = new class_1799((class_1935)item);
            switch (rank) {
                case UNCOMMON: {
                    Common.uncommonWeaponItemsMap.put(lastUncommonWeight[0], itemStack);
                    lastUncommonWeight[0] = lastUncommonWeight[0] + weight;
                    break;
                }
                case RARE: {
                    Common.rareWeaponItemsMap.put(lastRareWeight[0], itemStack);
                    lastRareWeight[0] = lastRareWeight[0] + weight;
                    break;
                }
                case EPIC: {
                    Common.epicWeaponItemsMap.put(lastEpicWeight[0], itemStack);
                    lastEpicWeight[0] = lastEpicWeight[0] + weight;
                    break;
                }
                case LEGENDARY: {
                    Common.legendaryWeaponItemsMap.put(lastLegendaryWeight[0], itemStack);
                    lastLegendaryWeight[0] = lastLegendaryWeight[0] + weight;
                }
            }
        });
        Common.totalUncommonWeaponWeight = lastUncommonWeight[0];
        Common.totalRareWeaponWeight = lastRareWeight[0];
        Common.totalEpicWeaponWeight = lastEpicWeight[0];
        Common.totalLegendaryWeaponWeight = lastLegendaryWeight[0];
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            MobChampions.LOGGER.warn("Configured uncommon weapon items: {} of: {}", Common.uncommonWeaponItemsMap, (Object)Common.totalUncommonWeaponWeight);
            MobChampions.LOGGER.warn("Configured rare weapon items: {} of: {}", Common.rareWeaponItemsMap, (Object)Common.totalRareWeaponWeight);
            MobChampions.LOGGER.warn("Configured epic weapon items: {} of: {}", Common.epicWeaponItemsMap, (Object)Common.totalEpicWeaponWeight);
            MobChampions.LOGGER.warn("Configured legendary weapon items: {} of: {}", Common.legendaryWeaponItemsMap, (Object)Common.totalLegendaryWeaponWeight);
        }
        HashMap<class_1304, Integer> lastUncommonWeights = new HashMap<class_1304, Integer>();
        HashMap<class_1304, Integer> lastRareWeights = new HashMap<class_1304, Integer>();
        HashMap<class_1304, Integer> lastEpicWeights = new HashMap<class_1304, Integer>();
        HashMap<class_1304, Integer> lastLegendaryWeights = new HashMap<class_1304, Integer>();
        for (class_1304 slot : MobChampionBuilder.getArmorSlots()) {
            block15: for (MobChampion.Rank rank : MobChampion.Rank.values()) {
                switch (rank) {
                    case UNCOMMON: {
                        Common.totalUncommonArmorWeight.put(slot, 0);
                        lastUncommonWeights.put(slot, 0);
                        Common.uncommonArmorItemsMap.put(slot, new TreeMap());
                        continue block15;
                    }
                    case RARE: {
                        Common.totalRareArmorWeight.put(slot, 0);
                        lastRareWeights.put(slot, 0);
                        Common.rareArmorItemsMap.put(slot, new TreeMap());
                        continue block15;
                    }
                    case EPIC: {
                        Common.totalEpicArmorWeight.put(slot, 0);
                        lastEpicWeights.put(slot, 0);
                        Common.epicArmorItemsMap.put(slot, new TreeMap());
                        continue block15;
                    }
                    case LEGENDARY: {
                        Common.totalLegendaryArmorWeight.put(slot, 0);
                        lastLegendaryWeights.put(slot, 0);
                        Common.legendaryArmorItemsMap.put(slot, new TreeMap());
                        continue block15;
                    }
                }
            }
        }
        ((List)ConfigHandler.COMMON.armors.get()).forEach(armorString -> {
            String[] armorParts = armorString.split("-", 3);
            MobChampion.Rank rank = switch (armorParts[0]) {
                case "2" -> MobChampion.Rank.RARE;
                case "3" -> MobChampion.Rank.EPIC;
                case "4" -> MobChampion.Rank.LEGENDARY;
                default -> MobChampion.Rank.UNCOMMON;
            };
            int weight = Integer.parseInt(armorParts[1]);
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)armorParts[2]));
            if (item == class_1802.field_8162) {
                MobChampions.LOGGER.warn("Invalid item '{}' in armors list, skipping...", (Object)armorParts[2]);
                return;
            }
            class_1799 itemStack = new class_1799((class_1935)item);
            class_5151 equipable = class_5151.method_48957((class_1799)itemStack);
            if (equipable == null) {
                MobChampions.LOGGER.warn("Item '{}' in armors list is not equipable, skipping...", (Object)armorParts[2]);
                return;
            }
            class_1304 slot = equipable.method_7685();
            switch (rank) {
                case UNCOMMON: {
                    Common.uncommonArmorItemsMap.get(slot).put((Integer)lastUncommonWeights.get(slot), itemStack);
                    lastUncommonWeights.put(slot, (Integer)lastUncommonWeights.get(slot) + weight);
                    break;
                }
                case RARE: {
                    Common.rareArmorItemsMap.get(slot).put((Integer)lastRareWeights.get(slot), itemStack);
                    lastRareWeights.put(slot, (Integer)lastRareWeights.get(slot) + weight);
                    break;
                }
                case EPIC: {
                    Common.epicArmorItemsMap.get(slot).put((Integer)lastEpicWeights.get(slot), itemStack);
                    lastEpicWeights.put(slot, (Integer)lastEpicWeights.get(slot) + weight);
                    break;
                }
                case LEGENDARY: {
                    Common.legendaryArmorItemsMap.get(slot).put((Integer)lastLegendaryWeights.get(slot), itemStack);
                    lastLegendaryWeights.put(slot, (Integer)lastLegendaryWeights.get(slot) + weight);
                }
            }
        });
        for (class_1304 slot : MobChampionBuilder.getArmorSlots()) {
            Common.totalUncommonArmorWeight.put(slot, (Integer)lastUncommonWeights.get(slot));
            Common.totalRareArmorWeight.put(slot, (Integer)lastRareWeights.get(slot));
            Common.totalEpicArmorWeight.put(slot, (Integer)lastEpicWeights.get(slot));
            Common.totalLegendaryArmorWeight.put(slot, (Integer)lastLegendaryWeights.get(slot));
            if (!Services.PLATFORM.isDevelopmentEnvironment()) continue;
            MobChampions.LOGGER.warn("Configured uncommon armor {} items: {} of: {}", new Object[]{slot, Common.uncommonArmorItemsMap.get(slot), Common.totalUncommonArmorWeight.get(slot)});
            MobChampions.LOGGER.warn("Configured rare armor {} items: {} of: {}", new Object[]{slot, Common.rareArmorItemsMap.get(slot), Common.totalRareArmorWeight.get(slot)});
            MobChampions.LOGGER.warn("Configured epic armor {} items: {} of: {}", new Object[]{slot, Common.epicArmorItemsMap.get(slot), Common.totalEpicArmorWeight.get(slot)});
            MobChampions.LOGGER.warn("Configured legendary armor {} items: {} of: {}", new Object[]{slot, Common.legendaryArmorItemsMap.get(slot), Common.totalLegendaryArmorWeight.get(slot)});
        }
    }

    private static String getTranslation(String key) {
        return Translations.get(key);
    }

    private static String getTranslation(String key, String ... values) {
        return Translations.get(key, values);
    }

    static {
        Pair specPairClient = new WhiteNoiseConfigSpec.Builder().configure(Client::new);
        Pair specPairCommon = new WhiteNoiseConfigSpec.Builder().configure(Common::new);
        CLIENT_SPEC = (WhiteNoiseConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
        COMMON_SPEC = (WhiteNoiseConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
    }

    public static class Client {
        private static final String[] colorStrings = new String[]{"#FFDB00", "#F49000", "#D27C00", "#BD6F00"};
        private static final List<String> colorsList = List.of("colors");
        private static final IntList decodedColors = new IntArrayList();
        private static final Predicate<Object> hexValidator = s -> s instanceof String && ((String)s).matches("#[a-fA-F\\d]{6}");
        private static final List<String> shapes = Stream.of(class_9283.class_1782.values()).map(Enum::name).toList();
        private final WhiteNoiseConfigSpec.ConfigValue<String> uncommonColor;
        private final WhiteNoiseConfigSpec.ConfigValue<String> rareColor;
        private final WhiteNoiseConfigSpec.ConfigValue<String> epicColor;
        private final WhiteNoiseConfigSpec.ConfigValue<String> legendaryColor;
        private final WhiteNoiseConfigSpec.DoubleValue fireworksChance;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> fireworksColors;
        private final WhiteNoiseConfigSpec.BooleanValue fireworksFlicker;
        private final WhiteNoiseConfigSpec.BooleanValue fireworksTrail;
        private final WhiteNoiseConfigSpec.EnumValue<class_9283.class_1782> fireworksShape;
        private final WhiteNoiseConfigSpec.IntValue fireworksHeight;

        public Client(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("visuals");
            this.uncommonColor = builder.comment(ConfigHandler.getTranslation("uncommoncolor")).define("uncommonColor", (Object)"#00F403", hexValidator);
            this.rareColor = builder.comment(ConfigHandler.getTranslation("rarecolor")).define("rareColor", (Object)"#3600FF", hexValidator);
            this.epicColor = builder.comment(ConfigHandler.getTranslation("epiccolor")).define("epicColor", (Object)"#EF00F4", hexValidator);
            this.legendaryColor = builder.comment(ConfigHandler.getTranslation("legendarycolor")).define("legendaryColor", (Object)"#F49000", hexValidator);
            this.fireworksChance = builder.comment(ConfigHandler.getTranslation("fireworkschance")).defineInRange("fireworksChance", 1.0, 0.0, 1.0);
            this.fireworksColors = builder.comment(new String[]{ConfigHandler.getTranslation("colors"), "Default: [\"" + String.join((CharSequence)"\", \"", colorStrings) + "\"]"}).defineListAllowEmpty(colorsList, Client.getColors(), hexValidator);
            this.fireworksFlicker = builder.comment(ConfigHandler.getTranslation("fireworksflicker")).define("fireworksFlicker", true);
            this.fireworksTrail = builder.comment(ConfigHandler.getTranslation("fireworkstrail")).define("fireworksTrail", true);
            this.fireworksShape = builder.comment(new String[]{ConfigHandler.getTranslation("fireworksshape"), "One of: " + String.valueOf(shapes)}).defineEnum("fireworksShape", (Enum)class_9283.class_1782.field_7970);
            this.fireworksHeight = builder.comment(new String[]{ConfigHandler.getTranslation("fireworksheight"), "Default 5"}).defineInRange("fireworksHeight", 3, 0, 32);
        }

        public static int getUncommonColor() {
            return ColorHelper.hexToARGB((String)ConfigHandler.CLIENT.uncommonColor.get());
        }

        public static int getRareColor() {
            return ColorHelper.hexToARGB((String)ConfigHandler.CLIENT.rareColor.get());
        }

        public static int getEpicColor() {
            return ColorHelper.hexToARGB((String)ConfigHandler.CLIENT.epicColor.get());
        }

        public static int getLegendaryColor() {
            return ColorHelper.hexToARGB((String)ConfigHandler.CLIENT.legendaryColor.get());
        }

        public static int getChampionColor(MobChampion.Rank rank) {
            return switch (rank) {
                case MobChampion.Rank.RARE -> Client.getRareColor();
                case MobChampion.Rank.EPIC -> Client.getEpicColor();
                case MobChampion.Rank.LEGENDARY -> Client.getLegendaryColor();
                default -> Client.getUncommonColor();
            };
        }

        public static double fireworksChance() {
            return (Double)ConfigHandler.CLIENT.fireworksChance.get();
        }

        public static IntList getColorsList() {
            return decodedColors;
        }

        public static boolean fireworksFlicker() {
            return (Boolean)ConfigHandler.CLIENT.fireworksFlicker.get();
        }

        public static boolean fireworksTrail() {
            return (Boolean)ConfigHandler.CLIENT.fireworksTrail.get();
        }

        public static class_9283.class_1782 getFireworksShape() {
            return (class_9283.class_1782)ConfigHandler.CLIENT.fireworksShape.get();
        }

        public static float getFireworksHeight() {
            return ((Integer)ConfigHandler.CLIENT.fireworksHeight.get()).intValue();
        }

        private static Supplier<List<? extends String>> getColors() {
            return () -> Arrays.asList(colorStrings);
        }
    }

    public static class Common {
        private static int totalWeight;
        private static final NavigableMap<Integer, MobChampion.Rank> championWeightMap;
        private final WhiteNoiseConfigSpec.BooleanValue fireworksOnDeath;
        private final WhiteNoiseConfigSpec.EnumValue<MobChampion.Rank> fireworksMinimumRank;
        private final WhiteNoiseConfigSpec.BooleanValue disableBabyChampions;
        private final WhiteNoiseConfigSpec.BooleanValue enableSpawnMessage;
        private final WhiteNoiseConfigSpec.EnumValue<MobChampion.Rank> spawnMessageMinimumRank;
        private final WhiteNoiseConfigSpec.IntValue spawnMessageRange;
        private final WhiteNoiseConfigSpec.IntValue commonMobWeight;
        private final WhiteNoiseConfigSpec.IntValue uncommonWeight;
        private final WhiteNoiseConfigSpec.IntValue rareWeight;
        private final WhiteNoiseConfigSpec.IntValue epicWeight;
        private final WhiteNoiseConfigSpec.IntValue legendaryWeight;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> championWhitelistMobs;
        private static final List<String> championWhitelist;
        private static final String[] defaultWhitelist;
        private final Predicate<Object> resourceLocationValidator = s -> s instanceof String && ((String)s).matches("[a-z]+[:]{1}[a-z_]+");
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> spawnTypeBlacklistSource;
        private static final List<Enum<class_3730>> spawnTypeBlacklistEnums;
        private static final List<String> spawnTypeBlacklist;
        private static final String[] defaultSpawnTypeBlacklist;
        private final Predicate<Object> spawnTypeValidator = s -> s instanceof String && Arrays.stream(class_3730.values()).map(Enum::name).anyMatch(name -> name.equals(s));
        private final WhiteNoiseConfigSpec.IntValue uncommonDifficulty;
        private final WhiteNoiseConfigSpec.IntValue rareDifficulty;
        private final WhiteNoiseConfigSpec.IntValue epicDifficulty;
        private final WhiteNoiseConfigSpec.IntValue legendaryDifficulty;
        private final WhiteNoiseConfigSpec.EnumValue<MobChampion.Rank> glowingEffectMinimumRank;
        private final WhiteNoiseConfigSpec.IntValue glowingEffectDuration;
        private final WhiteNoiseConfigSpec.EnumValue<MobChampion.Rank> infestedEffectMinimumRank;
        private final WhiteNoiseConfigSpec.DoubleValue infestedEffectChance;
        private final WhiteNoiseConfigSpec.EnumValue<MobChampion.Rank> weavingEffectMinimumRank;
        private final WhiteNoiseConfigSpec.DoubleValue weavingEffectChance;
        private final WhiteNoiseConfigSpec.EnumValue<MobChampion.Rank> windChargedEffectMinimumRank;
        private final WhiteNoiseConfigSpec.DoubleValue windChargedEffectChance;
        private final WhiteNoiseConfigSpec.EnumValue<MobChampion.Rank> fireResistanceEffectMinimumRank;
        private final WhiteNoiseConfigSpec.DoubleValue fireResistanceEffectChance;
        private final WhiteNoiseConfigSpec.DoubleValue legendaryEffectBonusMultiplier;
        private final WhiteNoiseConfigSpec.DoubleValue creeperExplosionRadiusMultiplier;
        private final WhiteNoiseConfigSpec.DoubleValue uncommonStandardWeaponSpawnChance;
        private final WhiteNoiseConfigSpec.DoubleValue rareStandardWeaponSpawnChance;
        private final WhiteNoiseConfigSpec.DoubleValue epicStandardWeaponSpawnChance;
        private final WhiteNoiseConfigSpec.DoubleValue legendaryStandardWeaponSpawnChance;
        private final WhiteNoiseConfigSpec.DoubleValue uncommonLootableWeaponSpawnChance;
        private final WhiteNoiseConfigSpec.DoubleValue rareLootableWeaponSpawnChance;
        private final WhiteNoiseConfigSpec.DoubleValue epicLootableWeaponSpawnChance;
        private final WhiteNoiseConfigSpec.DoubleValue legendaryLootableWeaponSpawnChance;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> weapons;
        private static final List<String> weaponList;
        private static final String[] defaultWeapons;
        private static final Predicate<Object> armorAndEquipmentValidator;
        private static int totalUncommonWeaponWeight;
        private static int totalRareWeaponWeight;
        private static int totalEpicWeaponWeight;
        private static int totalLegendaryWeaponWeight;
        private static final NavigableMap<Integer, class_1799> uncommonWeaponItemsMap;
        private static final NavigableMap<Integer, class_1799> rareWeaponItemsMap;
        private static final NavigableMap<Integer, class_1799> epicWeaponItemsMap;
        private static final NavigableMap<Integer, class_1799> legendaryWeaponItemsMap;
        private final WhiteNoiseConfigSpec.DoubleValue uncommonStandardArmorSpawnChance;
        private final WhiteNoiseConfigSpec.DoubleValue rareStandardArmorSpawnChance;
        private final WhiteNoiseConfigSpec.DoubleValue epicStandardArmorSpawnChance;
        private final WhiteNoiseConfigSpec.DoubleValue legendaryStandardArmorSpawnChance;
        private final WhiteNoiseConfigSpec.DoubleValue uncommonLootableArmorSpawnChance;
        private final WhiteNoiseConfigSpec.DoubleValue rareLootableArmorSpawnChance;
        private final WhiteNoiseConfigSpec.DoubleValue epicLootableArmorSpawnChance;
        private final WhiteNoiseConfigSpec.DoubleValue legendaryLootableArmorSpawnChance;
        private final WhiteNoiseConfigSpec.ConfigValue<List<? extends String>> armors;
        private static final List<String> armorList;
        private static final String[] defaultArmors;
        private static final Map<class_1304, Integer> totalUncommonArmorWeight;
        private static final Map<class_1304, Integer> totalRareArmorWeight;
        private static final Map<class_1304, Integer> totalEpicArmorWeight;
        private static final Map<class_1304, Integer> totalLegendaryArmorWeight;
        private static final Map<class_1304, NavigableMap<Integer, class_1799>> uncommonArmorItemsMap;
        private static final Map<class_1304, NavigableMap<Integer, class_1799>> rareArmorItemsMap;
        private static final Map<class_1304, NavigableMap<Integer, class_1799>> epicArmorItemsMap;
        private static final Map<class_1304, NavigableMap<Integer, class_1799>> legendaryArmorItemsMap;
        private final WhiteNoiseConfigSpec.DoubleValue uncommonExperienceMultiplier;
        private final WhiteNoiseConfigSpec.DoubleValue rareExperienceMultiplier;
        private final WhiteNoiseConfigSpec.DoubleValue epicExperienceMultiplier;
        private final WhiteNoiseConfigSpec.DoubleValue legendaryExperienceMultiplier;
        private final WhiteNoiseConfigSpec.DoubleValue standardArmorDropChance;
        private final WhiteNoiseConfigSpec.DoubleValue standardWeaponDropChance;

        public Common(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("mobdeath").comment(ConfigHandler.getTranslation("mobdeath"));
            this.fireworksOnDeath = builder.comment(ConfigHandler.getTranslation("fireworksondeath")).define("fireworksOnDeath", true);
            this.fireworksMinimumRank = builder.comment(ConfigHandler.getTranslation("fireworksminimumrank")).defineEnum("fireworksMinimumRank", (Enum)MobChampion.Rank.LEGENDARY);
            builder.pop();
            builder.push("spawning").comment(ConfigHandler.getTranslation("spawning"));
            this.disableBabyChampions = builder.comment(ConfigHandler.getTranslation("disablebabychampions")).define("disableBabyChampions", false);
            this.enableSpawnMessage = builder.comment(ConfigHandler.getTranslation("enablespawnmessage")).define("enableSpawnMessage", true);
            this.spawnMessageMinimumRank = builder.comment(ConfigHandler.getTranslation("spawnmessageminimumrank")).defineEnum("spawnMessageMinimumRank", (Enum)MobChampion.Rank.LEGENDARY);
            this.spawnMessageRange = builder.comment(ConfigHandler.getTranslation("spawnmessagerange")).defineInRange("spawnMessageRange", 64, 0, 256);
            this.commonMobWeight = builder.comment(ConfigHandler.getTranslation("commonmobweight")).defineInRange("commonMobWeight", 200, 0, 5000);
            this.uncommonWeight = builder.comment(ConfigHandler.getTranslation("uncommonweight")).defineInRange("uncommonWeight", 50, 0, 100);
            this.rareWeight = builder.comment(ConfigHandler.getTranslation("rareweight")).defineInRange("rareWeight", 30, 0, 100);
            this.epicWeight = builder.comment(ConfigHandler.getTranslation("epicweight")).defineInRange("epicWeight", 9, 0, 100);
            this.legendaryWeight = builder.comment(ConfigHandler.getTranslation("legendaryweight")).defineInRange("legendaryWeight", 2, 0, 100);
            this.championWhitelistMobs = builder.comment(new String[]{ConfigHandler.getTranslation("championwhitelist", String.join((CharSequence)", ", defaultWhitelist)), "Entity types must be in the format modid:entity_name"}).defineListAllowEmpty(championWhitelist, Common.getFields(defaultWhitelist), this.resourceLocationValidator);
            this.spawnTypeBlacklistSource = builder.comment(ConfigHandler.getTranslation("spawntypeblacklist")).defineListAllowEmpty(spawnTypeBlacklist, Common.getFields(defaultSpawnTypeBlacklist), this.spawnTypeValidator);
            builder.push("stats").comment(ConfigHandler.getTranslation("stats"));
            this.uncommonDifficulty = builder.comment(ConfigHandler.getTranslation("uncommondifficulty")).defineInRange("uncommonDifficulty", 5, 1, 10);
            this.rareDifficulty = builder.comment(ConfigHandler.getTranslation("raredifficulty")).defineInRange("rareDifficulty", 5, 1, 10);
            this.epicDifficulty = builder.comment(ConfigHandler.getTranslation("epicdifficulty")).defineInRange("epicDifficulty", 5, 1, 10);
            this.legendaryDifficulty = builder.comment(ConfigHandler.getTranslation("legendarydifficulty")).defineInRange("legendaryDifficulty", 5, 1, 10);
            builder.pop();
            builder.push("effects").comment(ConfigHandler.getTranslation("effects"));
            this.glowingEffectMinimumRank = builder.comment(ConfigHandler.getTranslation("glowingeffectminimumrank")).defineEnum("glowingEffectMinimumRank", (Enum)MobChampion.Rank.LEGENDARY);
            this.glowingEffectDuration = builder.comment(ConfigHandler.getTranslation("glowingeffectduration")).defineInRange("glowingEffectDuration", 15, -1, 60);
            this.infestedEffectMinimumRank = builder.comment(ConfigHandler.getTranslation("infestedeffectminimumrank")).defineEnum("infestedEffectMinimumRank", (Enum)MobChampion.Rank.EPIC);
            this.infestedEffectChance = builder.comment(ConfigHandler.getTranslation("infestedeffectchance")).defineInRange("infestedEffectChance", 0.35, 0.0, 1.0);
            this.weavingEffectMinimumRank = builder.comment(ConfigHandler.getTranslation("weavingeffectminimumrank")).defineEnum("weavingEffectMinimumRank", (Enum)MobChampion.Rank.RARE);
            this.weavingEffectChance = builder.comment(ConfigHandler.getTranslation("weavingeffectchance")).defineInRange("weavingEffectChance", 0.6, 0.0, 1.0);
            this.windChargedEffectMinimumRank = builder.comment(ConfigHandler.getTranslation("windchargedeffectminimumrank")).defineEnum("windChargedEffectMinimumRank", (Enum)MobChampion.Rank.EPIC);
            this.windChargedEffectChance = builder.comment(ConfigHandler.getTranslation("windchargedeffectchance")).defineInRange("windChargedEffectChance", 0.2, 0.0, 1.0);
            this.fireResistanceEffectMinimumRank = builder.comment(ConfigHandler.getTranslation("fireresistanceeffectminimumrank")).defineEnum("fireResistanceEffectMinimumRank", (Enum)MobChampion.Rank.UNCOMMON);
            this.fireResistanceEffectChance = builder.comment(ConfigHandler.getTranslation("fireresistanceeffectchance")).defineInRange("fireResistanceEffectChance", 1.0, 0.0, 1.0);
            this.legendaryEffectBonusMultiplier = builder.comment(ConfigHandler.getTranslation("legendaryeffectbonusmultiplier")).defineInRange("legendaryEffectBonusMultiplier", 0.5, 0.0, 1.0);
            this.creeperExplosionRadiusMultiplier = builder.comment(ConfigHandler.getTranslation("creeperexplosionradiusmultiplier")).defineInRange("creeperExplosionRadiusMultiplier", 0.25, 0.0, 1.0);
            builder.pop();
            builder.push("equipment").comment(ConfigHandler.getTranslation("equipment"));
            this.uncommonStandardWeaponSpawnChance = builder.comment(ConfigHandler.getTranslation("uncommonstandardweaponspawnchance")).defineInRange("uncommonStandardWeaponSpawnChance", 0.7, 0.0, 1.0);
            this.rareStandardWeaponSpawnChance = builder.comment(ConfigHandler.getTranslation("rarestandardweaponspawnchance")).defineInRange("rareStandardWeaponSpawnChance", 0.8, 0.0, 1.0);
            this.epicStandardWeaponSpawnChance = builder.comment(ConfigHandler.getTranslation("epicstandardweaponspawnchance")).defineInRange("epicStandardWeaponSpawnChance", 0.9, 0.0, 1.0);
            this.legendaryStandardWeaponSpawnChance = builder.comment(ConfigHandler.getTranslation("legendarystandardweaponspawnchance")).defineInRange("legendaryStandardWeaponSpawnChance", 0.95, 0.0, 1.0);
            this.uncommonLootableWeaponSpawnChance = builder.comment(ConfigHandler.getTranslation("uncommonlootableweaponspawnchance")).defineInRange("uncommonLootableWeaponSpawnChance", 0.02, 0.0, 1.0);
            this.rareLootableWeaponSpawnChance = builder.comment(ConfigHandler.getTranslation("rarelootableweaponspawnchance")).defineInRange("rareLootableWeaponSpawnChance", 0.05, 0.0, 1.0);
            this.epicLootableWeaponSpawnChance = builder.comment(ConfigHandler.getTranslation("epiclootableweaponspawnchance")).defineInRange("epicLootableWeaponSpawnChance", 0.1, 0.0, 1.0);
            this.legendaryLootableWeaponSpawnChance = builder.comment(ConfigHandler.getTranslation("legendarylootableweaponspawnchance")).defineInRange("legendaryLootableWeaponSpawnChance", 0.25, 0.0, 1.0);
            this.weapons = builder.comment(ConfigHandler.getTranslation("weaponlist")).defineListAllowEmpty(weaponList, Common.getFields(defaultWeapons), armorAndEquipmentValidator);
            this.uncommonStandardArmorSpawnChance = builder.comment(ConfigHandler.getTranslation("uncommonstandardarmorspawnchance")).defineInRange("uncommonStandardArmorSpawnChance", 0.7, 0.0, 1.0);
            this.rareStandardArmorSpawnChance = builder.comment(ConfigHandler.getTranslation("rarestandardarmorspawnchance")).defineInRange("rareStandardArmorSpawnChance", 0.8, 0.0, 1.0);
            this.epicStandardArmorSpawnChance = builder.comment(ConfigHandler.getTranslation("epicstandardarmorspawnchance")).defineInRange("epicStandardArmorSpawnChance", 0.9, 0.0, 1.0);
            this.legendaryStandardArmorSpawnChance = builder.comment(ConfigHandler.getTranslation("legendarystandardarmorspawnchance")).defineInRange("legendaryStandardArmorSpawnChance", 0.95, 0.0, 1.0);
            this.uncommonLootableArmorSpawnChance = builder.comment(ConfigHandler.getTranslation("uncommonlootablearmorspawnchance")).defineInRange("uncommonLootableArmorSpawnChance", 0.05, 0.0, 1.0);
            this.rareLootableArmorSpawnChance = builder.comment(ConfigHandler.getTranslation("rarelootablearmorspawnchance")).defineInRange("rareLootableArmorSpawnChance", 0.1, 0.0, 1.0);
            this.epicLootableArmorSpawnChance = builder.comment(ConfigHandler.getTranslation("epiclootablearmorspawnchance")).defineInRange("epicLootableArmorSpawnChance", 0.25, 0.0, 1.0);
            this.legendaryLootableArmorSpawnChance = builder.comment(ConfigHandler.getTranslation("legendarylootablearmorspawnchance")).defineInRange("legendaryLootableArmorSpawnChance", 0.5, 0.0, 1.0);
            this.armors = builder.comment(ConfigHandler.getTranslation("armorlist")).defineListAllowEmpty(armorList, Common.getFields(defaultArmors), armorAndEquipmentValidator);
            builder.pop();
            builder.pop();
            builder.push("experience").comment(ConfigHandler.getTranslation("experience"));
            this.uncommonExperienceMultiplier = builder.comment(ConfigHandler.getTranslation("uncommonexperiencemultiplier")).defineInRange("uncommonExperienceMultiplier", 2.0, 0.0, 50.0);
            this.rareExperienceMultiplier = builder.comment(ConfigHandler.getTranslation("rareexperiencemultiplier")).defineInRange("rareExperienceMultiplier", 5.0, 0.0, 50.0);
            this.epicExperienceMultiplier = builder.comment(ConfigHandler.getTranslation("epicexperiencemultiplier")).defineInRange("epicExperienceMultiplier", 11.0, 0.0, 50.0);
            this.legendaryExperienceMultiplier = builder.comment(ConfigHandler.getTranslation("legendaryexperiencemultiplier")).defineInRange("legendaryExperienceMultiplier", 20.0, 0.0, 50.0);
            builder.pop();
            builder.push("lootdrops").comment(ConfigHandler.getTranslation("lootdrops"));
            this.standardWeaponDropChance = builder.comment(ConfigHandler.getTranslation("standardweapondropchance")).defineInRange("standardWeaponDropChance", 0.0, 0.0, 1.0);
            this.standardArmorDropChance = builder.comment(ConfigHandler.getTranslation("standardarmordropchance")).defineInRange("standardArmorDropChance", 0.0, 0.0, 1.0);
        }

        private static Supplier<List<? extends String>> getFields(String[] strings) {
            return () -> Arrays.asList(strings);
        }

        public static boolean fireworksOnDeath() {
            return (Boolean)ConfigHandler.COMMON.fireworksOnDeath.get();
        }

        public static MobChampion.Rank getFireworksMinimumRank() {
            return (MobChampion.Rank)((Object)ConfigHandler.COMMON.fireworksMinimumRank.get());
        }

        public static boolean isBabyChampionsDisabled() {
            return (Boolean)ConfigHandler.COMMON.disableBabyChampions.get();
        }

        public static boolean enableSpawnMessage() {
            return (Boolean)ConfigHandler.COMMON.enableSpawnMessage.get();
        }

        public static int getSpawnMessageMinimumRank() {
            return ((MobChampion.Rank)((Object)ConfigHandler.COMMON.spawnMessageMinimumRank.get())).ordinal();
        }

        public static int getSpawnMessageRange() {
            return (Integer)ConfigHandler.COMMON.spawnMessageRange.get();
        }

        public static int getTotalWeight() {
            return totalWeight;
        }

        public static MobChampion.Rank getChampionByWeight(int weight) {
            return championWeightMap.floorEntry(weight).getValue();
        }

        public static List<? extends String> getChampionWhitelist() {
            return (List)ConfigHandler.COMMON.championWhitelistMobs.get();
        }

        public static List<Enum<class_3730>> getSpawnTypeBlacklistEnums() {
            return spawnTypeBlacklistEnums;
        }

        public static int getDifficultyForRank(MobChampion.Rank rank) {
            return switch (rank) {
                case MobChampion.Rank.RARE -> (Integer)ConfigHandler.COMMON.rareDifficulty.get();
                case MobChampion.Rank.EPIC -> (Integer)ConfigHandler.COMMON.epicDifficulty.get();
                case MobChampion.Rank.LEGENDARY -> (Integer)ConfigHandler.COMMON.legendaryDifficulty.get();
                default -> (Integer)ConfigHandler.COMMON.uncommonDifficulty.get();
            };
        }

        public static double getProjectileDamageModifier(MobChampion.Rank rank) {
            return ChampionStatsManager.getStatsForRank(rank).getArrowDamageMultiplier();
        }

        public static MobChampion.Rank getGlowingEffectMinimumRank() {
            return (MobChampion.Rank)((Object)ConfigHandler.COMMON.glowingEffectMinimumRank.get());
        }

        public static int getGlowingEffectDuration() {
            return (Integer)ConfigHandler.COMMON.glowingEffectDuration.get() * 20;
        }

        public static MobChampion.Rank getInfestedEffectMinimumRank() {
            return (MobChampion.Rank)((Object)ConfigHandler.COMMON.infestedEffectMinimumRank.get());
        }

        public static double getInfestedEffectChance() {
            return (Double)ConfigHandler.COMMON.infestedEffectChance.get();
        }

        public static MobChampion.Rank getWeavingEffectMinimumRank() {
            return (MobChampion.Rank)((Object)ConfigHandler.COMMON.weavingEffectMinimumRank.get());
        }

        public static double getWeavingEffectChance() {
            return (Double)ConfigHandler.COMMON.weavingEffectChance.get();
        }

        public static MobChampion.Rank getWindChargedEffectMinimumRank() {
            return (MobChampion.Rank)((Object)ConfigHandler.COMMON.windChargedEffectMinimumRank.get());
        }

        public static double getWindChargedEffectChance() {
            return (Double)ConfigHandler.COMMON.windChargedEffectChance.get();
        }

        public static MobChampion.Rank getFireResistanceEffectMinimumRank() {
            return (MobChampion.Rank)((Object)ConfigHandler.COMMON.fireResistanceEffectMinimumRank.get());
        }

        public static double getFireResistanceEffectChance() {
            return (Double)ConfigHandler.COMMON.fireResistanceEffectChance.get();
        }

        public static double getLegendaryEffectBonusMultiplier() {
            return (Double)ConfigHandler.COMMON.legendaryEffectBonusMultiplier.get();
        }

        public static double getCreeperExplosionRadiusMultiplier(MobChampion.Rank rank) {
            return 1.0 + (Double)ConfigHandler.COMMON.creeperExplosionRadiusMultiplier.get() * (double)rank.ordinal();
        }

        public static class_1799 getWeaponForRank(MobChampion.Rank rank) {
            if ((double)MobChampions.RANDOM.nextFloat() > Common.getStandardWeaponSpawnChanceForRank(rank)) {
                return null;
            }
            switch (rank) {
                case UNCOMMON: {
                    int randomWeight = MobChampions.RANDOM.nextInt(totalUncommonWeaponWeight);
                    return Common.getRandomUncommonWeaponItem(randomWeight);
                }
                case RARE: {
                    int randomWeight = MobChampions.RANDOM.nextInt(totalRareWeaponWeight);
                    return Common.getRandomRareWeaponItem(randomWeight);
                }
                case EPIC: {
                    int randomWeight = MobChampions.RANDOM.nextInt(totalEpicWeaponWeight);
                    return Common.getRandomEpicWeaponItem(randomWeight);
                }
                case LEGENDARY: {
                    int randomWeight = MobChampions.RANDOM.nextInt(totalLegendaryWeaponWeight);
                    return Common.getRandomLegendaryWeaponItem(randomWeight);
                }
            }
            return null;
        }

        private static double getStandardWeaponSpawnChanceForRank(MobChampion.Rank rank) {
            return switch (rank) {
                case MobChampion.Rank.UNCOMMON -> (Double)ConfigHandler.COMMON.uncommonStandardWeaponSpawnChance.get();
                case MobChampion.Rank.RARE -> (Double)ConfigHandler.COMMON.rareStandardWeaponSpawnChance.get();
                case MobChampion.Rank.EPIC -> (Double)ConfigHandler.COMMON.epicStandardWeaponSpawnChance.get();
                case MobChampion.Rank.LEGENDARY -> (Double)ConfigHandler.COMMON.legendaryStandardWeaponSpawnChance.get();
                default -> 0.0;
            };
        }

        public static double getLootableWeaponSpawnChanceForRank(MobChampion.Rank rank) {
            return switch (rank) {
                case MobChampion.Rank.UNCOMMON -> (Double)ConfigHandler.COMMON.uncommonLootableWeaponSpawnChance.get();
                case MobChampion.Rank.RARE -> (Double)ConfigHandler.COMMON.rareLootableWeaponSpawnChance.get();
                case MobChampion.Rank.EPIC -> (Double)ConfigHandler.COMMON.epicLootableWeaponSpawnChance.get();
                case MobChampion.Rank.LEGENDARY -> (Double)ConfigHandler.COMMON.legendaryLootableWeaponSpawnChance.get();
                default -> 0.0;
            };
        }

        public static class_1799 getRandomUncommonWeaponItem(int weight) {
            return uncommonWeaponItemsMap.floorEntry(weight).getValue();
        }

        public static class_1799 getRandomRareWeaponItem(int weight) {
            return rareWeaponItemsMap.floorEntry(weight).getValue();
        }

        public static class_1799 getRandomEpicWeaponItem(int weight) {
            return epicWeaponItemsMap.floorEntry(weight).getValue();
        }

        public static class_1799 getRandomLegendaryWeaponItem(int weight) {
            return legendaryWeaponItemsMap.floorEntry(weight).getValue();
        }

        public static class_1799 getArmorForRankAndSlot(MobChampion.Rank rank, class_1304 slot) {
            if ((double)MobChampions.RANDOM.nextFloat() > Common.getStandardArmorSpawnChanceForRank(rank)) {
                return null;
            }
            switch (rank) {
                case UNCOMMON: {
                    int randomWeight = MobChampions.RANDOM.nextInt(totalUncommonArmorWeight.get(slot));
                    return Common.getRandomUncommonArmorItem(slot, randomWeight);
                }
                case RARE: {
                    int randomWeight = MobChampions.RANDOM.nextInt(totalRareArmorWeight.get(slot));
                    return Common.getRandomRareArmorItem(slot, randomWeight);
                }
                case EPIC: {
                    int randomWeight = MobChampions.RANDOM.nextInt(totalEpicArmorWeight.get(slot));
                    return Common.getRandomEpicArmorItem(slot, randomWeight);
                }
                case LEGENDARY: {
                    int randomWeight = MobChampions.RANDOM.nextInt(totalLegendaryArmorWeight.get(slot));
                    return Common.getRandomLegendaryArmorItem(slot, randomWeight);
                }
            }
            return null;
        }

        private static double getStandardArmorSpawnChanceForRank(MobChampion.Rank rank) {
            return switch (rank) {
                case MobChampion.Rank.UNCOMMON -> (Double)ConfigHandler.COMMON.uncommonStandardArmorSpawnChance.get();
                case MobChampion.Rank.RARE -> (Double)ConfigHandler.COMMON.rareStandardArmorSpawnChance.get();
                case MobChampion.Rank.EPIC -> (Double)ConfigHandler.COMMON.epicStandardArmorSpawnChance.get();
                case MobChampion.Rank.LEGENDARY -> (Double)ConfigHandler.COMMON.legendaryStandardArmorSpawnChance.get();
                default -> 0.0;
            };
        }

        public static double getLootableArmorSpawnChanceForRank(MobChampion.Rank rank) {
            return switch (rank) {
                case MobChampion.Rank.UNCOMMON -> (Double)ConfigHandler.COMMON.uncommonLootableArmorSpawnChance.get();
                case MobChampion.Rank.RARE -> (Double)ConfigHandler.COMMON.rareLootableArmorSpawnChance.get();
                case MobChampion.Rank.EPIC -> (Double)ConfigHandler.COMMON.epicLootableArmorSpawnChance.get();
                case MobChampion.Rank.LEGENDARY -> (Double)ConfigHandler.COMMON.legendaryLootableArmorSpawnChance.get();
                default -> 0.0;
            };
        }

        public static class_1799 getRandomUncommonArmorItem(class_1304 slot, int weight) {
            return uncommonArmorItemsMap.get(slot).floorEntry(weight).getValue();
        }

        public static class_1799 getRandomRareArmorItem(class_1304 slot, int weight) {
            return rareArmorItemsMap.get(slot).floorEntry(weight).getValue();
        }

        public static class_1799 getRandomEpicArmorItem(class_1304 slot, int weight) {
            return epicArmorItemsMap.get(slot).floorEntry(weight).getValue();
        }

        public static class_1799 getRandomLegendaryArmorItem(class_1304 slot, int weight) {
            return legendaryArmorItemsMap.get(slot).floorEntry(weight).getValue();
        }

        public static double getExperienceMultiplierForRank(MobChampion.Rank rank) {
            return switch (rank) {
                case MobChampion.Rank.UNCOMMON -> (Double)ConfigHandler.COMMON.uncommonExperienceMultiplier.get();
                case MobChampion.Rank.RARE -> (Double)ConfigHandler.COMMON.rareExperienceMultiplier.get();
                case MobChampion.Rank.EPIC -> (Double)ConfigHandler.COMMON.epicExperienceMultiplier.get();
                case MobChampion.Rank.LEGENDARY -> (Double)ConfigHandler.COMMON.legendaryExperienceMultiplier.get();
                default -> 1.0;
            };
        }

        public static double getStandardWeaponDropChance() {
            return (Double)ConfigHandler.COMMON.standardWeaponDropChance.get();
        }

        public static double getStandardArmorDropChance() {
            return (Double)ConfigHandler.COMMON.standardArmorDropChance.get();
        }

        public static float getLootDropChance(MobChampion.Rank rank) {
            int weight;
            switch (rank) {
                case UNCOMMON: {
                    int n = (Integer)ConfigHandler.COMMON.uncommonWeight.get();
                    break;
                }
                case RARE: {
                    int n = (Integer)ConfigHandler.COMMON.rareWeight.get();
                    break;
                }
                case EPIC: {
                    int n = (Integer)ConfigHandler.COMMON.epicWeight.get();
                    break;
                }
                case LEGENDARY: {
                    int n = (Integer)ConfigHandler.COMMON.legendaryWeight.get();
                    break;
                }
                default: {
                    int n = weight = 0;
                }
            }
            if (weight == 0 || Common.getTotalWeight() == 0) {
                return 0.0f;
            }
            return 1.0f - (float)weight / (float)Common.getTotalWeight();
        }

        static {
            championWeightMap = new TreeMap<Integer, MobChampion.Rank>();
            championWhitelist = List.of("championWhitelist");
            defaultWhitelist = new String[]{"minecraft:bogged", "minecraft:cave_spider", "minecraft:zombie", "minecraft:zombified_piglin", "minecraft:skeleton", "minecraft:creeper", "minecraft:spider", "minecraft:enderman", "minecraft:husk", "minecraft:stray", "minecraft:wither_skeleton", "minecraft:drowned", "minecraft:pillager"};
            spawnTypeBlacklistEnums = new ArrayList<Enum<class_3730>>();
            spawnTypeBlacklist = List.of("spawnTypeBlacklist");
            defaultSpawnTypeBlacklist = new String[]{class_3730.field_16466.name(), class_3730.field_16473.name(), class_3730.field_16472.name(), class_3730.field_16470.name(), class_3730.field_16527.name(), class_3730.field_16469.name(), class_3730.field_16474.name(), class_3730.field_47245.name()};
            weaponList = List.of("weaponList");
            defaultWeapons = new String[]{"1-10-minecraft:stone_sword", "1-10-minecraft:wooden_sword", "1-10-minecraft:stone_axe", "1-10-minecraft:wooden_axe", "2-10-minecraft:iron_sword", "2-10-minecraft:iron_axe", "2-20-minecraft:golden_sword", "2-20-minecraft:golden_axe", "3-20-minecraft:iron_sword", "3-20-minecraft:iron_axe", "3-10-minecraft:diamond_sword", "3-10-minecraft:diamond_axe", "4-30-minecraft:diamond_sword", "4-30-minecraft:diamond_axe", "4-10-minecraft:netherite_sword", "4-10-minecraft:netherite_axe"};
            armorAndEquipmentValidator = s -> s instanceof String && ((String)s).matches("[1-4]-[0-9]{0,3}-[a-z]+:[a-z_]+");
            totalUncommonWeaponWeight = 0;
            totalRareWeaponWeight = 0;
            totalEpicWeaponWeight = 0;
            totalLegendaryWeaponWeight = 0;
            uncommonWeaponItemsMap = new TreeMap<Integer, class_1799>();
            rareWeaponItemsMap = new TreeMap<Integer, class_1799>();
            epicWeaponItemsMap = new TreeMap<Integer, class_1799>();
            legendaryWeaponItemsMap = new TreeMap<Integer, class_1799>();
            armorList = List.of("armorList");
            defaultArmors = new String[]{"1-10-minecraft:golden_helmet", "1-10-minecraft:leather_helmet", "1-10-minecraft:golden_chestplate", "1-10-minecraft:leather_chestplate", "1-10-minecraft:golden_leggings", "1-10-minecraft:leather_leggings", "1-10-minecraft:golden_boots", "1-10-minecraft:leather_boots", "2-20-minecraft:chainmail_helmet", "2-10-minecraft:iron_helmet", "2-20-minecraft:chainmail_chestplate", "2-10-minecraft:iron_chestplate", "2-20-minecraft:chainmail_leggings", "2-10-minecraft:iron_leggings", "2-20-minecraft:chainmail_boots", "2-10-minecraft:iron_boots", "3-10-minecraft:diamond_helmet", "3-20-minecraft:iron_helmet", "3-10-minecraft:diamond_chestplate", "3-20-minecraft:iron_chestplate", "3-10-minecraft:diamond_leggings", "3-20-minecraft:iron_leggings", "3-10-minecraft:diamond_boots", "3-20-minecraft:iron_boots", "4-80-minecraft:diamond_helmet", "4-40-minecraft:netherite_helmet", "4-10-minecraft:diamond_chestplate", "4-5-minecraft:netherite_chestplate", "4-60-minecraft:diamond_leggings", "4-30-minecraft:netherite_leggings", "4-100-minecraft:diamond_boots", "4-50-minecraft:netherite_boots"};
            totalUncommonArmorWeight = new HashMap<class_1304, Integer>();
            totalRareArmorWeight = new HashMap<class_1304, Integer>();
            totalEpicArmorWeight = new HashMap<class_1304, Integer>();
            totalLegendaryArmorWeight = new HashMap<class_1304, Integer>();
            uncommonArmorItemsMap = new HashMap<class_1304, NavigableMap<Integer, class_1799>>();
            rareArmorItemsMap = new HashMap<class_1304, NavigableMap<Integer, class_1799>>();
            epicArmorItemsMap = new HashMap<class_1304, NavigableMap<Integer, class_1799>>();
            legendaryArmorItemsMap = new HashMap<class_1304, NavigableMap<Integer, class_1799>>();
        }
    }
}

