/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mobchampions.MobChampions;
import mobchampions.common.effect.MobChampionsEffects;
import mobchampions.common.stats.ChampionStats;
import mobchampions.common.stats.ChampionStatsManager;
import mobchampions.config.ConfigHandler;
import mobchampions.loot.MobChampionsLootTables;
import mobchampions.network.MobChampion;
import net.minecraft.class_1266;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1819;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_5151;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8567;
import net.minecraft.class_9747;
import org.apache.commons.lang3.tuple.Pair;

public class MobChampionBuilder {
    private static final ChampionStats uncommonStats = ChampionStatsManager.getStatsForRank(MobChampion.Rank.UNCOMMON);
    private static final ChampionStats rareStats = ChampionStatsManager.getStatsForRank(MobChampion.Rank.RARE);
    private static final ChampionStats epicStats = ChampionStatsManager.getStatsForRank(MobChampion.Rank.EPIC);
    private static final ChampionStats legendaryStats = ChampionStatsManager.getStatsForRank(MobChampion.Rank.LEGENDARY);
    private static final class_1322 UNCOMMON_HEALTH_MODIFIER = new class_1322(MobChampions.prefix("uncommon_health_multiplier"), (double)uncommonStats.getHealthMultiplier(), class_1322.class_1323.field_6330);
    private static final class_1322 UNCOMMON_ARMOR_MODIFIER = new class_1322(MobChampions.prefix("uncommon_armor_addition"), (double)uncommonStats.getArmorAddition(), class_1322.class_1323.field_6328);
    private static final class_1322 UNCOMMON_MOVEMENT_SPEED_MODIFIER = new class_1322(MobChampions.prefix("uncommon_movement_speed_multiplier"), (double)uncommonStats.getMovementSpeedMultiplier(), class_1322.class_1323.field_6330);
    private static final class_1322 UNCOMMON_ATTACK_DAMAGE_MODIFIER = new class_1322(MobChampions.prefix("uncommon_attack_damage_multiplier"), (double)uncommonStats.getAttackDamageMultiplier(), class_1322.class_1323.field_6330);
    private static final class_1322 UNCOMMON_KNOCKBACK_RESISTANCE_MODIFIER = new class_1322(MobChampions.prefix("uncommon_knockback_resistance_addition"), (double)uncommonStats.getKnockbackResistanceAddition(), class_1322.class_1323.field_6328);
    private static final class_1322 RARE_HEALTH_MODIFIER = new class_1322(MobChampions.prefix("rare_health_multiplier"), (double)rareStats.getHealthMultiplier(), class_1322.class_1323.field_6330);
    private static final class_1322 RARE_ARMOR_MODIFIER = new class_1322(MobChampions.prefix("rare_armor_addition"), (double)rareStats.getArmorAddition(), class_1322.class_1323.field_6328);
    private static final class_1322 RARE_MOVEMENT_SPEED_MODIFIER = new class_1322(MobChampions.prefix("rare_movement_speed_multiplier"), (double)rareStats.getMovementSpeedMultiplier(), class_1322.class_1323.field_6330);
    private static final class_1322 RARE_ATTACK_DAMAGE_MODIFIER = new class_1322(MobChampions.prefix("rare_attack_damage_multiplier"), (double)rareStats.getAttackDamageMultiplier(), class_1322.class_1323.field_6330);
    private static final class_1322 RARE_KNOCKBACK_RESISTANCE_MODIFIER = new class_1322(MobChampions.prefix("rare_knockback_resistance_addition"), (double)rareStats.getKnockbackResistanceAddition(), class_1322.class_1323.field_6328);
    private static final class_1322 EPIC_HEALTH_MODIFIER = new class_1322(MobChampions.prefix("epic_health_multiplier"), (double)epicStats.getHealthMultiplier(), class_1322.class_1323.field_6330);
    private static final class_1322 EPIC_ARMOR_MODIFIER = new class_1322(MobChampions.prefix("epic_armor_addition"), (double)epicStats.getArmorAddition(), class_1322.class_1323.field_6328);
    private static final class_1322 EPIC_MOVEMENT_SPEED_MODIFIER = new class_1322(MobChampions.prefix("epic_movement_speed_multiplier"), (double)epicStats.getMovementSpeedMultiplier(), class_1322.class_1323.field_6330);
    private static final class_1322 EPIC_ATTACK_DAMAGE_MODIFIER = new class_1322(MobChampions.prefix("epic_attack_damage_multiplier"), (double)epicStats.getAttackDamageMultiplier(), class_1322.class_1323.field_6330);
    private static final class_1322 EPIC_KNOCKBACK_RESISTANCE_MODIFIER = new class_1322(MobChampions.prefix("epic_knockback_resistance_addition"), (double)epicStats.getKnockbackResistanceAddition(), class_1322.class_1323.field_6328);
    private static final class_1322 LEGENDARY_HEALTH_MODIFIER = new class_1322(MobChampions.prefix("legendary_health_multiplier"), (double)legendaryStats.getHealthMultiplier(), class_1322.class_1323.field_6330);
    private static final class_1322 LEGENDARY_ARMOR_MODIFIER = new class_1322(MobChampions.prefix("legendary_armor_addition"), (double)legendaryStats.getArmorAddition(), class_1322.class_1323.field_6328);
    private static final class_1322 LEGENDARY_MOVEMENT_SPEED_MODIFIER = new class_1322(MobChampions.prefix("legendary_movement_speed_multiplier"), (double)legendaryStats.getMovementSpeedMultiplier(), class_1322.class_1323.field_6330);
    private static final class_1322 LEGENDARY_ATTACK_DAMAGE_MODIFIER = new class_1322(MobChampions.prefix("legendary_attack_damage_multiplier"), (double)legendaryStats.getAttackDamageMultiplier(), class_1322.class_1323.field_6330);
    private static final class_1322 LEGENDARY_KNOCKBACK_RESISTANCE_MODIFIER = new class_1322(MobChampions.prefix("legendary_knockback_resistance_addition"), (double)legendaryStats.getKnockbackResistanceAddition(), class_1322.class_1323.field_6328);
    private static final class_1322 SAFE_FALL_DISTANCE_MODIFIER = new class_1322(MobChampions.prefix("safe_fall_distance_addition"), 320.0, class_1322.class_1323.field_6328);

    public static void build(class_1309 entity, MobChampion.Rank rank) {
        switch (rank) {
            case UNCOMMON: {
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23716), UNCOMMON_HEALTH_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23724), UNCOMMON_ARMOR_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23719), UNCOMMON_MOVEMENT_SPEED_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23721), UNCOMMON_ATTACK_DAMAGE_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23718), UNCOMMON_KNOCKBACK_RESISTANCE_MODIFIER);
                break;
            }
            case RARE: {
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23716), RARE_HEALTH_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23724), RARE_ARMOR_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23719), RARE_MOVEMENT_SPEED_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23721), RARE_ATTACK_DAMAGE_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23718), RARE_KNOCKBACK_RESISTANCE_MODIFIER);
                break;
            }
            case EPIC: {
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23716), EPIC_HEALTH_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23724), EPIC_ARMOR_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23719), EPIC_MOVEMENT_SPEED_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23721), EPIC_ATTACK_DAMAGE_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23718), EPIC_KNOCKBACK_RESISTANCE_MODIFIER);
                break;
            }
            case LEGENDARY: {
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23716), LEGENDARY_HEALTH_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23724), LEGENDARY_ARMOR_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23719), LEGENDARY_MOVEMENT_SPEED_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23721), LEGENDARY_ATTACK_DAMAGE_MODIFIER);
                MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_23718), LEGENDARY_KNOCKBACK_RESISTANCE_MODIFIER);
                break;
            }
        }
        MobChampionBuilder.addChampionAttribute(entity.method_5996(class_5134.field_49079), SAFE_FALL_DISTANCE_MODIFIER);
        MobChampionBuilder.updateMaxHealth(entity);
        MobChampionBuilder.applyChampionEffect(entity, rank);
        MobChampionBuilder.applyGlowingEffectIfNeeded(entity, rank);
        MobChampionBuilder.applyInfestedEffectIfNeeded(entity, rank);
        MobChampionBuilder.applyWeavingEffectIfNeeded(entity, rank);
        MobChampionBuilder.applyWindChargedEffectIfNeeded(entity, rank);
        MobChampionBuilder.applyFireResistanceEffectIfNeeded(entity, rank);
        MobChampionBuilder.equipChampionWeaponIfNeeded(entity, rank);
        MobChampionBuilder.equipChampionGearIfNeeded(entity, rank);
    }

    private static void equipChampionWeaponIfNeeded(class_1309 entity, MobChampion.Rank rank) {
        class_1304 weaponSlot = class_1304.field_6173;
        if (entity.method_56991(weaponSlot)) {
            class_1799 standardWeapon = ConfigHandler.Common.getWeaponForRank(rank);
            Pair<Boolean, class_1799> maybeWeapon = MobChampionBuilder.maybeUpgradeWeaponToLootTableWeapon(entity, standardWeapon, rank);
            if (((Boolean)maybeWeapon.getLeft()).booleanValue()) {
                if (maybeWeapon.getRight() != null && ((class_1799)maybeWeapon.getRight()).method_7909() instanceof class_1819) {
                    weaponSlot = class_1304.field_6171;
                }
                entity.method_5673(weaponSlot, (class_1799)maybeWeapon.getRight());
            } else if (standardWeapon != null) {
                if (standardWeapon.method_7909() instanceof class_1819) {
                    weaponSlot = class_1304.field_6171;
                }
                entity.method_5673(weaponSlot, standardWeapon);
            }
            MobChampionBuilder.finalizeChampionWeapon(entity, rank, (Boolean)maybeWeapon.getLeft(), weaponSlot);
        }
    }

    private static Pair<Boolean, class_1799> maybeUpgradeWeaponToLootTableWeapon(class_1309 entity, class_1799 weapon, MobChampion.Rank rank) {
        double chanceToUpgrade = ConfigHandler.Common.getLootableWeaponSpawnChanceForRank(rank);
        class_5321<class_52> equipmentLootTable = MobChampionsLootTables.getWeaponLootTable(rank);
        class_1937 level = entity.method_37908();
        if (level instanceof class_3218) {
            ObjectArrayList list;
            class_3218 serverLevel = (class_3218)level;
            class_52 lootTable = serverLevel.method_8503().method_58576().method_58295(equipmentLootTable);
            class_8567 params = MobChampionBuilder.createEquipmentParams(entity, serverLevel);
            if (lootTable != class_52.field_948 && (double)MobChampions.RANDOM.nextFloat() < chanceToUpgrade && !(list = lootTable.method_51879(params, 0L)).isEmpty()) {
                return Pair.of((Object)true, (Object)((class_1799)list.getFirst()));
            }
        }
        return Pair.of((Object)false, (Object)weapon);
    }

    private static class_8567 createEquipmentParams(class_1309 livingEntity, class_3218 level) {
        return new class_8567.class_8568(level).method_51874(class_181.field_24424, (Object)livingEntity.method_19538()).method_51874(class_181.field_1226, (Object)livingEntity).method_51875(class_173.field_50217);
    }

    private static void finalizeChampionWeapon(class_1309 entity, MobChampion.Rank rank, boolean hasLootTableWeapon, class_1304 weaponSlot) {
        if (!entity.method_6118(weaponSlot).method_7960() && entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            class_1937 level = entity.method_37908();
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                class_1266 difficultyInstance = serverLevel.method_8404(entity.method_24515());
                MobChampionBuilder.enchantSpawnedWeapon((class_1309)mob, rank, (class_5425)serverLevel, serverLevel.method_8409(), difficultyInstance);
            }
            if (hasLootTableWeapon) {
                mob.method_5946(weaponSlot, ConfigHandler.Common.getLootDropChance(rank));
            } else {
                mob.method_5946(weaponSlot, (float)ConfigHandler.Common.getStandardWeaponDropChance());
            }
        }
    }

    private static void equipChampionGearIfNeeded(class_1309 entity, MobChampion.Rank rank) {
        for (class_1304 slot : MobChampionBuilder.getArmorSlots()) {
            class_1799 armor;
            if (!entity.method_56991(slot) || (armor = ConfigHandler.Common.getArmorForRankAndSlot(rank, slot)) == null) continue;
            entity.method_5673(slot, armor);
        }
        Pair<class_1304, class_1799> upgrade = MobChampionBuilder.maybeUpgradeArmorToLootTableArmor(entity, rank);
        if (upgrade.getLeft() != null) {
            entity.method_5673((class_1304)upgrade.getLeft(), (class_1799)upgrade.getRight());
        }
        MobChampionBuilder.finalizeChampionArmor(entity, rank, (class_1304)upgrade.getLeft());
    }

    private static Pair<class_1304, class_1799> maybeUpgradeArmorToLootTableArmor(class_1309 livingEntity, MobChampion.Rank rank) {
        double chanceToUpgrade = ConfigHandler.Common.getLootableArmorSpawnChanceForRank(rank);
        class_5321<class_52> equipmentLootTable = MobChampionsLootTables.getWearableLootTable(rank);
        class_1937 level = livingEntity.method_37908();
        if (level instanceof class_3218) {
            class_1799 armorItem;
            class_5151 equipable;
            ObjectArrayList list;
            class_3218 serverLevel = (class_3218)level;
            class_52 lootTable = serverLevel.method_8503().method_58576().method_58295(equipmentLootTable);
            class_8567 params = MobChampionBuilder.createEquipmentParams(livingEntity, serverLevel);
            if (lootTable != class_52.field_948 && (double)MobChampions.RANDOM.nextFloat() < chanceToUpgrade && !(list = lootTable.method_51879(params, 0L)).isEmpty() && (equipable = class_5151.method_48957((class_1799)(armorItem = (class_1799)list.getFirst()))) != null) {
                return Pair.of((Object)equipable.method_7685(), (Object)armorItem);
            }
        }
        return Pair.of(null, null);
    }

    private static void finalizeChampionArmor(class_1309 entity, MobChampion.Rank rank, class_1304 lootTableArmorSlot) {
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            class_1937 level = entity.method_37908();
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                class_1266 difficultyInstance = serverLevel.method_8404(entity.method_24515());
                for (class_1304 slot : MobChampionBuilder.getArmorSlots()) {
                    if (entity.method_6118(slot).method_7960()) continue;
                    MobChampionBuilder.enchantSpawnedArmor((class_1309)mob, rank, (class_5425)serverLevel, serverLevel.method_8409(), slot, difficultyInstance);
                    if (slot == lootTableArmorSlot) {
                        mob.method_5946(slot, ConfigHandler.Common.getLootDropChance(rank));
                        continue;
                    }
                    mob.method_5946(slot, (float)ConfigHandler.Common.getStandardArmorDropChance());
                }
            }
        }
    }

    private static void enchantSpawnedWeapon(class_1309 entity, MobChampion.Rank rank, class_5425 level, class_5819 random, class_1266 difficulty) {
        MobChampionBuilder.enchantSpawnedEquipment(entity, level, class_1304.field_6173, random, switch (rank) {
            case MobChampion.Rank.RARE -> 0.3f;
            case MobChampion.Rank.EPIC -> 0.6f;
            case MobChampion.Rank.LEGENDARY -> 0.8f;
            default -> 0.15f;
        }, difficulty, rank);
    }

    private static void enchantSpawnedArmor(class_1309 entity, MobChampion.Rank rank, class_5425 level, class_5819 random, class_1304 slot, class_1266 difficulty) {
        MobChampionBuilder.enchantSpawnedEquipment(entity, level, slot, random, switch (rank) {
            case MobChampion.Rank.RARE -> 0.5f;
            case MobChampion.Rank.EPIC -> 0.75f;
            case MobChampion.Rank.LEGENDARY -> 1.0f;
            default -> 0.25f;
        }, difficulty, rank);
    }

    private static void enchantSpawnedEquipment(class_1309 entity, class_5425 level, class_1304 slot, class_5819 random, float enchantChance, class_1266 difficulty, MobChampion.Rank rank) {
        class_1799 itemstack = entity.method_6118(slot);
        if (!itemstack.method_7960() && random.method_43057() < enchantChance * difficulty.method_5458()) {
            class_1890.method_60137((class_1799)itemstack, (class_5455)level.method_30349(), (class_5321)class_9747.field_51771, (class_1266)difficulty, (class_5819)random);
            entity.method_5673(slot, itemstack);
        }
    }

    private static void applyChampionEffect(class_1309 entity, MobChampion.Rank rank) {
        class_6880<class_1291> mobEffectHolder = MobChampionsEffects.getChampionEffectHolderByRank(rank);
        if (mobEffectHolder != null) {
            entity.method_26082(new class_1293(mobEffectHolder, -1), (class_1297)entity);
        }
    }

    private static void applyGlowingEffectIfNeeded(class_1309 entity, MobChampion.Rank rank) {
        int glowingEffectMinimumRankOrdinal = ConfigHandler.Common.getGlowingEffectMinimumRank().ordinal();
        if (rank.ordinal() >= glowingEffectMinimumRankOrdinal) {
            int glowingEffectDuration = ConfigHandler.Common.getGlowingEffectDuration();
            if (glowingEffectDuration < 0) {
                glowingEffectDuration = Integer.MAX_VALUE;
            }
            entity.method_6092(new class_1293(class_1294.field_5912, glowingEffectDuration, 1, false, false));
        }
    }

    private static void applyInfestedEffectIfNeeded(class_1309 entity, MobChampion.Rank rank) {
        int infestedEffectMinimumRankOrdinal = ConfigHandler.Common.getInfestedEffectMinimumRank().ordinal();
        if (rank.ordinal() >= infestedEffectMinimumRankOrdinal) {
            double infestedEffectChance = ConfigHandler.Common.getInfestedEffectChance();
            double bonusMultiplier = 1.0 + ConfigHandler.Common.getLegendaryEffectBonusMultiplier();
            if (rank == MobChampion.Rank.LEGENDARY) {
                infestedEffectChance *= bonusMultiplier;
            }
            if ((double)MobChampions.RANDOM.nextFloat() <= infestedEffectChance) {
                class_1293 infestedEffect = new class_1293(class_1294.field_50121, -1);
                entity.method_6092(infestedEffect);
            }
        }
    }

    private static void applyWeavingEffectIfNeeded(class_1309 entity, MobChampion.Rank rank) {
        int weavingEffectMinimumRankOrdinal = ConfigHandler.Common.getWeavingEffectMinimumRank().ordinal();
        if (rank.ordinal() >= weavingEffectMinimumRankOrdinal) {
            double weavingEffectChance = ConfigHandler.Common.getWeavingEffectChance();
            double bonusMultiplier = 1.0 + ConfigHandler.Common.getLegendaryEffectBonusMultiplier();
            if (rank == MobChampion.Rank.LEGENDARY) {
                weavingEffectChance *= bonusMultiplier;
            }
            if ((double)MobChampions.RANDOM.nextFloat() <= weavingEffectChance) {
                class_1293 weavingEffect = new class_1293(class_1294.field_50119, -1);
                entity.method_6092(weavingEffect);
            }
        }
    }

    private static void applyWindChargedEffectIfNeeded(class_1309 entity, MobChampion.Rank rank) {
        int windChargedEffectMinimumRankOrdinal = ConfigHandler.Common.getWindChargedEffectMinimumRank().ordinal();
        if (rank.ordinal() >= windChargedEffectMinimumRankOrdinal) {
            double windChargedEffectChance = ConfigHandler.Common.getWindChargedEffectChance();
            double bonusMultiplier = 1.0 + ConfigHandler.Common.getLegendaryEffectBonusMultiplier();
            if (rank == MobChampion.Rank.LEGENDARY) {
                windChargedEffectChance *= bonusMultiplier;
            }
            if ((double)MobChampions.RANDOM.nextFloat() <= windChargedEffectChance) {
                class_1293 windChargedEffect = new class_1293(class_1294.field_50118, -1);
                entity.method_6092(windChargedEffect);
            }
        }
    }

    private static void applyFireResistanceEffectIfNeeded(class_1309 entity, MobChampion.Rank rank) {
        int fireResistanceEffectMinimumRankOrdinal = ConfigHandler.Common.getFireResistanceEffectMinimumRank().ordinal();
        if (rank.ordinal() >= fireResistanceEffectMinimumRankOrdinal) {
            double fireResistanceEffectChance = ConfigHandler.Common.getFireResistanceEffectChance();
            if ((double)MobChampions.RANDOM.nextFloat() <= fireResistanceEffectChance) {
                class_1293 fireResistanceEffect = new class_1293(class_1294.field_5918, -1, 1, false, false);
                entity.method_6092(fireResistanceEffect);
            }
        }
    }

    public static void updateMaxHealth(class_1309 entity) {
        class_1324 maxHealthAttribute = entity.method_5996(class_5134.field_23716);
        if (maxHealthAttribute != null) {
            entity.method_6033((float)maxHealthAttribute.method_6194());
        }
    }

    public static void addChampionAttribute(class_1324 attributeInstance, class_1322 modifier) {
        if (attributeInstance != null && !attributeInstance.method_6196(modifier.comp_2447())) {
            attributeInstance.method_26837(modifier);
        }
    }

    public static List<class_1304> getArmorSlots() {
        return List.of(class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166);
    }
}

