/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.network;

import mobchampions.MobChampions;
import mobchampions.network.MobChampion;
import mobchampions.platform.Services;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class MobChampionData {
    public int entityId;
    public MobChampion.Rank rank;
    public static final ResourceLocation ID = MobChampions.prefix("mob_champion_data");

    public MobChampionData(int entityId, MobChampion.Rank rank) {
        this.entityId = entityId;
        this.rank = rank;
    }

    public MobChampionData(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.rank = MobChampion.Rank.values()[buf.readInt()];
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.rank.ordinal());
    }

    public static void process(LivingEntity entity, CompoundTag tag) {
        Services.PLATFORM.getMobChampionData(entity).ifPresent(data -> data.read(tag));
    }

    public String toString() {
        return "entityid: " + this.entityId + " rank: " + String.valueOf((Object)this.rank);
    }
}

