/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.network;

import mobchampions.LocalPlayerHelper;
import mobchampions.network.LaunchFireworksPacket;
import mobchampions.network.MobChampionData;
import mobchampions.network.SyncMobChampionData;
import mobchampions.platform.Services;
import mobchampions.util.FireworksHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MobChampionsNeoForgeNetwork {
    public static final MobChampionsNeoForgeNetwork INSTANCE = new MobChampionsNeoForgeNetwork();

    public static MobChampionsNeoForgeNetwork getInstance() {
        return INSTANCE;
    }

    public void handleFireworksPacket(LaunchFireworksPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null) {
                FireworksHelper.launchFireworks(level, msg.location());
            }
        });
    }

    public void processMobChampionData(SyncMobChampionData payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity;
            ClientLevel level = Minecraft.getInstance().level;
            MobChampionData data = payload.getMobChampionData();
            MobChampionData.process((LivingEntity)LocalPlayerHelper.getLocalPlayer(), payload.getData());
            if (level != null && (entity = level.getEntity(data.entityId)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                Services.PLATFORM.getMobChampionData(livingEntity).ifPresent(mobChampionData -> {
                    mobChampionData.setEntityId(data.entityId);
                    mobChampionData.setRank(data.rank);
                });
            }
        });
    }
}

