/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.event;

import java.util.List;
import mobchampions.MobChampions;
import mobchampions.common.Translations;
import mobchampions.config.ConfigHandler;
import mobchampions.network.MobChampion;
import mobchampions.platform.Services;
import mobchampions.util.MobChampionBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.AABB;

public class MobChampionEventHandler {
    public static void addRandomChampion(LivingEntity livingEntity) {
        String entityTypeString = MobChampionEventHandler.getEntityTypeString(livingEntity);
        if (ConfigHandler.Common.getChampionWhitelist().contains(entityTypeString)) {
            if (ConfigHandler.Common.isBabyChampionsDisabled() && livingEntity.isBaby()) {
                return;
            }
            Services.PLATFORM.getMobChampionData(livingEntity).ifPresent(data -> {
                if (data.getEntityId() == -1) {
                    int randomWeight = MobChampions.RANDOM.nextInt(ConfigHandler.Common.getTotalWeight());
                    data.setEntityId(livingEntity.getId());
                    MobChampion.Rank newRank = ConfigHandler.Common.getChampionByWeight(randomWeight);
                    data.setRank(newRank);
                    MobChampionBuilder.build(livingEntity, newRank);
                    if (ConfigHandler.Common.enableSpawnMessage() && newRank.ordinal() >= ConfigHandler.Common.getSpawnMessageMinimumRank()) {
                        AABB aabb = new AABB(livingEntity.blockPosition()).inflate((double)ConfigHandler.Common.getSpawnMessageRange());
                        List list = livingEntity.level().getEntitiesOfClass(ServerPlayer.class, aabb, player -> true);
                        for (ServerPlayer serverPlayer : list) {
                            serverPlayer.displayClientMessage((Component)Component.translatable((String)(Translations.ANNOUNCEMENT_KEY + "spawn"), (Object[])new Object[]{Component.translatable((String)Translations.getTitleByRank(newRank)).withColor(ConfigHandler.Common.getChampionColor(newRank))}), true);
                        }
                    }
                }
                Services.PLATFORM.syncMobChampionData(null, livingEntity);
            });
        }
    }

    public static void updateChampionArrowDamage(LivingEntity livingEntity, AbstractArrow abstractArrow) {
        String entityTypeString = MobChampionEventHandler.getEntityTypeString(livingEntity);
        if (ConfigHandler.Common.getChampionWhitelist().contains(entityTypeString)) {
            Services.PLATFORM.getMobChampionData(livingEntity).ifPresent(data -> {
                if (data.getEntityId() != -1 && data.getRank() != MobChampion.Rank.COMMON) {
                    double damage = abstractArrow.getBaseDamage();
                    double damageModifier = ConfigHandler.Common.getProjectileDamageModifier(data.getRank());
                    double newDamage = damage + damage * damageModifier;
                    abstractArrow.setBaseDamage(newDamage);
                }
            });
        }
    }

    public static void addNormalMob(LivingEntity livingEntity) {
        String entityTypeString = MobChampionEventHandler.getEntityTypeString(livingEntity);
        if (ConfigHandler.Common.getChampionWhitelist().contains(entityTypeString)) {
            Services.PLATFORM.getMobChampionData(livingEntity).ifPresent(data -> {
                data.setEntityId(livingEntity.getId());
                data.setRank(MobChampion.Rank.COMMON);
                Services.PLATFORM.syncMobChampionData(null, livingEntity);
            });
        }
    }

    private static String getEntityTypeString(LivingEntity livingEntity) {
        EntityType entityType = livingEntity.getType();
        return BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType).toString();
    }
}

