/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.loot;

import com.google.common.collect.Sets;
import java.util.Set;
import mobchampions.MobChampions;
import mobchampions.network.MobChampion;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;

public class MobChampionsLootTables {
    private static final Set<ResourceKey<LootTable>> ALL = Sets.newHashSet();
    public static final ResourceKey<LootTable> UNCOMMON_WEAPON_LOOT = MobChampionsLootTables.register("uncommon_weapon_loot");
    public static final ResourceKey<LootTable> UNCOMMON_WEARABLE_LOOT = MobChampionsLootTables.register("uncommon_wearable_loot");
    public static final ResourceKey<LootTable> UNCOMMON_GENERIC_LOOT = MobChampionsLootTables.register("uncommon_generic_loot");
    public static final ResourceKey<LootTable> RARE_WEAPON_LOOT = MobChampionsLootTables.register("rare_weapon_loot");
    public static final ResourceKey<LootTable> RARE_WEARABLE_LOOT = MobChampionsLootTables.register("rare_wearable_loot");
    public static final ResourceKey<LootTable> RARE_GENERIC_LOOT = MobChampionsLootTables.register("rare_generic_loot");
    public static final ResourceKey<LootTable> EPIC_WEAPON_LOOT = MobChampionsLootTables.register("epic_weapon_loot");
    public static final ResourceKey<LootTable> EPIC_WEARABLE_LOOT = MobChampionsLootTables.register("epic_wearable_loot");
    public static final ResourceKey<LootTable> EPIC_GENERIC_LOOT = MobChampionsLootTables.register("epic_generic_loot");
    public static final ResourceKey<LootTable> LEGENDARY_WEAPON_LOOT = MobChampionsLootTables.register("legendary_weapon_loot");
    public static final ResourceKey<LootTable> LEGENDARY_WEARABLE_LOOT = MobChampionsLootTables.register("legendary_wearable_loot");
    public static final ResourceKey<LootTable> LEGENDARY_GENERIC_LOOT = MobChampionsLootTables.register("legendary_generic_loot");

    public static void init() {
    }

    private static ResourceKey<LootTable> register(String id) {
        return MobChampionsLootTables.register((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)MobChampions.prefix(id)));
    }

    private static ResourceKey<LootTable> register(ResourceKey<LootTable> key) {
        if (ALL.add(key)) {
            return key;
        }
        throw new IllegalStateException("LootTable " + String.valueOf(key.location()) + " is already registered");
    }

    public static ResourceKey<LootTable> getWeaponLootTable(MobChampion.Rank rank) {
        return switch (rank) {
            case MobChampion.Rank.RARE -> RARE_WEAPON_LOOT;
            case MobChampion.Rank.EPIC -> EPIC_WEAPON_LOOT;
            case MobChampion.Rank.LEGENDARY -> LEGENDARY_WEAPON_LOOT;
            default -> UNCOMMON_WEAPON_LOOT;
        };
    }

    public static ResourceKey<LootTable> getWearableLootTable(MobChampion.Rank rank) {
        return switch (rank) {
            case MobChampion.Rank.RARE -> RARE_WEARABLE_LOOT;
            case MobChampion.Rank.EPIC -> EPIC_WEARABLE_LOOT;
            case MobChampion.Rank.LEGENDARY -> LEGENDARY_WEARABLE_LOOT;
            default -> UNCOMMON_WEARABLE_LOOT;
        };
    }

    public static ResourceKey<LootTable> getGenericLootTable(MobChampion.Rank rank) {
        return switch (rank) {
            case MobChampion.Rank.RARE -> RARE_GENERIC_LOOT;
            case MobChampion.Rank.EPIC -> EPIC_GENERIC_LOOT;
            case MobChampion.Rank.LEGENDARY -> LEGENDARY_GENERIC_LOOT;
            default -> UNCOMMON_GENERIC_LOOT;
        };
    }
}

