/*
 * Decompiled with CFR 0.152.
 */
package mobchampions.mixin;

import mobchampions.common.effect.MobChampionsEffects;
import mobchampions.config.ConfigHandler;
import mobchampions.loot.MobChampionsLootTables;
import mobchampions.network.MobChampion;
import mobchampions.platform.Services;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    @Nullable
    protected Player lastHurtByPlayer;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"dropFromLootTable"}, at={@At(value="TAIL")})
    public void mc$dropFromLootTable(DamageSource damageSource, boolean hitByPlayer, CallbackInfo ci) {
        if (!hitByPlayer || this.lastHurtByPlayer == null) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)this;
        Services.PLATFORM.getMobChampionData(livingEntity).ifPresent(data -> {
            if (data.getEntityId() != -1 && data.getRank() != MobChampion.Rank.COMMON) {
                ServerLevel level = (ServerLevel)livingEntity.level();
                LootParams params = this.mobChampions$createEquipmentParams(livingEntity, level, damageSource, hitByPlayer);
                float lootChance = ConfigHandler.Common.getLootDropChance(data.getRank());
                if (lootChance > 0.0f && level.getRandom().nextFloat() < lootChance) {
                    ResourceKey<LootTable> weaponLootTableKey = MobChampionsLootTables.getWeaponLootTable(data.getRank());
                    ResourceKey<LootTable> wearableLootTableKey = MobChampionsLootTables.getWearableLootTable(data.getRank());
                    ResourceKey<LootTable> genericLootTableKey = MobChampionsLootTables.getGenericLootTable(data.getRank());
                    LootTable weaponLootTable = level.getServer().reloadableRegistries().getLootTable(weaponLootTableKey);
                    LootTable wearableLootTable = level.getServer().reloadableRegistries().getLootTable(wearableLootTableKey);
                    LootTable genericLootTable = level.getServer().reloadableRegistries().getLootTable(genericLootTableKey);
                    weaponLootTable.getRandomItems(params).forEach(arg_0 -> ((LivingEntity)livingEntity).spawnAtLocation(arg_0));
                    wearableLootTable.getRandomItems(params).forEach(arg_0 -> ((LivingEntity)livingEntity).spawnAtLocation(arg_0));
                    genericLootTable.getRandomItems(params).forEach(arg_0 -> ((LivingEntity)livingEntity).spawnAtLocation(arg_0));
                }
                if (ConfigHandler.Common.fireworksOnDeath() && data.getRank().ordinal() >= ConfigHandler.Common.getFireworksMinimumRank().ordinal()) {
                    Services.PLATFORM.sendLaunchFireworksPacket(livingEntity);
                }
            }
        });
    }

    @Inject(method={"canBeAffected"}, at={@At(value="RETURN")}, cancellable=true)
    private void mobchampions$modifyCanBeAffected(MobEffectInstance effectInstance, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (MobChampionsEffects.ALL_CHAMPION_EFFECT_HOLDERS.contains(effectInstance.getEffect())) {
            Services.PLATFORM.getMobChampionData(livingEntity).ifPresent(data -> {
                if (data.getEntityId() != -1 && data.getRank() != MobChampion.Rank.COMMON) {
                    cir.setReturnValue((Object)true);
                } else {
                    cir.setReturnValue((Object)false);
                }
            });
        }
    }

    @Unique
    private LootParams mobChampions$createEquipmentParams(LivingEntity livingEntity, ServerLevel level, DamageSource damageSource, boolean hitByPlayer) {
        LootParams.Builder lootparams$builder = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)livingEntity).withParameter(LootContextParams.ORIGIN, (Object)livingEntity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity());
        if (hitByPlayer && this.lastHurtByPlayer != null) {
            lootparams$builder = lootparams$builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)this.lastHurtByPlayer).withLuck(this.lastHurtByPlayer.getLuck());
        }
        return lootparams$builder.create(LootContextParamSets.ENTITY);
    }
}

