/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.minersminerals;

import com.google.common.collect.BiMap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.tags.ModWeaponTraitTags;
import com.oblivioussp.spartanweaponry.util.WeaponArchetype;
import com.oblivioussp.spartanweaponry.util.WeaponFactory;
import com.oblivioussp.spartanweaponry.util.WeaponType;
import com.zephaniahnoah.ezmodlib.EzModLib;
import com.zephaniahnoah.ezmodlib.TagInjector;
import com.zephaniahnoah.ezmodlib.VirtualDatapack;
import com.zephaniahnoah.ezmodlib.VirtualResourcepack;
import com.zephaniahnoah.ezmodlib.util.Supplier;
import com.zephaniahnoah.ezmodlib.util.Util;
import com.zephaniahnoah.minersminerals.Main;
import com.zephaniahnoah.minersminerals.Mineral;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.data.DataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.rosemarythyme.simplymore.config.WeaponAttributesConfig;
import net.rosemarythyme.simplymore.config.WrapperConfig;
import net.rosemarythyme.simplymore.item.normal.GrandSwordItem;
import net.rosemarythyme.simplymore.item.normal.LanceItem;
import net.rosemarythyme.simplymore.item.normal.SimplyMoreSwordItem;
import net.rosemarythyme.simplymore.registry.ModItemsRegistry;
import net.sweenus.simplyswords.item.SimplySwordsSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;

@Mod.EventBusSubscriber(modid="minersminerals", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Generator {
    private static final Gson gson = new Gson();
    private static final String[] fileTypesHand = new String[]{"_axe", "_pickaxe", "_shovel", "_sword", "_spear", "_greatsword"};
    private static final String[] fileTypes = new String[]{"_boots", "_chestplate", "_helmet", "_leggings", "_axe", "_pickaxe", "_shovel", "_sword", "_spear", "_greatsword"};
    private static JsonPrimitive gold_ingot = new JsonPrimitive("minecraft:gold_ingot");
    private static JsonPrimitive iron_nugget = new JsonPrimitive("minecraft:iron_nugget");
    private static JsonPrimitive golden_sword = new JsonPrimitive("minecraft:golden_sword");

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        if (event.includeClient()) {
            Generator.registerClientProviders(event.getGenerator(), event);
        }
    }

    private static void registerClientProviders(DataGenerator generator, GatherDataEvent event) {
        ExistingFileHelper helper = event.getExistingFileHelper();
    }

    /*
     * WARNING - void declaration
     */
    public static void generateData() {
        try {
            Object[] weapons;
            ResourceKey creativeTab;
            Object lang = "{\n";
            BiMap items = (BiMap)ObfuscationReflectionHelper.getPrivateValue(ForgeRegistry.class, (Object)((ForgeRegistry)ForgeRegistries.ITEMS), (String)"names");
            if (ModList.get().isLoaded("simplyswords")) {
                EzModLib.init((String)"simplyswords");
                creativeTab = Main.TABS.register("minersminerals.simplyswords", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.minersminerals.simplyswords")).m_257737_(() -> new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("simplyswords:adamantium_scythe")))).m_257652_()).getKey();
                lang = (String)lang + "\"itemGroup.minersminerals.simplyswords\": \"Simply Swords: Miner's Minerals\",\n";
                Object[] objectArray = weapons = new String[]{"chakram", "claymore", "cutlass", "glaive", "greataxe", "greathammer", "halberd", "katana", "longsword", "rapier", "sai", "scythe", "spear", "twinblade", "warglaive"};
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object weapon = objectArray[i];
                    float positive_modifier = ((Float)ObfuscationReflectionHelper.getPrivateValue(ItemsRegistry.class, null, (String)((String)weapon + "_positive_modifier"))).floatValue();
                    float negative_modifier = ((Float)ObfuscationReflectionHelper.getPrivateValue(ItemsRegistry.class, null, (String)((String)weapon + "_negative_modifier"))).floatValue();
                    float attackspeed = ((Float)ObfuscationReflectionHelper.getPrivateValue(ItemsRegistry.class, null, (String)((String)weapon + "_attackspeed"))).floatValue();
                    for (Mineral m : Mineral.values()) {
                        int mineralColor = m.getColor();
                        if (mineralColor == -1) continue;
                        String combinedName = m.m_6082_() + "_" + (String)weapon;
                        lang = (String)lang + "\"item.simplyswords." + combinedName + "\": \"" + Main.toFirstCharUpperAll(combinedName.replace('_', ' ')) + "\",\n";
                        String string = Util.readFileFromOtherMod((String)"simplyswords", (String)("/data/simplyswords/weapon_attributes/iron_" + (String)weapon + ".json"));
                        if (string != null) {
                            VirtualDatapack.addFile((String)"weapon_attributes", (String)"simplyswords", (String)("weapon_attributes/" + combinedName + ".json"), (String)string);
                        }
                        Supplier<Item> sword = HiddenSimplySword.makeSword(m, (int)(m.m_6631_() + positive_modifier - negative_modifier), attackspeed, new String[]{"minersminerals:" + m.m_6082_() + (m.gem ? "" : "_ingot")});
                        Main.tab((ResourceKey<CreativeModeTab>)creativeTab, sword);
                        EzModLib.register((String)"simplyswords", (String)combinedName, sword, (String)"DONT_INJECT", (boolean)true);
                        if (FMLEnvironment.dist == Dist.CLIENT) {
                            String model = Util.readFileFromOtherMod((String)"simplyswords", (String)("/assets/simplyswords/models/item/iron_" + (String)weapon + ".json"));
                            model = model.replaceAll("iron", m.m_6082_());
                            VirtualResourcepack.addFile((String)"simplyswords", (String)("models/item/" + combinedName + ".json"), (String)model);
                            Generator.genTexture(mineralColor, (String)weapon, m, "simplyswords", 1.0f, 1.5f, 1.2f);
                        }
                        String recipe = Util.readFileFromOtherMod((String)"simplyswords", (String)("/data/simplyswords/recipes/gold_" + (String)weapon + ".json"));
                        Generator.createRecipe(recipe, "simplyswords", m, combinedName);
                    }
                }
            }
            if (ModList.get().isLoaded("simplymore")) {
                EzModLib.init((String)"simplymore");
                creativeTab = Main.TABS.register("minersminerals.simplymore", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.minersminerals.simplymore")).m_257737_(() -> new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("simplymore:adamantium_deer_horns")))).m_257652_()).getKey();
                lang = (String)lang + "\"itemGroup.minersminerals.simplymore\": \"Simply More: Miner's Minerals\",\n";
                weapons = new String[]{"backhand_blade", "dagger", "deer_horns", "grandsword", "great_katana", "great_spear", "khopesh", "lance", "pernach", "quarterstaff"};
                WrapperConfig config = (WrapperConfig)ObfuscationReflectionHelper.getPrivateValue(ModItemsRegistry.class, null, (String)"config");
                for (Object weapon : weapons) {
                    String preprefix = Main.toFirstCharUpperAll(((String)weapon).replaceAll("_", " ")).replaceAll(" ", "");
                    String prefix = ("" + preprefix.charAt(0)).toLowerCase() + preprefix.substring(1);
                    int damageModifier = (Integer)ObfuscationReflectionHelper.getPrivateValue(WeaponAttributesConfig.class, (Object)config.weaponAttributes, (String)(prefix + "DamageModifier"));
                    Method meth = ObfuscationReflectionHelper.findMethod(WeaponAttributesConfig.class, (String)("get" + preprefix + "SwingSpeed"), (Class[])new Class[0]);
                    float swingSpeed = (float)((Double)meth.invoke((Object)config.weaponAttributes, new Object[0])).doubleValue();
                    for (Mineral mineral : Mineral.values()) {
                        int mineralColor = mineral.getColor();
                        if (mineralColor == -1) continue;
                        String combinedName = mineral.m_6082_() + "_" + (String)weapon;
                        lang = (String)lang + "\"item.simplymore." + combinedName + "\": \"" + Main.toFirstCharUpperAll(combinedName.replace('_', ' ')) + "\",\n";
                        String weaponAttribute = Util.readFileFromOtherMod((String)"simplymore", (String)("/data/simplymore/weapon_attributes/iron_" + (String)weapon + ".json"));
                        if (weaponAttribute != null) {
                            VirtualDatapack.addFile((String)"weapon_attributes", (String)"simplymore", (String)("weapon_attributes/" + combinedName + ".json"), (String)weaponAttribute);
                        }
                        Supplier<Item> moreItem = HiddenSimplyMore.makeSword((String)weapon, mineral, damageModifier + 3, swingSpeed, new String[]{"minersminerals:" + mineral.m_6082_() + (mineral.gem ? "" : "_ingot")});
                        Main.tab((ResourceKey<CreativeModeTab>)creativeTab, moreItem);
                        EzModLib.register((String)"simplymore", (String)combinedName, moreItem, (String)"DONT_INJECT", (boolean)true);
                        if (FMLEnvironment.dist == Dist.CLIENT) {
                            String model = Util.readFileFromOtherMod((String)"simplymore", (String)("/assets/simplymore/models/item/iron_" + (String)weapon + ".json"));
                            model = model.replaceAll((String)weapon + "/iron", combinedName);
                            VirtualResourcepack.addFile((String)"simplymore", (String)("models/item/" + combinedName + ".json"), (String)model);
                            Generator.genTexture(mineralColor, (String)weapon, mineral, "simplymore", 1.0f, 1.5f, 1.2f);
                        }
                        String recipe = Util.readFileFromOtherMod((String)"simplymore", (String)("/data/simplymore/recipes/" + (String)weapon + "/gold_" + (String)weapon + ".json"));
                        Generator.createRecipe(recipe, "simplymore", mineral, combinedName);
                    }
                }
            }
            if (ModList.get().isLoaded("spartanweaponry")) {
                EzModLib.init((String)"spartanweaponry");
                lang = (String)lang + "\"itemGroup.minersminerals.spartanweaponry\": \"Spartan Weaponry: Miner's Minerals\",\n";
                creativeTab = Main.TABS.register("minersminerals.spartanweaponry", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.minersminerals.spartanweaponry")).m_257737_(() -> new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("spartanweaponry:adamantium_greatsword")))).m_257652_()).getKey();
                for (Field field : WeaponFactory.class.getDeclaredFields()) {
                    String fieldName = field.getName();
                    String weaponName = fieldName.toLowerCase();
                    ArrayList<String> models = new ArrayList<String>(Arrays.asList(weaponName));
                    if (fieldName.equals("HEAVY_CROSSBOW") || fieldName.equals("LONGBOW")) {
                        for (int i = 0; i < 3; ++i) {
                            models.add(weaponName + "_pulling_" + i);
                        }
                        if (fieldName.equals("HEAVY_CROSSBOW")) {
                            models.add(weaponName + "_loaded");
                            models.add(weaponName + "_firing");
                        }
                    } else {
                        models.add(weaponName + "_throwing");
                        if (((WeaponArchetype)WeaponArchetype.class.getDeclaredField(fieldName).get(null)).getType() == WeaponType.MELEE) {
                            models.add(weaponName + "_blocking");
                        }
                    }
                    String oilableWeapons = Util.readFileFromOtherMod((String)"spartanweaponry", (String)"/data/spartanweaponry/tags/items/oilable_weapons.json");
                    JsonArray values = JsonParser.parseString((String)oilableWeapons).getAsJsonObject().getAsJsonArray("values");
                    boolean oilable = values.contains((JsonElement)new JsonPrimitive("#spartanweaponry:" + weaponName + "s"));
                    WeaponFactory.WeaponFunction weaponFunction = (WeaponFactory.WeaponFunction)field.get(null);
                    for (Mineral mineral : Mineral.values()) {
                        int mineralColor;
                        String materialName = mineral.m_6082_();
                        String path = "tags/spartanweaponry/weapon_traits";
                        String file = path + "/materials/" + materialName + ".json";
                        String fileContent = Util.readFileFromOtherMod((String)"spartanweaponry", (String)("data/spartanweaponry/" + file));
                        TagKey tag = ModWeaponTraitTags.create((String)("materials/" + materialName));
                        if (fileContent != null || (mineralColor = mineral.getColor()) == -1) continue;
                        String combinedName = materialName + "_" + weaponName;
                        lang = (String)lang + "\"item.spartanweaponry." + combinedName + "\": \"" + Main.toFirstCharUpperAll(combinedName.replace('_', ' ')) + "\",\n";
                        VirtualDatapack.addFile((String)path, (String)"spartanweaponry", (String)file, (String)"{\"values\":[]}");
                        Supplier weaponMaterial = Supplier.S(() -> new WeaponMaterial(materialName, "minersminerals", (Tier)mineral, ItemTags.create((ResourceLocation)new ResourceLocation(m.tag)), tag));
                        Supplier item = Supplier.S(() -> {
                            Item newItem = weaponFunction.create((WeaponMaterial)weaponMaterial.get(), new Item.Properties());
                            return newItem;
                        });
                        Main.tab((ResourceKey<CreativeModeTab>)creativeTab, (Supplier<Item>)item);
                        if (oilable) {
                            TagInjector.items.inject("spartanweaponry:oilable_weapons", item);
                        }
                        TagInjector.items.inject("spartanweaponry:" + weaponName + "s", item);
                        TagInjector.items.inject("forge:weapons", item);
                        TagInjector.items.inject("spartanweaponry:" + materialName + "_weapons", item);
                        EzModLib.register((String)"spartanweaponry", (String)combinedName, (Supplier)item, (String)"DONT_INJECT", (boolean)true);
                        String weaponAttribute = Util.readFileFromOtherMod((String)"spartanweaponry", (String)("/data/spartanweaponry/weapon_attributes/aluminum_" + weaponName + ".json"));
                        if (weaponAttribute != null) {
                            VirtualDatapack.addFile((String)"weapon_attributes", (String)"spartanweaponry", (String)("weapon_attributes/" + combinedName + ".json"), (String)weaponAttribute);
                        }
                        String recipe = Util.readFileFromOtherMod((String)"spartanweaponry", (String)("/data/spartanweaponry/recipes/aluminum_" + weaponName + ".json"));
                        recipe = recipe.replaceAll("spartanweaponry:ingots/aluminum", mineral.tag.replace("forge:", "spartanweaponry:"));
                        recipe = recipe.replaceAll("aluminum", materialName);
                        JsonObject recipeObject = JsonParser.parseString((String)recipe).getAsJsonObject();
                        recipeObject.remove("conditions");
                        EzModLib.recipes.put(new ResourceLocation("minersminerals", combinedName), recipeObject);
                        if (FMLEnvironment.dist != Dist.CLIENT) continue;
                        for (String string : models) {
                            void var31_80;
                            String jsonModel = Util.readFileFromOtherMod((String)"spartanweaponry", (String)("/assets/spartanweaponry/models/item/aluminum_" + string + ".json"));
                            jsonModel = jsonModel.replaceAll("aluminum", materialName);
                            VirtualResourcepack.addFile((String)"spartanweaponry", (String)("models/item/" + materialName + "_" + string + ".json"), (String)jsonModel);
                            if (fieldName.equals("HEAVY_CROSSBOW") || fieldName.equals("LONGBOW")) {
                                if (string.equals(models.get(0))) {
                                    String string2 = string + "_standby";
                                } else if (string.contains("_firing")) {
                                    String string3 = (String)models.get(3);
                                }
                            } else {
                                String string4 = (String)models.get(0);
                            }
                            Generator.genTexture(mineralColor, (String)var31_80, mineral, "spartanweaponry", 1.22f, 1.5f, 1.2f);
                        }
                    }
                }
            }
            if (ModList.get().isLoaded("apotheosis")) {
                String[] dimensions;
                Mineral[] minerals1 = new Mineral[]{Mineral.JET, Mineral.RHODONITE, Mineral.BRONZITE, Mineral.COPPER, Mineral.TIN, Mineral.ALUMINUM, Mineral.BRASS, Mineral.NICKEL, Mineral.BRONZE, Mineral.LEAD, Mineral.ELECTRUM, Mineral.OSMIUM, Mineral.MAGNETITE, Mineral.BISMUTH, Mineral.ZINC, Mineral.ANTIMONY, Mineral.JASPER, Mineral.SELENITE, Mineral.GARNET, Mineral.RUBY, Mineral.AMETHYST, Mineral.SAPPHIRE, Mineral.QUARTZ, Mineral.ZIRCON, Mineral.PRISMARINE, Mineral.TOPAZ, Mineral.OLIVINE, Mineral.AMBER, Mineral.SALT};
                Mineral[] minerals2 = new Mineral[]{Mineral.SILVER, Mineral.TITANIUM, Mineral.TUNGSTEN, Mineral.PLATINUM, Mineral.STEEL, Mineral.PALLADIUM, Mineral.COBALT, Mineral.MYTHRIL, Mineral.SILICON, Mineral.URANIUM, Mineral.SPINEL, Mineral.TOURMALINE, Mineral.TIGERS_EYE, Mineral.PERIDOT, Mineral.OPAL, Mineral.MOSS_AGATE, Mineral.JADE, Mineral.SUNSTONE, Mineral.ONYX, Mineral.BLOOD_STONE, Mineral.SERPENTINE};
                Mineral[] minerals3 = new Mineral[]{Mineral.COBALT, Mineral.MYTHRIL, Mineral.UNBIHEXIUM, Mineral.HEDERAIUM, Mineral.SHROOMITE, Mineral.DEUTERIUM, Mineral.ADAMANTIUM, Mineral.SPACE_ROCK, Mineral.CHAROITE};
                Generator.genFiles(minerals1, new ResourceLocation("minecraft:overworld"), 0);
                Generator.genFiles(minerals2, new ResourceLocation("minecraft:the_nether"), 1);
                Generator.genFiles(minerals3, new ResourceLocation("minecraft:the_end"), 2);
                List<Mineral> list1 = Arrays.asList(minerals1);
                List<Mineral> list2 = Arrays.asList(minerals2);
                List<Mineral> list3 = Arrays.asList(minerals3);
                ArrayList<Mineral> allMinerals = new ArrayList<Mineral>();
                allMinerals.addAll(list1);
                allMinerals.addAll(list2);
                allMinerals.addAll(list3);
                for (String dimension : dimensions = new String[]{"overworld", "the_nether", "the_end"}) {
                    String filePath = "gear_sets/" + dimension + "/mixed_gear.json";
                    List<Mineral> minerals = list1;
                    if (dimension.equals("the_nether")) {
                        minerals = list2;
                    } else if (dimension.equals("the_end")) {
                        minerals = list3;
                    }
                    Object json = "{\n\t\"weight\": 70,\n";
                    if (dimension.equals("overworld")) {
                        json = (String)json + "\t\"quality\": 5,\n";
                    }
                    json = (String)json + "\t\"mainhands\": [";
                    for (Mineral m : minerals) {
                        for (String handItem : fileTypesHand) {
                            json = (String)json + "{\n\t\t\t\"weight\": 1,\n\t\t\t\"stack\": {\n\t\t\t\t\"item\": \"minersminerals:" + m.getLowerName() + handItem + "\"\n\t\t\t}\n\t\t},";
                        }
                    }
                    json = ((String)json).substring(0, ((String)json).length() - 1);
                    json = (String)json + "\n\t],\n\t\"offhands\": [],\n\t\"boots\": [";
                    for (Mineral m : minerals) {
                        json = (String)json + "{\n\t\t\"weight\": 1,\n\t\t\"stack\": {\n\t\t\t\"item\": \"minersminerals:" + m.getLowerName() + "_boots\"\n\t\t}\n\t},";
                    }
                    json = ((String)json).substring(0, ((String)json).length() - 1);
                    json = (String)json + "],\n\t\"leggings\": [";
                    for (Mineral m : minerals) {
                        json = (String)json + "{\n\t\t\"weight\": 1,\n\t\t\"stack\": {\n\t\t\t\"item\": \"minersminerals:" + m.getLowerName() + "_leggings\"\n\t\t}\n\t},";
                    }
                    json = ((String)json).substring(0, ((String)json).length() - 1);
                    json = (String)json + "],\n\t\"chestplates\": [";
                    for (Mineral m : minerals) {
                        json = (String)json + "{\n\t\t\"weight\": 1,\n\t\t\"stack\": {\n\t\t\t\"item\": \"minersminerals:" + m.getLowerName() + "_chestplate\"\n\t\t}\n\t},";
                    }
                    json = ((String)json).substring(0, ((String)json).length() - 1);
                    json = (String)json + "],\n\t\"helmets\": [";
                    for (Mineral m : minerals) {
                        json = (String)json + "{\n\t\t\"weight\": 1,\n\t\t\"stack\": {\n\t\t\t\"item\": \"minersminerals:" + m.getLowerName() + "_helmet\"\n\t\t}\n\t},";
                    }
                    json = ((String)json).substring(0, ((String)json).length() - 1);
                    json = (String)json + "],\n\t\"tags\": [\n\t\t\"" + dimension + "\"\n\t]\n}";
                    VirtualDatapack.addFile((String)"gear_sets", (String)"minersminerals", (String)filePath, (String)json);
                }
            }
            lang = ((String)lang).substring(0, ((String)lang).length() - 2);
            lang = (String)lang + "}";
            VirtualResourcepack.addFile((String)"minersminerals", (String)"lang/en_us.json", (String)lang);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void createRecipe(String recipe, String id, Mineral m, String combinedName) {
        JsonObject recipeObject = JsonParser.parseString((String)recipe).getAsJsonObject();
        Map map = recipeObject.asMap();
        for (Map.Entry entry : map.entrySet()) {
            if (((String)entry.getKey()).equals("key")) {
                JsonObject keys = (JsonObject)entry.getValue();
                for (Map.Entry key : keys.entrySet()) {
                    JsonObject keyObject = (JsonObject)key.getValue();
                    for (Map.Entry ingredient : keyObject.entrySet()) {
                        if (((JsonElement)ingredient.getValue()).equals(gold_ingot)) {
                            keyObject.remove("item");
                            keyObject.add("tag", (JsonElement)new JsonPrimitive(m.tag));
                            continue;
                        }
                        if (((JsonElement)ingredient.getValue()).equals(iron_nugget)) {
                            if (m.gem) continue;
                            keyObject.remove("item");
                            keyObject.add("tag", (JsonElement)new JsonPrimitive("forge:nuggets/" + m.m_6082_()));
                            continue;
                        }
                        if (!((JsonElement)ingredient.getValue()).equals(golden_sword)) continue;
                        keyObject.remove("item");
                        keyObject.add("item", (JsonElement)new JsonPrimitive("minersminerals:" + m.m_6082_() + "_sword"));
                    }
                }
                continue;
            }
            if (!((String)entry.getKey()).equals("result")) continue;
            JsonObject o = (JsonObject)entry.getValue();
            o.remove("item");
            o.add("item", (JsonElement)new JsonPrimitive(id + ":" + combinedName));
        }
        EzModLib.recipes.put(new ResourceLocation(id, combinedName), recipeObject);
    }

    private static void genTexture(int mineralColor, String weapon, Mineral m, String MODID, float contrast, float brightness, float saturation) {
        String imagePath = "/assets/" + MODID + "/textures/item/" + weapon + ".png";
        String handlePath = "/assets/" + MODID + "/textures/item/" + weapon + "_handle.png";
        try (InputStream base = m.getClass().getResourceAsStream(imagePath);
             InputStream handle = m.getClass().getResourceAsStream(handlePath);){
            BufferedImage baseImage = ImageIO.read(base);
            BufferedImage handleImage = ImageIO.read(handle);
            for (int x = 0; x < baseImage.getWidth(); ++x) {
                for (int y = 0; y < baseImage.getHeight(); ++y) {
                    int color = baseImage.getRGB(x, y);
                    int handleAlpha = (handleImage.getRGB(x, y) & 0xFF000000) >> 24;
                    int a = (color & 0xFF000000) >> 24;
                    if (a == 0 && handleAlpha == 0) continue;
                    int r = (color & 0xFF0000) >> 16;
                    int g = (color & 0xFF00) >> 8;
                    int b = color & 0xFF;
                    r = Math.min(255, Math.max(0, (int)((float)(r - 128) * contrast + 128.0f)));
                    g = Math.min(255, Math.max(0, (int)((float)(b - 128) * contrast + 128.0f)));
                    b = Math.min(255, Math.max(0, (int)((float)(b - 128) * contrast + 128.0f)));
                    int mr = (mineralColor & 0xFF0000) >> 16;
                    int mg = (mineralColor & 0xFF00) >> 8;
                    int mb = mineralColor & 0xFF;
                    int tintedR = Math.round((float)r / 255.0f * brightness * ((float)mr / 255.0f) * 255.0f);
                    int tintedG = Math.round((float)g / 255.0f * brightness * ((float)mg / 255.0f) * 255.0f);
                    int tintedB = Math.round((float)b / 255.0f * brightness * ((float)mb / 255.0f) * 255.0f);
                    float[] hsb = Color.RGBtoHSB(tintedR > 255 ? 255 : tintedR, tintedG > 255 ? 255 : tintedG, tintedB > 255 ? 255 : tintedB, null);
                    hsb[1] = Math.min(1.0f, hsb[1] * saturation);
                    int rgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
                    tintedR = (rgb & 0xFF0000) >> 16;
                    tintedG = (rgb & 0xFF00) >> 8;
                    tintedB = rgb & 0xFF;
                    int combined = 0xFF000000 | tintedR << 16 | tintedG << 8 | tintedB;
                    baseImage.setRGB(x, y, combined);
                    if (handleAlpha == 0) continue;
                    baseImage.setRGB(x, y, handleImage.getRGB(x, y));
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (ImageIO.write((RenderedImage)baseImage, "PNG", baos)) {
                VirtualResourcepack.addFile((String)MODID, (String)("textures/item/" + m.m_6082_() + "_" + weapon + ".png"), () -> new ByteArrayInputStream(baos.toByteArray()));
            }
        }
        catch (Exception e) {
            System.out.println("Failed to generate " + m.m_6082_() + " " + weapon + " texture.");
            e.printStackTrace();
        }
    }

    private static void genFiles(Mineral[] minerals, ResourceLocation dimension, int rarity) throws IOException {
        for (Mineral m : minerals) {
            for (int i = 0; i < fileTypes.length; ++i) {
                String name = m.getLowerName() + fileTypes[i];
                String filePath = "affix_loot_entries/" + dimension.m_135815_() + "/" + name + ".json";
                String json = "";
                float quality = (float)m.m_6604_() + 3.0f;
                int weight = m.frequency + m.size * 5;
                if (m.size == Mineral.JET.size || m.size == 0) {
                    weight = 80;
                }
                if (fileTypes[i].equals("_greatsword")) {
                    weight /= 2;
                }
                if (weight == 0) {
                    weight = 10;
                }
                String item = "minersminerals:" + name;
                json = "{\n    \"dimensions\": [\n        \"%s\"\n    ],\n    \"min_rarity\": \"%s:%s\",\n    \"max_rarity\": \"%s:%s\",\n    \"weight\": %s,\n    \"quality\": %s,\n    \"stack\": {\n        \"item\": \"%s\",\n        \"count\": 1,\n        \"nbt\": {\n            \"Damage\": 0\n        }\n    }\n}\n".formatted(dimension, "apotheosis", rarity == 0 ? "common" : (rarity == 1 ? "uncommon" : "rare"), "apotheosis", rarity == 0 ? "rare" : (rarity == 1 ? "epic" : "mythic"), weight, Float.valueOf(quality), item);
                VirtualDatapack.addFile((String)"affix_loot_entries", (String)"minersminerals", (String)filePath, (String)json);
            }
        }
    }

    private static class HiddenSimplySword {
        private HiddenSimplySword() {
        }

        public static Supplier<Item> makeSword(Tier m, int damage, float attackspeed, String[] strings) {
            return Supplier.S(() -> new SimplySwordsSwordItem(m, damage, attackspeed, strings));
        }
    }

    private static class HiddenSimplyMore {
        private HiddenSimplyMore() {
        }

        public static Supplier<Item> makeSword(String weapon, Tier m, int damage, float attackspeed, String[] strings) {
            if (weapon.equals("lance")) {
                return Supplier.S(() -> new LanceItem(m, damage, attackspeed, new Item.Properties(), strings));
            }
            if (weapon.equals("grandsword")) {
                return Supplier.S(() -> new GrandSwordItem(m, damage, attackspeed, new Item.Properties(), strings));
            }
            return Supplier.S(() -> new SimplyMoreSwordItem(m, damage, attackspeed, new Item.Properties(), strings));
        }
    }
}

