/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.minersminerals;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.zephaniahnoah.ezmodlib.ChunkDecorator;
import com.zephaniahnoah.ezmodlib.EzModLib;
import com.zephaniahnoah.ezmodlib.LootTableInjector;
import com.zephaniahnoah.ezmodlib.TagInjector;
import com.zephaniahnoah.ezmodlib.VirtualDatapack;
import com.zephaniahnoah.ezmodlib.VirtualResourcepack;
import com.zephaniahnoah.ezmodlib.recipe.FurnaceRecipe;
import com.zephaniahnoah.ezmodlib.recipe.ShapedRecipe;
import com.zephaniahnoah.ezmodlib.recipe.ShapelessRecipe;
import com.zephaniahnoah.ezmodlib.recipe.SingleInputRecipe;
import com.zephaniahnoah.ezmodlib.recipe.SmithingRecipe;
import com.zephaniahnoah.ezmodlib.util.BiomeCategories;
import com.zephaniahnoah.ezmodlib.util.SwapMap;
import com.zephaniahnoah.ezmodlib.util.Util;
import com.zephaniahnoah.minersminerals.Generator;
import com.zephaniahnoah.minersminerals.GreatSwordItem;
import com.zephaniahnoah.minersminerals.IMineralOre;
import com.zephaniahnoah.minersminerals.Mineral;
import com.zephaniahnoah.minersminerals.MineralArmor;
import com.zephaniahnoah.minersminerals.Ores;
import com.zephaniahnoah.minersminerals.WorldGen;
import com.zephaniahnoah.minersminerals.extras.Extras;
import com.zephaniahnoah.minersminerals.extras.clam.ClamRenderer;
import com.zephaniahnoah.minersminerals.extras.shuriken.Shuriken;
import com.zephaniahnoah.minersminerals.extras.shuriken.ShurikenEntity;
import com.zephaniahnoah.minersminerals.extras.shuriken.ShurikenRenderer;
import com.zephaniahnoah.minersminerals.extras.spear.Spear;
import com.zephaniahnoah.minersminerals.extras.spear.SpearEntity;
import com.zephaniahnoah.minersminerals.extras.spear.SpearRenderer;
import com.zephaniahnoah.minersminerals.extras.trex.TRexSkullRenderer;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.StringConcatFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Scanner;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod(value="minersminerals")
@Mod.EventBusSubscriber(modid="minersminerals", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Main {
    public static final UUID ENTITY_REACH_UUID = UUID.fromString("bdf49f04-ac47-4756-856a-0da487af8e1d");
    public static final String MODID = "minersminerals";
    public static final Map<String, com.zephaniahnoah.ezmodlib.util.Supplier<Item>> spears = new HashMap<String, com.zephaniahnoah.ezmodlib.util.Supplier<Item>>();
    public static final Map<String, com.zephaniahnoah.ezmodlib.util.Supplier<Item>> shurikens = new HashMap<String, com.zephaniahnoah.ezmodlib.util.Supplier<Item>>();
    public static SwapMap<RegistryObject<Block>, IMineralOre> baseMinerals = new SwapMap(new HashMap());
    private static List<ResourceLocation> dimensionBlacklist = new ArrayList<ResourceLocation>();
    private List<ResourceLocation> baseBlocks = new ArrayList<ResourceLocation>();
    public static final Pair<String[], String[][]> armorData = new Pair((Object)new String[]{"_boots", "_leggings", "_chestplate", "_helmet"}, (Object)new String[][]{{"# #", "# #"}, {"###", "# #", "# #"}, {"# #", "###", "###"}, {"###", "# #"}});
    private static final Map<ResourceKey<CreativeModeTab>, List<com.zephaniahnoah.ezmodlib.util.Supplier<Item>>> tabData = new HashMap<ResourceKey<CreativeModeTab>, List<com.zephaniahnoah.ezmodlib.util.Supplier<Item>>>();
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"minersminerals");
    public static final ResourceKey<CreativeModeTab> creativeTab = TABS.register("minersminerals", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.minersminerals")).m_257737_(() -> new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(MODID, "adamantium_ingot")))).m_257652_()).getKey();
    public static final ResourceKey<CreativeModeTab> oreTab = TABS.register("minersminerals.ores", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.minersminerals.ores")).m_257737_(() -> new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(MODID, "spinel_andesite_ore")))).m_257652_()).getKey();

    public static com.zephaniahnoah.ezmodlib.util.Supplier<Item> tab(ResourceKey<CreativeModeTab> creativetab, com.zephaniahnoah.ezmodlib.util.Supplier<Item> supplier) {
        if (!tabData.containsKey(creativetab)) {
            tabData.put(creativetab, new ArrayList());
        }
        tabData.get(creativetab).add(supplier);
        return supplier;
    }

    @SubscribeEvent
    public static void onCreativeTabBuild(BuildCreativeModeTabContentsEvent event) {
        if (tabData.get(event.getTabKey()) != null) {
            for (com.zephaniahnoah.ezmodlib.util.Supplier<Item> data : tabData.get(event.getTabKey())) {
                event.accept(data);
            }
        }
    }

    public Main() {
        String n;
        Generator.generateData();
        try {
            Scanner reader;
            File config;
            Path minersFolder;
            Path configFolder = Paths.get("config", new String[0]);
            if (!Files.exists(configFolder, new LinkOption[0])) {
                Files.createDirectories(configFolder, new FileAttribute[0]);
            }
            if (!Files.exists(minersFolder = Paths.get("config/minersminerals", new String[0]), new LinkOption[0])) {
                Files.createDirectories(minersFolder, new FileAttribute[0]);
            }
            if ((config = new File("config/minersminerals/base_blocks.txt")).exists()) {
                reader = new Scanner(config);
                while (reader.hasNextLine()) {
                    ResourceLocation loc = new ResourceLocation(reader.nextLine());
                    Ores.defaultBlocks.add(loc);
                    this.baseBlocks.add(loc);
                }
                reader.close();
            } else {
                config.createNewFile();
            }
            config = new File("config/minersminerals/dimension_blacklist.txt");
            if (config.exists()) {
                reader = new Scanner(config);
                while (reader.hasNextLine()) {
                    dimensionBlacklist.add(new ResourceLocation(reader.nextLine()));
                }
                reader.close();
            } else {
                config.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        TABS.register(context.getModEventBus());
        context.getModEventBus().register((Object)this);
        EzModLib.init((String)MODID);
        String name = null;
        Extras.init();
        ResourceLocation fossilName = new ResourceLocation("minersminerals:fossil_deposit_block");
        Ores.defaultBlocks.add(fossilName);
        Object armorTrimsJson = "{\"type\":\"append\",\"sources\":[{\"type\":\"paletted_permutations\",\"textures\":[\"trims/models/armor/coast\",\"trims/models/armor/coast_leggings\",\"trims/models/armor/sentry\",\"trims/models/armor/sentry_leggings\",\"trims/models/armor/dune\",\"trims/models/armor/dune_leggings\",\"trims/models/armor/wild\",\"trims/models/armor/wild_leggings\",\"trims/models/armor/ward\",\"trims/models/armor/ward_leggings\",\"trims/models/armor/eye\",\"trims/models/armor/eye_leggings\",\"trims/models/armor/vex\",\"trims/models/armor/vex_leggings\",\"trims/models/armor/tide\",\"trims/models/armor/tide_leggings\",\"trims/models/armor/snout\",\"trims/models/armor/snout_leggings\",\"trims/models/armor/rib\",\"trims/models/armor/rib_leggings\",\"trims/models/armor/spire\",\"trims/models/armor/spire_leggings\",\"trims/models/armor/wayfinder\",\"trims/models/armor/wayfinder_leggings\",\"trims/models/armor/shaper\",\"trims/models/armor/shaper_leggings\",\"trims/models/armor/silence\",\"trims/models/armor/silence_leggings\",\"trims/models/armor/raiser\",\"trims/models/armor/raiser_leggings\",\"trims/models/armor/host\",\"trims/models/armor/host_leggings\"],\"palette_key\":\"trims/color_palettes/trim_palette\",\"permutations\":{";
        Object blockAtlasJson = "{\"type\":\"append\",\"sources\":[{\"type\":\"directory\",\"source\":\"block\",\"prefix\":\"block/\"},{\"type\":\"directory\",\"source\":\"item\",\"prefix\":\"item/\"},{\"type\":\"directory\",\"source\":\"entity/conduit\",\"prefix\":\"entity/conduit/\"},{\"type\":\"single\",\"resource\":\"entity/bell/bell_body\"},{\"type\":\"single\",\"resource\":\"entity/decorated_pot/decorated_pot_side\"},{\"type\":\"single\",\"resource\":\"entity/enchanting_table_book\"},{\"type\":\"paletted_permutations\",\"textures\":[\"trims/items/leggings_trim\",\"trims/items/chestplate_trim\",\"trims/items/helmet_trim\",\"trims/items/boots_trim\"],\"palette_key\":\"trims/color_palettes/trim_palette\",\"permutations\":{";
        for (Mineral mineral : Mineral.values()) {
            n = mineral.getLowerName();
            com.zephaniahnoah.ezmodlib.util.Supplier mineralBlock = null;
            com.zephaniahnoah.ezmodlib.util.Supplier mineralItem = null;
            com.zephaniahnoah.ezmodlib.util.Supplier mineralBlockItem = null;
            boolean makeItem = true;
            boolean makeBlock = true;
            boolean alloy = false;
            switch (mineral) {
                case RHODONITE: 
                case JET: 
                case SERPENTINE: 
                case BLOOD_STONE: 
                case CHAROITE: 
                case SPACE_ROCK: 
                case BRONZITE: {
                    makeItem = false;
                    break;
                }
                case QUARTZ: 
                case PRISMARINE: {
                    makeItem = false;
                    makeBlock = false;
                    break;
                }
                case PETRIFIED_WOOD: {
                    alloy = true;
                    makeItem = false;
                    makeBlock = false;
                    mineralBlock = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(MODID, "petrified_log")));
                    mineralItem = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(MODID, "petrified_wood_planks")));
                    break;
                }
                case STEEL: 
                case BRONZE: 
                case BRASS: {
                    alloy = true;
                    break;
                }
                case AMETHYST: {
                    makeItem = false;
                    makeBlock = false;
                    mineralBlock = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> Blocks.f_152490_);
                    mineralItem = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> Items.f_151049_);
                    break;
                }
                case COPPER: {
                    alloy = true;
                    makeItem = false;
                    makeBlock = false;
                    mineralBlock = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> Blocks.f_152504_);
                    mineralItem = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> Items.f_151052_);
                    break;
                }
            }
            if (makeBlock) {
                float destroyTime = 2.0f;
                float explosionResistance = 6.0f;
                com.zephaniahnoah.ezmodlib.util.Supplier stupidJava = mineralBlock = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)(m.gem ? Blocks.f_50069_ : Blocks.f_50075_)).m_60918_(m.gem ? SoundType.f_56742_ : SoundType.f_56743_).m_60999_().m_60913_(destroyTime, explosionResistance)));
                mineralBlockItem = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new BlockItem((Block)stupidJava.get(), new Item.Properties()){

                    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                        if (m == Mineral.JET) {
                            return 800;
                        }
                        return -1;
                    }
                });
                Main.tab(creativeTab, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)mineralBlockItem);
                name = n + "_block";
                Pair blockReg = EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)mineralBlock, null, (com.zephaniahnoah.ezmodlib.util.Supplier)mineralBlockItem, null);
                Main.defaultBlockDrop(name);
                if (makeItem) {
                    TagInjector.blocks.inject("minecraft:beacon_base_blocks", mineralBlock);
                } else {
                    ResourceLocation blockLoc = new ResourceLocation("minersminerals:" + (String)name);
                    baseMinerals.put((Object)((RegistryObject)blockReg.getFirst()), (Object)mineral);
                    if (mineral != Mineral.BLOOD_STONE && mineral != Mineral.CHAROITE && mineral != Mineral.SPACE_ROCK) {
                        Ores.defaultBlocks.add(blockLoc);
                    }
                    TagInjector.blocks.inject("forge:wg_stone", mineralBlock);
                    TagInjector.items.inject(mineral.tag, mineralBlockItem);
                }
                TagInjector.blocks.inject("forge:wg_stone", mineralBlock);
                TagInjector.blocks.inject("minecraft:mineable/pickaxe", mineralBlock);
            }
            if (makeItem) {
                mineralItem = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Item(new Item.Properties()){

                    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                        if (m == Mineral.AMBER) {
                            return 1600;
                        }
                        return -1;
                    }
                });
                Main.tab(creativeTab, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)mineralItem);
                name = n + (mineral.gem ? "" : "_ingot");
                EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)mineralItem, (boolean)false);
                VirtualResourcepack.addFile((String)MODID, (String)("textures/trims/color_palettes/" + n + ".png"), () -> m.generateTrimPaletteImage());
                String json = "{\n  \"asset_name\": \"%s\",\n  \"description\": {\n    \"color\": \"%s\",\n    \"translate\": \"trim_material.%s.%s\"\n  },\n  \"ingredient\": \"%s:%s\",\n  \"item_model_index\": %s\n}\n".formatted(n, mineral.getColorString(), MODID, n, MODID, name, "0.2");
                VirtualDatapack.addFile((String)"trim_material", (String)MODID, (String)("trim_material/" + n + ".json"), (String)json);
                TagInjector.items.inject("minecraft:trim_materials", mineralItem);
                String trimPalette = "\"" + n + "\":\"minersminerals:trims/color_palettes/" + n + "\",";
                armorTrimsJson = (String)armorTrimsJson + trimPalette;
                blockAtlasJson = (String)blockAtlasJson + trimPalette;
                TagInjector.items.inject("minecraft:beacon_payment_items", mineralItem);
                if (!mineral.gem) {
                    com.zephaniahnoah.ezmodlib.util.Supplier<Item> nugget = Main.tab(creativeTab, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Item(new Item.Properties())));
                    EzModLib.register((String)MODID, (String)(n + "_nugget"), nugget, (boolean)false);
                    com.zephaniahnoah.ezmodlib.util.Supplier stupidJava = mineralItem;
                    new ShapedRecipe(new ResourceLocation(n + "_ingot_recipe"), new String[]{"###", "###", "###"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)stupidJava.get())).toString()), 1).item('#', "minersminerals:" + n + "_nugget");
                    new ShapelessRecipe(new ResourceLocation(n + "_nugget_recipe"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)nugget.get())).toString()), 9).item("minersminerals:" + n + "_ingot");
                    TagInjector.items.inject("forge:nuggets/" + n, nugget);
                    if (!alloy) {
                        com.zephaniahnoah.ezmodlib.util.Supplier rawOre = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Item(new Item.Properties()));
                        Main.tab(creativeTab, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)rawOre);
                        EzModLib.register((String)MODID, (String)("raw_" + n), (com.zephaniahnoah.ezmodlib.util.Supplier)rawOre, (boolean)false);
                        TagInjector.items.inject("forge:raw_materials/" + n, rawOre);
                        TagInjector.items.inject("forge:raw_materials", rawOre);
                        new FurnaceRecipe((ResourceLocation)new ResourceLocation((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001_raw_blast"}, (String)mineral.getLowerName()))), (SingleInputRecipe.SingleInputType)SingleInputRecipe.SingleInputType.BLASTING, (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$18(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)((com.zephaniahnoah.ezmodlib.util.Supplier)rawOre)), (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$19(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)((com.zephaniahnoah.ezmodlib.util.Supplier)stupidJava)), (int)100, (double)0.7).group = mineral.getLowerName() + "_blast";
                        new FurnaceRecipe((ResourceLocation)new ResourceLocation((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001_raw_smelt"}, (String)mineral.getLowerName()))), (SingleInputRecipe.SingleInputType)SingleInputRecipe.SingleInputType.SMELTING, (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$20(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)((com.zephaniahnoah.ezmodlib.util.Supplier)rawOre)), (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$21(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)((com.zephaniahnoah.ezmodlib.util.Supplier)stupidJava)), (int)200, (double)0.7).group = mineral.getLowerName() + "_smelt";
                        com.zephaniahnoah.ezmodlib.util.Supplier rawBlock = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Block(BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(5.0f, 6.0f)));
                        com.zephaniahnoah.ezmodlib.util.Supplier<Item> rawBlockItem = Main.tab(creativeTab, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new BlockItem((Block)rawBlock.get(), new Item.Properties())));
                        EzModLib.register((String)MODID, (String)(n + "_block_raw"), (com.zephaniahnoah.ezmodlib.util.Supplier)rawBlock, null, rawBlockItem, null);
                        TagInjector.blocks.inject("minecraft:mineable/pickaxe", rawBlock);
                        new ShapedRecipe(new ResourceLocation(n + "_raw_block_recipe"), new String[]{"###", "###", "###"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)rawBlockItem.get())).toString()), 1).item('#', "minersminerals:raw_" + n);
                        new ShapedRecipe(new ResourceLocation(n + "_raw_ore_recipe"), new String[]{"#"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)rawOre.get())).toString()), 9).item('#', "minersminerals:" + n + "_block_raw");
                    }
                }
                TagInjector.items.inject(mineral.tag, mineralItem);
            }
            if (ModList.get().isLoaded("spartanweaponry")) {
                TagInjector.items.inject(mineral.tag.replace("forge:", "spartanweaponry:"), !makeItem && makeBlock ? mineralBlockItem : mineralItem);
            }
            if (makeBlock && makeItem) {
                com.zephaniahnoah.ezmodlib.util.Supplier stupidJava = mineralBlockItem;
                com.zephaniahnoah.ezmodlib.util.Supplier javaIsStupid = mineralItem;
                new ShapedRecipe(new ResourceLocation(n + "_block_recipe"), new String[]{"###", "###", "###"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)stupidJava.get())).toString()), 1).item('#', "minersminerals:" + name);
                new ShapelessRecipe(new ResourceLocation(n + "_decompress"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)javaIsStupid.get())).toString()), 9).item("minersminerals:" + n + "_block");
            }
            mineral.cook();
            for (int j = 0; j < mineral.baseBlocks.size(); ++j) {
                String[] tools;
                boolean baseFromConfig;
                String texture;
                Object blockPath;
                Block base;
                ResourceLocation baseBlock = mineral.baseBlocks.get(j);
                if ((!makeBlock || !makeItem || alloy) && mineral != Mineral.AMETHYST) continue;
                Optional<RegistryObject> optional = baseMinerals.keySet().stream().filter(value -> value.getKey().m_135782_().equals((Object)baseBlock)).findFirst();
                if (!optional.isEmpty()) {
                    base = Blocks.f_50069_;
                    blockPath = ((IMineralOre)baseMinerals.get((Object)optional.get())).getLowerName() + "_block";
                    texture = "minersminerals:block/" + (String)blockPath;
                    baseFromConfig = false;
                } else if (this.baseBlocks.contains(baseBlock)) {
                    base = Blocks.f_50069_;
                    blockPath = baseBlock.m_135815_();
                    texture = baseBlock.m_135827_() + ":block/" + (String)blockPath;
                    baseFromConfig = true;
                } else {
                    base = (Block)ForgeRegistries.BLOCKS.getValue(baseBlock);
                    baseFromConfig = false;
                    blockPath = baseBlock.m_135815_();
                    texture = baseBlock.m_135827_() + ":block/" + (String)blockPath;
                }
                String blockModel = "{\"loader\":\"forge:composite\",\"parent\":\"" + texture + "\",\"children\":{\"base_layer\":{\"parent\":\"" + texture + "\",\"render_type\":\"minecraft:solid\"},\"overlay_layer\":{\"parent\":\"minecraft:block/cube_all\",\"textures\":{\"all\":\"minersminerals:block/" + n + "_ore\"},\"render_type\":\"minecraft:translucent\"}}}";
                ArmorItem.Type[] ore = com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)base).m_60999_().m_60913_((float)m.m_6604_(), 6.0f)));
                com.zephaniahnoah.ezmodlib.util.Supplier<Item> blockItem = Main.tab(oreTab, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> this.lambda$new$30((com.zephaniahnoah.ezmodlib.util.Supplier)ore, baseFromConfig)));
                TagInjector.blocks.inject("forge:ores/" + mineral.getLowerName(), (com.zephaniahnoah.ezmodlib.util.Supplier)ore);
                TagInjector.items.inject("forge:ores/" + mineral.getLowerName(), blockItem);
                name = n + "_" + (String)blockPath + "_ore";
                EzModLib.register((String)MODID, (String)name, (com.zephaniahnoah.ezmodlib.util.Supplier)ore, (String)blockModel, blockItem, null);
                baseMinerals.values().forEach(arg_0 -> Main.lambda$new$31(baseBlock, (com.zephaniahnoah.ezmodlib.util.Supplier)ore, arg_0));
                for (String tool : tools = new String[]{"pickaxe", "axe", "shovel", "hoe"}) {
                    String fileContent = Util.readFileFromOtherMod((String)baseBlock.m_135827_(), (String)("data/minecraft/tags/blocks/mineable/" + tool + ".json"));
                    if (fileContent == null || !fileContent.contains(baseBlock.toString())) continue;
                    TagInjector.blocks.inject("minecraft:mineable/" + tool, (com.zephaniahnoah.ezmodlib.util.Supplier)ore);
                }
                TagInjector.blocks.inject(mineral.getToolTag(), (com.zephaniahnoah.ezmodlib.util.Supplier)ore);
                this.oreLootTable(mineral, name);
                Ores.register(mineral, (com.zephaniahnoah.ezmodlib.util.Supplier<Block>)ore, j);
                com.zephaniahnoah.ezmodlib.util.Supplier stupidJava = mineralItem;
                new FurnaceRecipe((ResourceLocation)new ResourceLocation((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001_blast_\u0001"}, (String)mineral.getLowerName(), (String)blockPath))), (SingleInputRecipe.SingleInputType)SingleInputRecipe.SingleInputType.BLASTING, (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$32(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)(blockItem)), (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$33(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)((com.zephaniahnoah.ezmodlib.util.Supplier)stupidJava)), (int)100, (double)0.7).group = mineral.getLowerName() + "_blast";
                new FurnaceRecipe((ResourceLocation)new ResourceLocation((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001_smelt_\u0001"}, (String)mineral.getLowerName(), (String)blockPath))), (SingleInputRecipe.SingleInputType)SingleInputRecipe.SingleInputType.SMELTING, (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$34(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)(blockItem)), (com.zephaniahnoah.ezmodlib.util.Supplier)com.zephaniahnoah.ezmodlib.util.Supplier.S((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$35(com.zephaniahnoah.ezmodlib.util.Supplier ), ()Ljava/lang/String;)((com.zephaniahnoah.ezmodlib.util.Supplier)stupidJava)), (int)200, (double)0.7).group = mineral.getLowerName() + "_smelt";
            }
            com.zephaniahnoah.ezmodlib.util.Supplier<Item> shovel = Main.tab(creativeTab, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new ShovelItem((Tier)m, 1.5f, -3.0f, new Item.Properties())));
            name = n + "_shovel";
            EzModLib.register((String)MODID, (String)name, shovel, (boolean)true);
            new ShapedRecipe(new ResourceLocation(name + "_recipe"), new String[]{"#", "/", "/"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)shovel.get())).toString()), 1).tag('/', "forge:rods/wooden").tag('#', mineral.tag);
            com.zephaniahnoah.ezmodlib.util.Supplier<Item> pickaxe = Main.tab(creativeTab, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new PickaxeItem((Tier)m, 1, -2.8f, new Item.Properties())));
            name = n + "_pickaxe";
            EzModLib.register((String)MODID, (String)name, pickaxe, (boolean)true);
            new ShapedRecipe(new ResourceLocation(name + "_recipe"), new String[]{"###", " / ", " / "}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)pickaxe.get())).toString()), 1).tag('/', "forge:rods/wooden").tag('#', mineral.tag);
            com.zephaniahnoah.ezmodlib.util.Supplier<Item> axe = Main.tab(creativeTab, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new AxeItem((Tier)m, 5.5f, -3.1f, new Item.Properties())));
            name = n + "_axe";
            EzModLib.register((String)MODID, (String)name, axe, (boolean)true);
            new ShapedRecipe(new ResourceLocation(name + "_recipe"), new String[]{"##", "#/", " /"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)axe.get())).toString()), 1).tag('/', "forge:rods/wooden").tag('#', mineral.tag);
            com.zephaniahnoah.ezmodlib.util.Supplier<Item> hoe = Main.tab(creativeTab, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new HoeItem((Tier)m, -2, -3.5f, new Item.Properties())));
            name = n + "_hoe";
            EzModLib.register((String)MODID, (String)name, hoe, (boolean)true);
            new ShapedRecipe(new ResourceLocation(name + "_recipe"), new String[]{"##", " /", " /"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)hoe.get())).toString()), 1).tag('/', "forge:rods/wooden").tag('#', mineral.tag);
            com.zephaniahnoah.ezmodlib.util.Supplier<Item> sword = Main.tab(creativeTab, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new SwordItem(m, 3, -2.4f, new Item.Properties()){

                public boolean m_7579_(ItemStack itemStack, LivingEntity entityAttacked, LivingEntity attacker) {
                    Main.tryEffect(this.m_43314_(), entityAttacked);
                    return super.m_7579_(itemStack, entityAttacked, attacker);
                }
            }));
            name = n + "_sword";
            EzModLib.register((String)MODID, (String)name, sword, (String)(mineral == Mineral.ETHERIUM ? "{\"parent\":\"minecraft:item/handheld\",\"textures\":{\"layer0\":\"minersminerals:item/" + n + "_sword\"},\"display\":{\"thirdperson_righthand\":{\"rotation\":[-27,-90,0],\"translation\":[0,0,-4.25]},\"thirdperson_lefthand\":{\"rotation\":[-27,90,0],\"translation\":[0,0,-4.25]},\"firstperson_righthand\":{\"rotation\":[0,-79,0],\"translation\":[7,0,-10.25],\"scale\":[1.1,1.1,1.1]},\"firstperson_lefthand\":{\"rotation\":[0,79,0],\"translation\":[10,0,-10.25],\"scale\":[1.1,1.1,1.1]},\"ground\":{\"rotation\":[0,0,-45],\"translation\":[0,1.5,0],\"scale\":[0.5,0.5,0.5]}}}" : null), (boolean)true);
            new ShapedRecipe(new ResourceLocation(name + "_recipe"), new String[]{"#", "#", "/"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)sword.get())).toString()), 1).tag('/', "forge:rods/wooden").tag('#', mineral.tag);
            com.zephaniahnoah.ezmodlib.util.Supplier<Item> greatsword = Main.tab(creativeTab, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new GreatSwordItem(m, 8, -3.2f, new Item.Properties())));
            name = n + "_greatsword";
            EzModLib.register((String)MODID, (String)name, greatsword, (String)Main.greatSwordModel(name), (boolean)true);
            ShapedRecipe rec = new ShapedRecipe(new ResourceLocation(name + "_recipe"), new String[]{"#", "#", "/"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)greatsword.get())).toString()), 1).tag('/', "forge:rods/wooden");
            if (mineral == Mineral.QUARTZ) {
                rec.item('#', "minecraft:quartz_block");
            } else if (mineral == Mineral.PRISMARINE) {
                rec.item('#', "minecraft:prismarine_bricks");
            } else if (baseMinerals.values().contains(mineral)) {
                rec.item('#', "minersminerals:polished_" + mineral.getLowerName());
            } else if (mineral == Mineral.COPPER) {
                rec.item('#', "minecraft:copper_block");
            } else if (mineral == Mineral.AMETHYST) {
                rec.item('#', "minecraft:amethyst_block");
            } else if (mineral == Mineral.PETRIFIED_WOOD) {
                rec.item('#', "minersminerals:petrified_log");
            } else {
                rec.item('#', "minersminerals:" + mineral.getLowerName() + "_block");
            }
            block29: for (int k = 0; k < 4; ++k) {
                for (ArmorItem.Type type : ArmorItem.Type.values()) {
                    if (type.m_266308_() != EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)k)) continue;
                    com.zephaniahnoah.ezmodlib.util.Supplier<Item> armor = Main.tab(creativeTab, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new MineralArmor(m, type, new Item.Properties())));
                    name = mineral.getLowerName() + ((String[])armorData.getFirst())[k];
                    EzModLib.register((String)MODID, (String)name, armor, (boolean)false);
                    new ShapedRecipe(new ResourceLocation(name + "_recipe"), ((String[][])armorData.getSecond())[k], com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)armor.get())).toString()), 1).tag('#', mineral.tag);
                    TagInjector.items.inject(ItemTags.f_265942_.f_203868_().toString(), armor);
                    continue block29;
                }
            }
            com.zephaniahnoah.ezmodlib.util.Supplier<Item> spear = Main.tab(creativeTab, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Spear(m, new Item.Properties().m_41503_(m.m_6609_()))));
            name = n + "_spear";
            EzModLib.register((String)MODID, (String)name, spear, (String)Main.spearModel(name), (boolean)false);
            new ShapedRecipe(new ResourceLocation(name + "_recipe"), new String[]{"  #", " / ", "/  "}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)spear.get())).toString()), 1).tag('/', "forge:rods/wooden").tag('#', mineral.tag);
            spears.put(name, spear);
            com.zephaniahnoah.ezmodlib.util.Supplier<Item> shuriken = Main.tab(creativeTab, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> new Shuriken(m, new Item.Properties().m_41503_(m.m_6609_()))));
            name = n + "_shuriken";
            EzModLib.register((String)MODID, (String)name, shuriken, (boolean)true);
            new ShapedRecipe(new ResourceLocation(name + "_recipe"), new String[]{" # ", "# #", " # "}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)shuriken.get())).toString()), 1).tag('#', mineral.tag);
            shurikens.put(name, shuriken);
        }
        armorTrimsJson = ((String)armorTrimsJson).substring(0, ((String)armorTrimsJson).length() - 1);
        blockAtlasJson = ((String)blockAtlasJson).substring(0, ((String)blockAtlasJson).length() - 1);
        armorTrimsJson = (String)armorTrimsJson + "}}]}";
        blockAtlasJson = (String)blockAtlasJson + "}}]}";
        EzModLib.mods.add("minecraft");
        VirtualResourcepack.addFile((String)"minecraft", (String)"atlases/armor_trims.json", (String)armorTrimsJson);
        VirtualResourcepack.addFile((String)"minecraft", (String)"atlases/blocks.json", (String)blockAtlasJson);
        this.registerEntities();
        for (Mineral mineral : Tiers.values()) {
            n = mineral.name().toLowerCase();
            Item.Properties prop = new Item.Properties();
            com.zephaniahnoah.ezmodlib.util.Supplier<Item> greatsword = Main.tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256797_, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> Main.lambda$new$54((Tiers)mineral)));
            name = n + "_greatsword";
            EzModLib.register((String)MODID, (String)name, greatsword, (String)Main.greatSwordModel(name), (boolean)true);
            ResourceLocation loc = new ResourceLocation(name + "_recipe");
            if (mineral == Tiers.NETHERITE) {
                prop.m_41486_();
                new SmithingRecipe(loc, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> "minersminerals:diamond_greatsword"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> "minecraft:netherite_ingot"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)greatsword.get())).toString()), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> "minecraft:netherite_upgrade_smithing_template"));
            } else {
                ShapedRecipe rec = new ShapedRecipe(loc, new String[]{"#", "#", "/"}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)greatsword.get())).toString()), 1).tag('/', "forge:rods/wooden");
                switch (7.$SwitchMap$net$minecraft$world$item$Tiers[mineral.ordinal()]) {
                    case 1: {
                        rec.tag('#', "minecraft:logs");
                        break;
                    }
                    case 2: {
                        rec.tag('#', "forge:stone");
                        break;
                    }
                    default: {
                        rec.tag('#', "forge:storage_blocks/" + mineral.name().toLowerCase());
                    }
                }
            }
            Item.Properties prop2 = new Item.Properties().m_41503_(mineral.m_6609_());
            com.zephaniahnoah.ezmodlib.util.Supplier<Item> spear = Main.tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256797_, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> Main.lambda$new$60((Tiers)mineral, prop2)));
            name = n + "_spear";
            EzModLib.register((String)MODID, (String)name, spear, (String)Main.spearModel(name), (boolean)true);
            ResourceLocation loc2 = new ResourceLocation(name + "_recipe");
            if (mineral == Tiers.NETHERITE) {
                prop2.m_41486_();
                new SmithingRecipe(loc2, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> "minersminerals:diamond_spear"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> "minecraft:netherite_ingot"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)spear.get())).toString()), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> "minecraft:netherite_upgrade_smithing_template"));
            } else {
                ShapedRecipe rec = new ShapedRecipe(loc2, new String[]{"  #", " / ", "/  "}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)spear.get())).toString()), 1).tag('/', "forge:rods/wooden");
                switch (7.$SwitchMap$net$minecraft$world$item$Tiers[mineral.ordinal()]) {
                    case 1: {
                        rec.tag('#', "minecraft:planks");
                        break;
                    }
                    case 2: {
                        rec.tag('#', "forge:cobblestone").tag('#', "forge:stone");
                        break;
                    }
                    case 3: {
                        rec.tag('#', "forge:gems/diamond");
                        break;
                    }
                    default: {
                        rec.tag('#', "forge:ingots/" + mineral.name().toLowerCase());
                    }
                }
            }
            spears.put(name, spear);
            Item.Properties prop4 = new Item.Properties().m_41503_(mineral.m_6609_());
            com.zephaniahnoah.ezmodlib.util.Supplier<Item> shuriken = Main.tab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256797_, (com.zephaniahnoah.ezmodlib.util.Supplier<Item>)com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> Main.lambda$new$66((Tiers)mineral, prop4)));
            name = n + "_shuriken";
            EzModLib.register((String)MODID, (String)name, shuriken, (boolean)true);
            ResourceLocation loc3 = new ResourceLocation(name + "_recipe");
            if (mineral == Tiers.NETHERITE) {
                prop4.m_41486_();
                new SmithingRecipe(loc3, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> "minersminerals:diamond_shuriken"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> "minecraft:netherite_ingot"), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)shuriken.get())).toString()), com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> "minecraft:netherite_upgrade_smithing_template"));
            } else {
                ShapedRecipe rec = new ShapedRecipe(loc3, new String[]{" # ", "# #", " # "}, com.zephaniahnoah.ezmodlib.util.Supplier.S(() -> ForgeRegistries.ITEMS.getKey((Object)((Item)shuriken.get())).toString()), 1);
                switch (7.$SwitchMap$net$minecraft$world$item$Tiers[mineral.ordinal()]) {
                    case 1: {
                        rec.tag('#', "minecraft:planks");
                        break;
                    }
                    case 2: {
                        rec.tag('#', "forge:cobblestone").tag('#', "forge:stone");
                        break;
                    }
                    case 3: {
                        rec.tag('#', "forge:gems/diamond");
                        break;
                    }
                    default: {
                        rec.tag('#', "forge:ingots/" + mineral.name().toLowerCase());
                    }
                }
            }
            shurikens.put(name, shuriken);
        }
        ChunkDecorator.decorators.add(new ChunkDecorator(){

            public void decorate(ChunkAccess chunk, Random rand) {
                for (ResourceLocation dimension : dimensionBlacklist) {
                    if (chunk.getWorldForge().m_9598_().m_175515_(Registries.f_256787_).m_7745_(dimension) != chunk.getWorldForge().m_6042_()) continue;
                    return;
                }
                LevelAccessor world = chunk.getWorldForge();
                float worldArea = world.m_141928_() - world.m_6042_().f_156647_();
                for (Mineral m : Mineral.values()) {
                    com.zephaniahnoah.ezmodlib.util.Supplier<Block>[] b;
                    Holder biome = chunk.m_203495_(8, 70, 8);
                    if (m.biomes() != null) {
                        boolean match = false;
                        for (TagKey<Biome> c : m.biomes()) {
                            if (!c.equals((Object)BiomeCategories.getCategory((Holder)biome))) continue;
                            match = true;
                            break;
                        }
                        if (!match) continue;
                    }
                    if ((b = Ores.ores.get(m)) == null) continue;
                    float oreArea = m.maxHeight - m.minHeight;
                    float orePercent = oreArea / worldArea;
                    int veinsPerChunk = rand.nextInt(m.frequency) + m.frequency / 2;
                    veinsPerChunk = Math.round((float)veinsPerChunk * orePercent);
                    block3: for (int i = 0; i < veinsPerChunk; ++i) {
                        int x = rand.nextInt(15);
                        int y = rand.nextInt(m.maxHeight - m.minHeight) + m.minHeight;
                        int z = rand.nextInt(15);
                        for (int k = 0; k < m.size; ++k) {
                            Direction d = Direction.values()[rand.nextInt(Direction.values().length)];
                            BlockPos pos = new BlockPos(x += d.m_122429_(), y += d.m_122430_(), z += d.m_122431_());
                            ResourceLocation replacing = ForgeRegistries.BLOCKS.getKey((Object)chunk.m_8055_(pos).m_60734_());
                            boolean first = true;
                            boolean found = false;
                            for (int stoneIndex = 0; stoneIndex < m.baseBlocks.size(); ++stoneIndex) {
                                if (replacing.equals((Object)m.baseBlocks.get(stoneIndex))) {
                                    chunk.m_6978_(pos, ((Block)b[stoneIndex].get()).m_49966_(), false);
                                    found = true;
                                    break;
                                }
                                first = false;
                            }
                            if (!found && first) continue block3;
                        }
                    }
                }
            }
        });
        Util.cache.clear();
        WorldGen.init(context.getModEventBus());
    }

    public static void tryEffect(Tier tier, LivingEntity entityAttacking) {
        if (tier == Mineral.SHROOMITE) {
            entityAttacking.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0));
        } else if (tier == Mineral.DEUTERIUM) {
            entityAttacking.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
        } else if (tier == Mineral.LEAD || tier == Mineral.URANIUM || tier == Mineral.ANTIMONY) {
            entityAttacking.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 1));
        } else if (tier == Mineral.SUNSTONE) {
            if (entityAttacking.m_6060_() && entityAttacking.m_20094_() < 240) {
                entityAttacking.m_20254_(entityAttacking.m_20094_() / 20 + 5);
            } else {
                entityAttacking.m_20254_(5);
            }
        } else if (tier == Mineral.SILVER && entityAttacking.m_6336_() == MobType.f_21641_) {
            entityAttacking.m_21153_(entityAttacking.m_21223_() - 5.0f);
        }
    }

    public static void defaultBlockDrop(String name) {
        Main.tableInject(name, "{\"type\":\"minecraft:block\",\"pools\":[{\"rolls\":1,\"entries\":[{\"type\":\"minecraft:item\",\"name\":\"minersminerals:" + name + "\"}],\"conditions\":[{\"condition\":\"minecraft:survives_explosion\"}]}]}");
    }

    private static void tableInject(String name, String table) {
        JsonObject element = JsonParser.parseString((String)table).getAsJsonObject();
        LootTableInjector.tablesToInject.put(new ResourceLocation(MODID, "blocks/" + name), element);
    }

    private void registerEntities() {
        Pair shuriken = EzModLib.register((String)MODID, (String)"shuriken", ShurikenEntity::new, (MobCategory)MobCategory.MISC);
        ((EntityType.Builder)shuriken.getFirst()).m_20699_(0.3f, 0.3f).m_20702_(4).m_20717_(20);
        Pair spear = EzModLib.register((String)MODID, (String)"spear", SpearEntity::new, (MobCategory)MobCategory.MISC);
        ((EntityType.Builder)spear.getFirst()).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.registerRenders((RegistryObject)shuriken.getSecond(), (RegistryObject)spear.getSecond());
        }
        SpearEntity.spearType = (RegistryObject)spear.getSecond();
        ShurikenEntity.shurikenType = (RegistryObject)shuriken.getSecond();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenders(RegistryObject<?> shuriken, RegistryObject<?> spear) {
        EzModLib.registerRender((String)MODID, (String)"shuriken", ShurikenRenderer::new, shuriken);
        EzModLib.registerRender((String)MODID, (String)"spear", SpearRenderer::new, spear);
        EzModLib.blockEntityRenderers.put(Extras.trexTileEntity, TRexSkullRenderer::new);
        EzModLib.blockEntityRenderers.put(Extras.clamTileEntity, ClamRenderer::new);
    }

    public static String spearModel(String name) {
        return "{\"parent\":\"minecraft:item/handheld\",\"textures\":{\"layer0\":\"minersminerals:item/" + name + "\"},\"display\":{\"thirdperson_righthand\":{\"rotation\":[-90,90,0],\"translation\":[0,0,3],\"scale\":[1.625,1.625,1.625]},\"thirdperson_lefthand\":{\"rotation\":[-180,90,0],\"translation\":[0,0,3],\"scale\":[1.625,1.625,1.625]},\"firstperson_righthand\":{\"rotation\":[0,95,0],\"translation\":[7,0,0],\"scale\":[1.25,1.25,1.25]},\"firstperson_lefthand\":{\"rotation\":[0,-85,0],\"translation\":[7,0,0],\"scale\":[1.5,1.25,1.25]}}}";
    }

    public static String greatSwordModel(String name) {
        return "{\"parent\":\"item/generated\",\"display\":{\"thirdperson_righthand\":{\"rotation\":[0,-90,55],\"translation\":[0,13.0,0],\"scale\":[1.7,1.7,0.85]},\"thirdperson_lefthand\":{\"rotation\":[0,90,-55],\"translation\":[0,13,0],\"scale\":[1.7,1.7,0.85]},\"firstperson_righthand\":{\"rotation\":[0,-90,25],\"translation\":[1.13,3.2,1.13],\"scale\":[1.36,1.36,0.68]},\"firstperson_lefthand\":{\"rotation\":[0,90,-25],\"translation\":[1.13,3.2,1.13],\"scale\":[1.36,1.36,0.68]},\"ground\":{\"rotation\":[0,0,0],\"translation\":[0,0,0],\"scale\":[1.0,1.0,0.5]},\"fixed\":{\"rotation\":[0,0,0],\"translation\":[0,0,0],\"scale\":[2.0,2.0,1.0]}},\"textures\":{\"layer0\":\"minersminerals:item/" + name + "\"}}";
    }

    private void oreLootTable(Mineral m, String oreName) {
        String table = "{\"type\":\"minecraft:block\",\"pools\":[{\"rolls\":1,\"entries\":[{\"type\":\"minecraft:alternatives\",\"children\":[{\"type\":\"minecraft:item\",\"conditions\":[{\"condition\":\"minecraft:match_tool\",\"predicate\":{\"enchantments\":[{\"enchantment\":\"minecraft:silk_touch\",\"levels\":{\"min\":1}}]}}],\"name\":\"minersminerals:" + oreName + "\"},{\"type\":\"minecraft:item\",\"functions\":[{\"function\":\"minecraft:set_count\",\"count\":{\"min\":" + m.minDrops + ",\"max\":" + m.maxDrops + ",\"type\":\"minecraft:uniform\"}},{\"function\":\"minecraft:apply_bonus\",\"enchantment\":\"minecraft:fortune\",\"formula\":\"minecraft:ore_drops\"},{\"function\":\"minecraft:explosion_decay\"}],\"name\":\"" + (String)(m == Mineral.AMETHYST ? "minecraft:amethyst_shard" : "minersminerals:" + (m.gem ? "" : "raw_") + m.getLowerName()) + "\"}]}]}]}";
        Main.tableInject(oreName, table);
    }

    public static String toFirstCharUpperAll(String string) {
        StringBuffer sb = new StringBuffer(string);
        for (int i = 0; i < sb.length(); ++i) {
            if (i != 0 && sb.charAt(i - 1) != ' ') continue;
            sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
        }
        return sb.toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent e) {
        for (com.zephaniahnoah.ezmodlib.util.Supplier<Block> b : Extras.transparentBlocks) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.m_110457_());
        }
    }

    private static /* synthetic */ Item lambda$new$66(Tiers tier, Item.Properties prop4) {
        return new Shuriken((Tier)tier, prop4);
    }

    private static /* synthetic */ Item lambda$new$60(Tiers tier, Item.Properties prop2) {
        return new Spear((Tier)tier, prop2);
    }

    private static /* synthetic */ Item lambda$new$54(Tiers tier) {
        return new GreatSwordItem((Tier)tier, 8, -3.2f, new Item.Properties());
    }

    private static /* synthetic */ String lambda$new$35(com.zephaniahnoah.ezmodlib.util.Supplier stupidJava) {
        return ForgeRegistries.ITEMS.getKey((Object)((Item)stupidJava.get())).toString();
    }

    private static /* synthetic */ String lambda$new$34(com.zephaniahnoah.ezmodlib.util.Supplier blockItem) {
        return ForgeRegistries.ITEMS.getKey((Object)((Item)blockItem.get())).toString();
    }

    private static /* synthetic */ String lambda$new$33(com.zephaniahnoah.ezmodlib.util.Supplier stupidJava) {
        return ForgeRegistries.ITEMS.getKey((Object)((Item)stupidJava.get())).toString();
    }

    private static /* synthetic */ String lambda$new$32(com.zephaniahnoah.ezmodlib.util.Supplier blockItem) {
        return ForgeRegistries.ITEMS.getKey((Object)((Item)blockItem.get())).toString();
    }

    private static /* synthetic */ void lambda$new$31(ResourceLocation baseBlock, com.zephaniahnoah.ezmodlib.util.Supplier ore, IMineralOre mineral) {
        if ((mineral.getLowerName() + "_block").equals(baseBlock.m_135815_())) {
            TagInjector.blocks.inject("minecraft:mineable/pickaxe", ore);
        }
    }

    private /* synthetic */ Item lambda$new$30(com.zephaniahnoah.ezmodlib.util.Supplier ore, final boolean baseFromConfig) {
        return new BlockItem((Block)ore.get(), new Item.Properties()){

            public String m_5524_() {
                if (baseFromConfig) {
                    return Main.toFirstCharUpperAll(ForgeRegistries.ITEMS.getKey((Object)this).m_135815_().replaceAll("_", " "));
                }
                return super.m_5524_();
            }
        };
    }

    private static /* synthetic */ String lambda$new$21(com.zephaniahnoah.ezmodlib.util.Supplier stupidJava) {
        return ForgeRegistries.ITEMS.getKey((Object)((Item)stupidJava.get())).toString();
    }

    private static /* synthetic */ String lambda$new$20(com.zephaniahnoah.ezmodlib.util.Supplier rawOre) {
        return ForgeRegistries.ITEMS.getKey((Object)((Item)rawOre.get())).toString();
    }

    private static /* synthetic */ String lambda$new$19(com.zephaniahnoah.ezmodlib.util.Supplier stupidJava) {
        return ForgeRegistries.ITEMS.getKey((Object)((Item)stupidJava.get())).toString();
    }

    private static /* synthetic */ String lambda$new$18(com.zephaniahnoah.ezmodlib.util.Supplier rawOre) {
        return ForgeRegistries.ITEMS.getKey((Object)((Item)rawOre.get())).toString();
    }

    static {
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void onEntityDie(LivingDeathEvent e) {
                if (e.getEntity() instanceof EnderDragon) {
                    ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minersminerals:dragon_scale")));
                    Vec3 p = e.getEntity().m_20182_();
                    BlockPos blockPos = new BlockPos((int)Math.round(p.f_82479_), (int)Math.round(p.f_82480_), (int)Math.round(p.f_82481_));
                    Block.m_49840_((Level)e.getEntity().m_9236_(), (BlockPos)blockPos, (ItemStack)stack);
                }
            }

            @SubscribeEvent
            public void onServerTick(TickEvent.ServerTickEvent e) {
                if (Shuriken.ticks >= 600) {
                    for (ServerPlayer p : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                        for (ItemStack i : p.m_150109_().f_35974_) {
                            int count;
                            CompoundTag nbt;
                            if (!(i.m_41720_() instanceof Shuriken) || (nbt = i.m_41783_()) == null || !nbt.m_128441_("ShurikenCount") || (count = nbt.m_128451_("ShurikenCount")) >= 16) continue;
                            nbt.m_128405_("ShurikenCount", ++count);
                            i.m_41751_(nbt);
                        }
                    }
                    Shuriken.ticks = 0;
                }
                ++Shuriken.ticks;
            }
        });
    }
}

