/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.minersminerals;

import com.zephaniahnoah.ezmodlib.TagInjector;
import com.zephaniahnoah.ezmodlib.util.Supplier;
import com.zephaniahnoah.minersminerals.IMineralOre;
import com.zephaniahnoah.minersminerals.Main;
import com.zephaniahnoah.minersminerals.Ores;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public enum Mineral implements Tier,
ArmorMaterial,
IMineralOre
{
    RHODONITE(2, 350, 5.0f, 1.5f, 10, 0.0f, 0.0f, true, new int[]{2, 3, 3, 2}, 1, 1, -63, 62, 1, 64, Ores.defaultBlocks, null),
    JET(1, 350, 4.2f, 1.3f, 10, 0.0f, 0.0f, true, new int[]{1, 2, 3, 2}, 1, 1, 50, 200, 1, 64, Ores.defaultBlocks, null),
    SERPENTINE(2, 120, 5.5f, 1.8f, 10, 0.0f, 0.0f, true, new int[]{1, 2, 3, 2}, 1, 1, -63, 200, 1, 64, Ores.defaultBlocks, new TagKey[]{BiomeTags.f_207610_}),
    BLOOD_STONE(1, 350, 4.2f, 1.4f, 10, 0.0f, 0.0f, true, new int[]{1, 2, 3, 2}, 1, 1, -63, 200, 2, 64, new Block[]{Blocks.f_50134_}, new TagKey[]{BiomeTags.f_207612_}),
    CHAROITE(1, 750, 6.3f, 2.2f, 32, 1.0f, 0.2f, true, new int[]{3, 5, 6, 3}, 1, 1, 0, 80, 1, 64, new Block[]{Blocks.f_50259_}, new TagKey[]{BiomeTags.f_215818_}),
    SPACE_ROCK(2, 750, 7.3f, 2.6f, 42, 1.0f, 0.1f, true, new int[]{3, 5, 6, 3}, 1, 1, 0, 80, 1, 16, new Block[]{Blocks.f_50259_}, new TagKey[]{BiomeTags.f_215818_}),
    BRONZITE(1, 500, 4.0f, 1.5f, 22, 0.0f, 0.1f, true, new int[]{1, 2, 3, 1}, 1, 1, -63, -44, 1, 64, Ores.defaultBlocks, null),
    PETRIFIED_WOOD(1, 300, 6.4f, 2.6f, 30, 0.0f, 0.1f, true, new int[]{1, 2, 3, 2}, 0, 0, 0, 0, 0, 0, Ores.defaultBlocks, null),
    COPPER(1, 200, 4.7f, 1.5f, 10, 0.0f, 0.0f, false, new int[]{1, 2, 3, 2}, 0, 0, 0, 0, 0, 0, Ores.defaultBlocks, null),
    TIN(1, 120, 4.2f, 1.1f, 7, 0.0f, 0.0f, false, new int[]{1, 2, 3, 1}, 2, 4, 30, 63, 25, 10, Ores.defaultBlocks, null),
    ALUMINUM(1, 160, 5.6f, 1.6f, 9, 0.0f, 0.0f, false, new int[]{1, 2, 2, 1}, 1, 3, 30, 90, 44, 13, new Block[]{Blocks.f_50493_}, null),
    NICKEL(2, 225, 5.8f, 1.8f, 10, 0.0f, 0.0f, false, new int[]{1, 3, 4, 2}, 2, 4, 40, 65, 27, 8, Ores.defaultBlocks, null),
    BRASS(2, 240, 6.1f, 2.1f, 12, 0.0f, 0.0f, false, new int[]{1, 2, 4, 2}, 1, 1, 0, 0, 0, 0, Ores.defaultBlocks, null),
    BRONZE(2, 400, 6.2f, 2.2f, 13, 0.0f, 0.0f, false, new int[]{2, 4, 5, 3}, 1, 1, 0, 0, 0, 0, Ores.defaultBlocks, null),
    LEAD(2, 200, 6.1f, 2.1f, 8, 0.0f, 0.25f, false, new int[]{3, 5, 5, 3}, 1, 2, -10, 40, 35, 7, Ores.defaultBlocks, null),
    SILVER(2, 220, 6.4f, 2.3f, 16, 0.0f, 0.0f, false, new int[]{2, 5, 6, 3}, 1, 2, -30, 0, 21, 7, Ores.defaultBlocks, null),
    TITANIUM(3, 1100, 7.1f, 2.0f, 14, 0.0f, 0.0f, false, new int[]{3, 7, 9, 4}, 1, 1, -40, 5, 5, 4, Ores.defaultBlocks, null),
    TUNGSTEN(3, 900, 6.3f, 2.0f, 13, 0.0f, 0.1f, false, new int[]{3, 5, 6, 3}, 1, 2, -30, -10, 28, 7, Ores.defaultBlocks, null),
    PLATINUM(3, 900, 6.5f, 2.5f, 17, 0.0f, 0.0f, false, new int[]{3, 5, 7, 3}, 1, 2, -46, -20, 30, 5, Ores.defaultBlocks, null),
    ELECTRUM(2, 350, 5.0f, 2.4f, 25, 0.0f, 0.0f, false, new int[]{2, 5, 6, 2}, 1, 1, 20, 40, 13, 3, Ores.defaultBlocks, null),
    ADAMANTIUM(2, 430, 9.0f, 5.5f, 15, 0.0f, 0.05f, false, new int[]{4, 8, 10, 5}, 1, 1, -63, -44, 10, 3, new Supplier[]{Supplier.S(() -> ((RegistryObject)Main.baseMinerals.swap().get(BRONZITE)).getKey().m_135782_())}, null),
    OSMIUM(2, 350, 6.7f, 2.5f, 8, 0.0f, 0.05f, false, new int[]{1, 2, 3, 2}, 1, 1, -24, -26, 18, 6, Ores.defaultBlocks, null),
    STEEL(2, 400, 7.0f, 2.5f, 10, 0.0f, 0.0f, false, new int[]{2, 6, 7, 3}, 1, 1, 0, 0, 0, 0, Ores.defaultBlocks, null),
    PALLADIUM(3, 200, 8.5f, 3.5f, 12, 0.0f, 0.0f, false, new int[]{2, 4, 5, 2}, 1, 1, -50, -20, 9, 6, Ores.defaultBlocks, null),
    COBALT(3, 2350, 10.0f, 3.5f, 15, 2.0f, 0.1f, false, new int[]{4, 8, 10, 5}, 1, 1, -30, -6, 16, 4, new Block[]{Blocks.f_152496_}, null),
    MYTHRIL(4, 1350, 11.7f, 3.5f, 20, 1.0f, 0.1f, false, new int[]{3, 7, 9, 4}, 1, 1, -55, -35, 10, 4, Ores.defaultBlocks, null),
    ETHERIUM(2, 550, 4.7f, 3.5f, 17, 0.0f, 0.0f, false, new int[]{3, 7, 9, 4}, 1, 1, 0, 20, 15, 3, new ArrayList<ResourceLocation>(Arrays.asList(new ResourceLocation("minecraft:end_stone"), new ResourceLocation("minersminerals:charoite_block"), new ResourceLocation("minersminerals:space_rock_block"))), new TagKey[]{BiomeTags.f_215818_}),
    ORICHALCUM(3, 400, 8.7f, 2.5f, 30, 0.0f, 0.0f, false, new int[]{2, 6, 7, 3}, 1, 2, 120, 150, 7, 3, Ores.defaultBlocks, null),
    MAGNETITE(2, 350, 7.7f, 2.2f, 11, 0.0f, 0.0f, false, new int[]{2, 4, 6, 3}, 1, 2, 20, 200, 16, 6, Ores.defaultBlocks, null),
    BISMUTH(2, 225, 6.8f, 2.2f, 22, 0.0f, 0.0f, false, new int[]{2, 4, 6, 2}, 1, 4, 20, 65, 19, 7, Ores.defaultBlocks, null),
    SILICON(3, 230, 7.5f, 2.4f, 16, 0.0f, 0.0f, false, new int[]{3, 6, 7, 3}, 1, 2, -63, 0, 30, 22, new Block[]{Blocks.f_50493_, Blocks.f_49994_}, null),
    ZINC(2, 190, 5.0f, 1.6f, 6, 0.0f, 0.05f, false, new int[]{2, 4, 5, 2}, 1, 2, 20, 40, 25, 10, Ores.defaultBlocks, null),
    ANTIMONY(2, 175, 4.7f, 2.2f, 14, 0.0f, 0.0f, false, new int[]{3, 4, 5, 3}, 5, 15, -64, 150, 15, 1, Ores.defaultBlocks, null),
    URANIUM(3, 850, 6.3f, 2.2f, 22, 0.0f, 0.1f, false, new int[]{2, 5, 6, 2}, 1, 2, 24, 44, 23, 4, Ores.defaultBlocks, null),
    UNBIHEXIUM(2, 1050, 12.1f, 5.9f, 17, 0.0f, 0.1f, false, new int[]{4, 8, 10, 5}, 1, 1, 0, 60, 5, 1, new ArrayList<ResourceLocation>(Arrays.asList(new ResourceLocation("minecraft:end_stone"), new ResourceLocation("minersminerals:charoite_block"), new ResourceLocation("minersminerals:space_rock_block"))), new TagKey[]{BiomeTags.f_215818_}),
    HEDERAIUM(3, 1000, 7.3f, 4.5f, 33, 0.0f, 0.1f, false, new int[]{3, 4, 8, 3}, 1, 1, -42, 14, 15, 5, Ores.defaultBlocks, new TagKey[]{Tags.Biomes.IS_SWAMP}),
    SHROOMITE(3, 1100, 9.3f, 4.7f, 33, 1.0f, 0.1f, false, new int[]{3, 4, 8, 3}, 1, 1, -52, 64, 28, 5, Ores.defaultBlocks, new TagKey[]{Tags.Biomes.IS_MUSHROOM}),
    SPINEL(2, 1000, 8.3f, 3.2f, 10, 0.0f, 0.0f, true, new int[]{2, 5, 6, 3}, 1, 5, 30, 200, 11, 1, Ores.defaultBlocks, null),
    TOURMALINE(2, 750, 9.5f, 2.8f, 10, 0.0f, 0.0f, true, new int[]{3, 5, 7, 3}, 1, 2, -40, -10, 10, 3, Ores.defaultBlocks, null),
    TIGERS_EYE(2, 350, 6.5f, 1.9f, 22, 0.0f, 0.0f, true, new int[]{2, 5, 6, 3}, 1, 2, -63, 200, 30, 5, Ores.defaultBlocks, new TagKey[]{BiomeTags.f_215816_}),
    PERIDOT(2, 350, 6.1f, 2.1f, 10, 0.0f, 0.0f, true, new int[]{1, 2, 3, 2}, 1, 1, 0, 30, 28, 3, Ores.defaultBlocks, null),
    OPAL(1, 350, 5.8f, 2.3f, 26, 0.0f, 0.0f, true, new int[]{1, 2, 3, 2}, 1, 2, 50, 150, 40, 2, new Block[]{Blocks.f_50062_, Blocks.f_50394_, Blocks.f_50291_, Blocks.f_50299_, Blocks.f_50301_, Blocks.f_50287_, Blocks.f_50295_, Blocks.f_50288_}, new TagKey[]{Tags.Biomes.IS_DESERT, Tags.Biomes.IS_DRY_OVERWORLD}),
    JASPER(2, 450, 9.7f, 2.5f, 10, 0.0f, 0.0f, true, new int[]{1, 2, 3, 2}, 1, 1, 70, 80, 10, 3, Ores.defaultBlocks, null),
    SELENITE(2, 210, 4.5f, 1.6f, 22, 1.0f, 0.0f, true, new int[]{1, 2, 3, 1}, 1, 5, 10, 75, 25, 8, Ores.defaultBlocks, null),
    GARNET(2, 350, 5.7f, 2.5f, 25, 0.0f, 0.0f, true, new int[]{2, 4, 6, 2}, 1, 1, 0, 50, 30, 4, new Supplier[]{Supplier.S(() -> ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50134_)), Supplier.S(() -> ((RegistryObject)Main.baseMinerals.swap().get(BLOOD_STONE)).getKey().m_135782_())}, null),
    MOSS_AGATE(2, 750, 6.7f, 3.4f, 10, 0.0f, 0.0f, true, new int[]{1, 2, 3, 2}, 1, 1, -63, 0, 27, 6, Ores.defaultBlocks, new TagKey[]{BiomeTags.f_207610_}),
    JADE(1, 450, 5.1f, 1.7f, 10, 0.0f, 0.0f, true, new int[]{2, 4, 5, 3}, 1, 4, -63, 30, 45, 8, Ores.defaultBlocks, new TagKey[]{BiomeTags.f_207610_}),
    RUBY(2, 350, 6.4f, 2.5f, 10, 0.0f, 0.0f, true, new int[]{1, 2, 3, 2}, 1, 1, -63, -10, 27, 3, Ores.defaultBlocks, null),
    AMETHYST(2, 350, 5.7f, 2.5f, 10, 0.0f, 0.02f, true, new int[]{1, 2, 3, 2}, 1, 3, -20, 20, 15, 5, Ores.defaultBlocks, null),
    SAPPHIRE(2, 350, 6.7f, 2.4f, 10, 0.0f, 0.0f, true, new int[]{1, 2, 3, 2}, 1, 3, -10, 40, 37, 3, Ores.defaultBlocks, null),
    QUARTZ(2, 350, 5.8f, 1.8f, 9, 0.0f, 0.0f, true, new int[]{2, 3, 4, 2}, 1, 3, -20, 20, 20, 6, Ores.defaultBlocks, null),
    ZIRCON(2, 350, 5.7f, 2.9f, 10, 0.0f, 0.0f, true, new int[]{3, 4, 5, 3}, 1, 2, 20, 40, 29, 3, Ores.defaultBlocks, null),
    PRISMARINE(2, 350, 5.7f, 2.4f, 10, 0.0f, 0.0f, true, new int[]{1, 2, 3, 2}, 1, 1, 0, 200, 44, 3, Ores.defaultBlocks, new TagKey[]{BiomeTags.f_207603_}),
    SUNSTONE(2, 550, 7.7f, 2.2f, 10, 0.0f, 0.0f, true, new int[]{1, 2, 3, 2}, 1, 1, 115, 128, 10, 2, new Supplier[]{Supplier.S(() -> ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50134_)), Supplier.S(() -> ((RegistryObject)Main.baseMinerals.swap().get(BLOOD_STONE)).getKey().m_135782_())}, new TagKey[]{BiomeTags.f_207612_}),
    TOPAZ(2, 75, 6.1f, 2.1f, 10, 0.0f, 0.0f, true, new int[]{2, 4, 6, 2}, 1, 1, 0, 70, 13, 10, Ores.defaultBlocks, new TagKey[]{BiomeTags.f_207612_}),
    OLIVINE(3, 900, 6.4f, 2.6f, 10, 0.0f, 0.0f, true, new int[]{3, 5, 7, 3}, 1, 1, 0, 128, 30, 6, new Block[]{Blocks.f_50137_, Blocks.f_50730_}, null),
    AMBER(1, 125, 4.5f, 3.5f, 10, 0.0f, 0.0f, true, new int[]{1, 3, 4, 2}, 1, 3, 61, 80, 25, 2, new Block[]{Blocks.f_49992_, Blocks.f_49994_, Blocks.f_49993_}, new TagKey[]{BiomeTags.f_207604_}),
    SALT(1, 50, 2.5f, 0.5f, 10, 0.0f, 0.2f, true, new int[]{1, 2, 2, 1}, 1, 3, 61, 80, 25, 8, new Block[]{Blocks.f_49992_, Blocks.f_49994_, Blocks.f_49993_}, new TagKey[]{BiomeTags.f_207604_}),
    DEUTERIUM(3, 500, 7.2f, 3.5f, 10, 0.0f, 0.0f, true, new int[]{4, 5, 7, 4}, 1, 4, 30, 150, 25, 4, new Block[]{Blocks.f_50568_, Blocks.f_50354_}, new TagKey[]{Tags.Biomes.IS_COLD_OVERWORLD}),
    ONYX(2, 350, 6.7f, 2.4f, 10, 0.0f, 0.0f, true, new int[]{1, 2, 3, 2}, 1, 1, -63, 0, 15, 7, Ores.defaultBlocks, null);

    private final int level;
    private final int uses;
    private final int enchantmentValue;
    private final float speed;
    private final float damage;
    private final float toughness;
    private final float knockback;
    public boolean gem;
    private int[] slotProtections;
    public final String tag;
    private final Supplier<Ingredient> repairIngredient;
    public final int minDrops;
    public final int maxDrops;
    public final int minHeight;
    public final int maxHeight;
    public final int frequency;
    public final int size;
    public List<ResourceLocation> baseBlocks;
    private Supplier<?>[] baseBlocksUncooked;
    private TagKey<Biome>[] biomes;
    private Integer color;

    private Mineral(int level, int uses, float speed, float damage, int enchantability, float toughness, float knockback, boolean gem, int[] slotProtections, int minDrops, int maxDrops, int minHeight, int maxHeight, int freq, int size, Object baseBlocks, TagKey[] biomes) {
        this.level = level;
        this.uses = uses;
        this.speed = speed;
        this.damage = damage;
        this.enchantmentValue = enchantability;
        this.toughness = toughness;
        this.knockback = knockback;
        this.gem = gem;
        this.slotProtections = slotProtections;
        this.minDrops = minDrops;
        this.maxDrops = maxDrops;
        String tag = "forge:" + (gem ? "gems" : "ingots");
        TagInjector.items.inject(tag, Supplier.S(() -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minersminerals", this.getLowerName()))));
        this.tag = tag + "/" + this.m_6082_();
        this.repairIngredient = Supplier.S(() -> Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation(this.tag))));
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.frequency = freq;
        this.size = size;
        if (baseBlocks instanceof List) {
            this.baseBlocks = (List)baseBlocks;
        } else if (baseBlocks instanceof Block[]) {
            this.baseBlocks = new ArrayList<ResourceLocation>();
            for (Block b : (Block[])baseBlocks) {
                this.baseBlocks.add(ForgeRegistries.BLOCKS.getKey((Object)b));
            }
        } else {
            this.baseBlocksUncooked = (Supplier[])baseBlocks;
        }
        this.biomes = biomes;
    }

    public int getColor() {
        if (this.color == null) {
            this.color = this.generateColor();
        }
        return this.color;
    }

    public String getColorString() {
        return String.format("#%06X", 0xFFFFFF & this.getColor());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int generateColor() {
        String path = "assets/minersminerals/textures/block/" + this.getLowerName() + "_block.png";
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);){
            if (is == null) {
                int n2 = -1;
                return n2;
            }
            BufferedImage image = ImageIO.read(is);
            long sumRed = 0L;
            long sumGreen = 0L;
            long sumBlue = 0L;
            for (int x = 0; x < image.getWidth(); ++x) {
                int value;
                for (int y = 0; y < image.getHeight(); sumRed += (long)(value >> 16 & 0xFF), sumGreen += (long)(value >> 8 & 0xFF), sumBlue += (long)(value >> 0 & 0xFF), ++y) {
                    value = image.getRGB(x, y);
                }
            }
            int totalPixels = image.getWidth() * image.getHeight();
            int avgRed = (int)(sumRed / (long)totalPixels);
            int avgGreen = (int)(sumGreen / (long)totalPixels);
            int avgBlue = (int)(sumBlue / (long)totalPixels);
            int n = avgRed << 16 | avgGreen << 8 | avgBlue;
            return n;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteArrayInputStream generateTrimPaletteImage() {
        String texturePath = "assets/minersminerals/textures/block/" + this.getLowerName() + "_block.png";
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(texturePath);){
            BufferedImage image = ImageIO.read(is);
            HashSet<Integer> uniqueColors = new HashSet<Integer>();
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    int rgb = image.getRGB(x, y) & 0xFFFFFF;
                    uniqueColors.add(rgb);
                }
            }
            ArrayList sortedColors = new ArrayList(uniqueColors);
            sortedColors.sort((c1, c2) -> Double.compare(this.luminance((int)c2), this.luminance((int)c1)));
            int numColors = sortedColors.size();
            ArrayList<Integer> palette = new ArrayList<Integer>(8);
            for (int i = 0; i < 8; ++i) {
                double pos = (double)i / 7.0;
                int index = (int)Math.round(pos * (double)(numColors - 1));
                int color = (Integer)sortedColors.get(index) | 0xFF000000;
                palette.add(color);
            }
            BufferedImage paletteImage = new BufferedImage(8, 1, 2);
            for (int x = 0; x < 8; ++x) {
                paletteImage.setRGB(x, 0, (Integer)palette.get(x));
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (!ImageIO.write((RenderedImage)paletteImage, "PNG", baos)) return null;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private double luminance(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return 0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b;
    }

    public void cook() {
        if (this.baseBlocksUncooked != null) {
            this.baseBlocks = new ArrayList<ResourceLocation>();
            for (Supplier<?> s : this.baseBlocksUncooked) {
                this.baseBlocks.add((ResourceLocation)s.get());
            }
        }
    }

    public int m_6609_() {
        return this.uses;
    }

    public float m_6624_() {
        return this.speed;
    }

    public float m_6631_() {
        return this.damage;
    }

    public int m_6604_() {
        return this.level;
    }

    public String getToolTag() {
        String tool = "needs_stone_tool";
        if (this.level > 2) {
            tool = "needs_diamond_tool";
        }
        if (this.level == 2) {
            tool = "needs_iron_tool";
        }
        return "minecraft:" + tool;
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public int m_6601_() {
        return this.enchantmentValue;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.get();
    }

    public Ingredient m_6282_() {
        return this.m_6230_();
    }

    @Override
    public String getLowerName() {
        return this.name().toLowerCase();
    }

    public int m_266425_(ArmorItem.Type type) {
        float slot = 0.0f;
        switch (type.m_266308_()) {
            case FEET: {
                slot = 1.5f;
                break;
            }
            case LEGS: {
                slot = 1.625f;
                break;
            }
            case CHEST: {
                slot = 1.75f;
                break;
            }
            default: {
                slot = 1.625f;
            }
        }
        return Math.round(slot * (float)this.uses);
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.slotProtections[type.m_266308_().m_20749_()];
    }

    public SoundEvent m_7344_() {
        return SoundEvents.f_11677_;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockback;
    }

    @Override
    public TagKey<Biome>[] biomes() {
        return this.biomes;
    }

    public String m_6082_() {
        return this.getLowerName();
    }
}

