/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.minersminerals;

import com.google.common.collect.ImmutableMultimap;
import com.zephaniahnoah.minersminerals.Mineral;
import java.util.EnumMap;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class MineralArmor
extends ArmorItem {
    private static final EnumMap<ArmorItem.Type, UUID> ARMOR_MODIFIER_UUID_PER_TYPE = (EnumMap)ObfuscationReflectionHelper.getPrivateValue(ArmorItem.class, null, (String)"f_265987_");

    public MineralArmor(ArmorMaterial material, ArmorItem.Type type, Item.Properties itemProperties) {
        super(material, type, itemProperties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIER_UUID_PER_TYPE.get(type);
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)material.m_7366_(type), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)material.m_6651_(), AttributeModifier.Operation.ADDITION));
        if (this.f_40378_ > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)this.f_40378_, AttributeModifier.Operation.ADDITION));
        }
        if (material == Mineral.HEDERAIUM) {
            builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(uuid, "Max health", (double)(material.m_7366_(type) / 2), AttributeModifier.Operation.ADDITION));
        } else if (material == Mineral.LEAD || material == Mineral.TUNGSTEN) {
            builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Movement speed", -0.007, AttributeModifier.Operation.ADDITION));
        } else if (material == Mineral.SILVER || material == Mineral.ELECTRUM || material == Mineral.ETHERIUM) {
            builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Movement speed", 0.01, AttributeModifier.Operation.ADDITION));
        }
        ObfuscationReflectionHelper.setPrivateValue(ArmorItem.class, (Object)((Object)this), (Object)builder.build(), (String)"f_40383_");
    }
}

