/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.minersminerals;

import com.zephaniahnoah.ezmodlib.VirtualDatapack;
import com.zephaniahnoah.minersminerals.Main;
import com.zephaniahnoah.minersminerals.Mineral;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class WorldGen {
    private static final TagKey<Block> BASE_STONE_END = ForgeRegistries.BLOCKS.tags().createOptionalTagKey(new ResourceLocation("minecraft:base_stone_end"), Set.of(() -> Blocks.f_50259_));

    public static void init(IEventBus bus) {
        for (Map.Entry p : Main.baseMinerals.entrySet()) {
            Object v = p.getValue();
            if (!(v instanceof Mineral)) continue;
            Mineral m = (Mineral)v;
            Object dimension = BlockTags.f_144266_.f_203868_().toString() + "\"},\"state\":{\"Name\":\"" + String.valueOf(((RegistryObject)p.getKey()).getId()) + "\"}},{\"target\":{\"predicate_type\":\"minecraft:tag_match\",\"tag\":\"" + BlockTags.f_144267_.f_203868_().toString();
            if (m.baseBlocks.contains(Blocks.f_50134_.m_204297_().m_205785_().m_135782_())) {
                dimension = BlockTags.f_13062_.f_203868_().toString();
            } else if (m.baseBlocks.contains(Blocks.f_50259_.m_204297_().m_205785_().m_135782_())) {
                dimension = BASE_STONE_END.f_203868_().toString();
            }
            String cfg = m.getLowerName() + "_cfg";
            String filePath = "worldgen/configured_feature/" + cfg + ".json";
            String json = "{\n  \"type\": \"minecraft:ore\",\n  \"config\": {\n    \"size\": %s,\n    \"discard_chance_on_air_exposure\": 0.0,\n    \"targets\": [\n      {\n        \"target\": {\n          \"predicate_type\": \"minecraft:tag_match\",\n          \"tag\": \"%s\"\n        },\n        \"state\": {\n          \"Name\": \"%s\"\n        }\n      }\n    ]\n  }\n}\n".formatted(m.size, dimension, ((RegistryObject)p.getKey()).getId());
            VirtualDatapack.addFile((String)"worldgen/configured_feature", (String)"minersminerals", (String)filePath, (String)json);
            String plc = m.getLowerName() + "_plc";
            filePath = "worldgen/placed_feature/" + plc + ".json";
            json = "{\n  \"feature\": \"%s:%s\",\n  \"placement\": [\n    {\n      \"type\": \"minecraft:count\",\n      \"count\": %s\n    },\n    {\n      \"type\": \"minecraft:in_square\"\n    },\n    {\n      \"type\": \"minecraft:height_range\",\n      \"height\": {\n        \"type\": \"minecraft:uniform\",\n        \"min_inclusive\": {\n          \"absolute\": %s\n        },\n        \"max_inclusive\": {\n          \"absolute\": %s\n        }\n      }\n    },\n    {\n      \"type\": \"minecraft:biome\"\n    }\n  ]\n}\n".formatted("minersminerals", cfg, m.frequency, m.minHeight, m.maxHeight);
            VirtualDatapack.addFile((String)"worldgen/placed_feature", (String)"minersminerals", (String)filePath, (String)json);
            Object biomes = "#" + BiomeTags.f_215817_.f_203868_().toString();
            if (m.biomes() != null) {
                biomes = "";
                for (int i = 0; i < m.biomes().length; ++i) {
                    biomes = (String)biomes + "#" + String.valueOf(m.biomes()[i].f_203868_());
                    if (i == m.biomes().length - 1) continue;
                    biomes = (String)biomes + "\",\"";
                }
            }
            filePath = "forge/biome_modifier/" + m.getLowerName() + ".json";
            json = "{\n  \"type\": \"forge:add_features\",\n  \"biomes\": \"%s\",\n  \"features\": \"%s:%s\",\n  \"step\": \"underground_ores\"\n}\n".formatted(biomes, "minersminerals", plc);
            VirtualDatapack.addFile((String)"forge/biome_modifier", (String)"minersminerals", (String)filePath, (String)json);
        }
    }
}

