/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.minersminerals.extras.spear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.zephaniahnoah.minersminerals.Main;
import com.zephaniahnoah.minersminerals.extras.spear.SpearEntity;
import java.util.Arrays;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.ForgeRegistries;

public class Spear
extends TridentItem {
    private static final List<Enchantment> enchants = Arrays.asList(Enchantments.f_44986_, Enchantments.f_44955_, Enchantments.f_44962_, Enchantments.f_44989_, Enchantments.f_44980_, Enchantments.f_44981_, Enchantments.f_44990_);
    public static final String prismarine = "prismarine_spear";
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    public final Tier tier;

    public Spear(Tier mineral, Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)mineral.m_6631_() + 2.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.9f, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(Main.ENTITY_REACH_UUID, "Weapon modifier", 1.0, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
        this.tier = mineral;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity entityAttacked, LivingEntity attacker) {
        Main.tryEffect(this.tier, entityAttacked);
        return super.m_7579_(itemStack, entityAttacked, attacker);
    }

    public void m_5551_(ItemStack spearItemStack, Level world, LivingEntity playerEntity, int use) {
        if (playerEntity instanceof Player) {
            int j;
            Player player = (Player)playerEntity;
            int i = this.m_8105_(spearItemStack) - use;
            if (i >= 10 && ((j = EnchantmentHelper.m_44932_((ItemStack)spearItemStack)) <= 0 || player.m_20070_())) {
                if (!world.f_46443_) {
                    spearItemStack.m_41622_(1, (LivingEntity)player, plr -> plr.m_21190_(playerEntity.m_7655_()));
                    if (j == 0) {
                        int k;
                        SpearEntity spearEntity = new SpearEntity(world, (LivingEntity)player, spearItemStack);
                        spearEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f + (float)j * 0.5f, 1.0f);
                        if (player.m_150110_().f_35937_) {
                            spearEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)spearItemStack)) > 0) {
                            spearEntity.m_36735_(k);
                        }
                        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)spearItemStack) > 0) {
                            spearEntity.m_20254_(100);
                        }
                        world.m_7967_((Entity)spearEntity);
                        world.m_6269_((Player)null, (Entity)spearEntity, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!player.m_150110_().f_35937_) {
                            player.m_150109_().m_36057_(spearItemStack);
                        }
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (j > 0) {
                    float f7 = player.m_146908_();
                    float f = player.m_146909_();
                    float f1 = -Mth.m_14031_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f2 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
                    float f3 = Mth.m_14089_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f4 = Mth.m_14116_((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 3.0f * ((1.0f + (float)j) / 4.0f);
                    player.m_5997_((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
                    player.m_204079_(20);
                    if (player.m_20096_()) {
                        player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    SoundEvent soundevent = j >= 3 ? SoundEvents.f_12519_ : (j == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                    world.m_6269_((Player)null, (Entity)player, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment ench) {
        if (ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_().equals(prismarine)) {
            return ench.f_44672_.m_7454_(stack.m_41720_());
        }
        return enchants.contains(ench);
    }

    public int m_6473_() {
        return this.tier.m_6601_();
    }

    public boolean m_6832_(ItemStack item1, ItemStack item2) {
        return this.tier.m_6282_().test(item2) || super.m_6832_(item1, item2);
    }
}

