/*
 * Decompiled with CFR 0.152.
 */
package com.zephaniahnoah.minersminerals.extras.spear;

import com.zephaniahnoah.minersminerals.Main;
import com.zephaniahnoah.minersminerals.Mineral;
import com.zephaniahnoah.minersminerals.extras.spear.Spear;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class SpearEntity
extends ThrownTrident {
    private static final String defaultSpear = "copper_spear";
    private static final EntityDataAccessor<Byte> ID_LOYALTY = (EntityDataAccessor)ObfuscationReflectionHelper.getPrivateValue(ThrownTrident.class, null, (String)"f_37558_");
    private static final EntityDataAccessor<Boolean> ID_FOIL = (EntityDataAccessor)ObfuscationReflectionHelper.getPrivateValue(ThrownTrident.class, null, (String)"f_37554_");
    private static final EntityDataAccessor<String> ITEM = SynchedEntityData.m_135353_(SpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static RegistryObject spearType;
    private String cacheNameLookup = null;
    private ItemStack stack = null;

    public SpearEntity(EntityType<?> spear, Level world) {
        super(spear, world);
    }

    public SpearEntity(Level world, LivingEntity thrower, ItemStack spear) {
        super((EntityType)spearType.get(), world);
        this.m_5602_((Entity)thrower);
        this.m_6034_(thrower.m_20185_(), thrower.m_20188_() - (double)0.1f, thrower.m_20189_());
        ObfuscationReflectionHelper.setPrivateValue(ThrownTrident.class, (Object)((Object)this), (Object)spear, (String)"f_37555_");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)spear)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)spear.m_41790_());
        this.f_19804_.m_135381_(ITEM, (Object)this.spearName(spear));
        this.stack = spear;
    }

    private String spearName(ItemStack spear) {
        return ForgeRegistries.ITEMS.getKey((Object)spear.m_41720_()).m_135815_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ITEM, (Object)defaultSpear);
    }

    public ItemStack getItemStack() {
        if (this.stack == null) {
            this.stack = new ItemStack((ItemLike)Main.spears.get(this.f_19804_.m_135370_(ITEM)).get());
        }
        return this.stack;
    }

    protected void m_5790_(EntityHitResult result) {
        float f;
        Entity entity = result.m_82443_();
        ItemStack spear = this.m_7941_();
        if (spear.m_41720_() instanceof Spear) {
            Spear item = (Spear)spear.m_41720_();
            f = item.tier.m_6631_();
        } else {
            f = 2.5f;
        }
        f += 3.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)spear, (MobType)livingentity.m_6336_());
        }
        boolean flag = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (this.m_6060_() && !flag) {
            entity.m_20254_(5);
        }
        Entity entity1 = this.m_19749_();
        DamageSource damagesource = this.m_269291_().m_269525_((Entity)this, (Entity)(entity1 == null ? this : entity1));
        ObfuscationReflectionHelper.setPrivateValue(ThrownTrident.class, (Object)((Object)this), (Object)true, (String)"f_37556_");
        SoundEvent soundevent = SoundEvents.f_12514_;
        if (entity.m_6469_(damagesource, f)) {
            Vec3 vector3d;
            if (flag) {
                return;
            }
            int knockback = (Integer)ObfuscationReflectionHelper.getPrivateValue(AbstractArrow.class, (Object)((Object)this), (String)"f_36699_");
            if (knockback > 0 && (vector3d = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)knockback * 0.6)).m_82556_() > 0.0) {
                entity.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                    Main.tryEffect(((Spear)this.getItemStack().m_41720_()).tier, livingentity1);
                }
                this.m_7761_(livingentity1);
            }
        } else {
            entity.m_7311_(k);
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        boolean electrum = false;
        if (this.m_9236_() instanceof ServerLevel && (this.m_9236_().m_46470_() && EnchantmentHelper.m_44936_((ItemStack)spear) || (electrum = ((Spear)this.getItemStack().m_41720_()).tier == Mineral.ELECTRUM))) {
            BlockPos blockpos = entity.m_20183_();
            if (this.m_9236_().m_45527_(blockpos) || electrum) {
                LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                lightningboltentity.m_20219_(Vec3.m_82539_((Vec3i)blockpos));
                lightningboltentity.m_20879_(entity1 instanceof ServerPlayer ? (ServerPlayer)entity1 : null);
                this.m_9236_().m_7967_((Entity)lightningboltentity);
                soundevent = SoundEvents.f_12521_;
                f1 = 5.0f;
            }
        }
        this.m_5496_(soundevent, f1, 1.0f);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(ITEM, (Object)nbt.m_128461_("Spear"));
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("Spear", this.spearName(this.m_7941_()));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_6882_() {
        if (this.cacheNameLookup == null) {
            this.cacheNameLookup = (String)this.f_19804_.m_135370_(ITEM);
        }
        return this.cacheNameLookup.equals("prismarine_spear") ? super.m_6882_() : 0.6f;
    }
}

