/*
 * Decompiled with CFR 0.152.
 */
package com.grokchat;

import com.grokchat.api.GrokApiClient;
import com.grokchat.commands.GrokChatCommand;
import com.grokchat.commands.GrokChatTabCompleter;
import com.grokchat.commands.GrokCommand;
import com.grokchat.commands.GrokTabCompleter;
import com.grokchat.listeners.ChatListener;
import com.grokchat.managers.ChatHistoryManager;
import com.grokchat.managers.ConfigManager;
import com.grokchat.managers.CooldownManager;
import com.grokchat.managers.RateLimitManager;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GrokChatPlugin
extends JavaPlugin {
    private static GrokChatPlugin instance;
    private ConfigManager configManager;
    private GrokApiClient grokApiClient;
    private CooldownManager cooldownManager;
    private RateLimitManager rateLimitManager;
    private ChatHistoryManager chatHistoryManager;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        this.cooldownManager = new CooldownManager(this);
        this.rateLimitManager = new RateLimitManager(this);
        this.chatHistoryManager = new ChatHistoryManager(this);
        try {
            this.grokApiClient = new GrokApiClient(this);
            if (!this.configManager.isApiKeyValid()) {
                this.getLogger().warning("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                this.getLogger().warning("  API key not configured!");
                this.getLogger().warning("  Please set your xAI API key in config.yml");
                this.getLogger().warning("  Get your key at: https://console.x.ai/");
                this.getLogger().warning("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize Grok API client", e);
        }
        if (this.configManager.isMentionsEnabled()) {
            this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        }
        if (this.configManager.isCommandEnabled()) {
            this.getCommand("grok").setExecutor((CommandExecutor)new GrokCommand(this));
            this.getCommand("grok").setTabCompleter((TabCompleter)new GrokTabCompleter(this));
        }
        this.getCommand("grokchat").setExecutor((CommandExecutor)new GrokChatCommand(this));
        this.getCommand("grokchat").setTabCompleter((TabCompleter)new GrokChatTabCompleter(this));
        this.getLogger().info("GrokChat has been enabled!");
        this.getLogger().info("Mention prefix: " + this.configManager.getMentionPrefix());
    }

    public void onDisable() {
        if (this.grokApiClient != null) {
            this.grokApiClient.shutdown();
        }
        this.getLogger().info("GrokChat has been disabled!");
    }

    public void reload() {
        this.reloadConfig();
        this.configManager = new ConfigManager(this);
        this.cooldownManager = new CooldownManager(this);
        this.rateLimitManager = new RateLimitManager(this);
        this.chatHistoryManager = new ChatHistoryManager(this);
        if (this.grokApiClient != null) {
            this.grokApiClient.shutdown();
        }
        this.grokApiClient = new GrokApiClient(this);
        this.getLogger().info("GrokChat configuration reloaded!");
    }

    public static GrokChatPlugin getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public GrokApiClient getGrokApiClient() {
        return this.grokApiClient;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public RateLimitManager getRateLimitManager() {
        return this.rateLimitManager;
    }

    public ChatHistoryManager getChatHistoryManager() {
        return this.chatHistoryManager;
    }
}

