/*
 * Decompiled with CFR 0.152.
 */
package com.grokchat.api;

import com.grokchat.GrokChatPlugin;
import com.grokchat.libs.gson.Gson;
import com.grokchat.libs.gson.JsonArray;
import com.grokchat.libs.gson.JsonObject;
import com.grokchat.libs.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;

public class GrokApiClient {
    private final GrokChatPlugin plugin;
    private final Gson gson;
    private final ExecutorService executor;

    public GrokApiClient(GrokChatPlugin plugin) {
        this.plugin = plugin;
        this.gson = new Gson();
        this.executor = Executors.newFixedThreadPool(4);
    }

    public CompletableFuture<String> sendMessage(String message, String playerName) {
        return this.sendMessage(message, playerName, null, null);
    }

    public CompletableFuture<String> sendMessage(String message, String playerName, String chatContext) {
        return this.sendMessage(message, playerName, chatContext, null);
    }

    public CompletableFuture<String> sendMessage(String message, String playerName, String chatContext, String playerData) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonObject request = this.buildRequest(message, playerName, chatContext, playerData);
                if (this.plugin.getConfigManager().isDebug()) {
                    this.plugin.getLogger().info("Request: " + this.gson.toJson(request));
                }
                String response = this.sendHttpRequest(request);
                if (this.plugin.getConfigManager().isDebug()) {
                    this.plugin.getLogger().info("Response: " + response);
                }
                return this.parseResponse(response);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error calling Grok API", e);
                return "Sorry, I encountered an error processing your request: " + e.getMessage();
            }
        }, this.executor);
    }

    private JsonObject buildRequest(String message, String playerName, String chatContext, String playerData) {
        JsonObject request = new JsonObject();
        request.addProperty("model", this.plugin.getConfigManager().getModel());
        JsonArray messages = new JsonArray();
        JsonObject systemMsg = new JsonObject();
        systemMsg.addProperty("role", "system");
        Object systemPrompt = this.plugin.getConfigManager().getSystemPrompt().replace("{player}", playerName);
        if (chatContext != null && !chatContext.isEmpty()) {
            systemPrompt = (String)systemPrompt + "\n\n" + chatContext;
        }
        if (playerData != null && !playerData.isEmpty()) {
            systemPrompt = (String)systemPrompt + "\n\n" + playerData;
        }
        systemMsg.addProperty("content", (String)systemPrompt);
        messages.add(systemMsg);
        JsonObject userMsg = new JsonObject();
        userMsg.addProperty("role", "user");
        userMsg.addProperty("content", message);
        messages.add(userMsg);
        request.add("messages", messages);
        request.addProperty("temperature", this.plugin.getConfigManager().getTemperature());
        request.addProperty("max_tokens", this.plugin.getConfigManager().getMaxTokens());
        request.addProperty("stream", false);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendHttpRequest(JsonObject request) throws Exception {
        URL url = URI.create(this.plugin.getConfigManager().getApiEndpoint()).toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + this.plugin.getConfigManager().getApiKey());
            conn.setDoOutput(true);
            conn.setConnectTimeout(this.plugin.getConfigManager().getTimeout() * 1000);
            conn.setReadTimeout(this.plugin.getConfigManager().getTimeout() * 1000);
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = this.gson.toJson(request).getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                throw new Exception("API returned error code: " + responseCode);
            }
            StringBuilder response = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    response.append(line);
                }
            }
            String string = response.toString();
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    private String parseResponse(String jsonResponse) throws Exception {
        JsonObject response = JsonParser.parseString(jsonResponse).getAsJsonObject();
        JsonArray choices = response.getAsJsonArray("choices");
        if (choices == null || choices.size() == 0) {
            throw new Exception("No response from Grok");
        }
        JsonObject firstChoice = choices.get(0).getAsJsonObject();
        JsonObject message = firstChoice.getAsJsonObject("message");
        String content = message.get("content").getAsString();
        if (this.plugin.getConfigManager().isDebug() && response.has("usage")) {
            JsonObject usage = response.getAsJsonObject("usage");
            this.plugin.getLogger().info("Tokens used - Prompt: " + String.valueOf(usage.get("prompt_tokens")) + ", Completion: " + String.valueOf(usage.get("completion_tokens")) + ", Total: " + String.valueOf(usage.get("total_tokens")));
        }
        return content;
    }

    public void shutdown() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }
}

