/*
 * Decompiled with CFR 0.152.
 */
package com.grokchat.commands;

import com.grokchat.GrokChatPlugin;
import java.util.concurrent.CompletableFuture;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GrokChatCommand
implements CommandExecutor {
    private final GrokChatPlugin plugin;

    public GrokChatCommand(GrokChatPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("grokchat.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "info": {
                this.handleInfo(sender);
                break;
            }
            case "setkey": {
                this.handleSetKey(sender, args);
                break;
            }
            case "test": {
                this.handleTest(sender);
                break;
            }
            case "stats": {
                this.handleStats(sender, args);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== GrokChat Admin Commands ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/grokchat reload " + String.valueOf(ChatColor.GRAY) + "- Reload configuration");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/grokchat info " + String.valueOf(ChatColor.GRAY) + "- Show plugin information");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/grokchat setkey <key> " + String.valueOf(ChatColor.GRAY) + "- Set API key");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/grokchat test " + String.valueOf(ChatColor.GRAY) + "- Test API connection");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/grokchat stats [player] " + String.valueOf(ChatColor.GRAY) + "- View usage statistics");
    }

    private void handleReload(CommandSender sender) {
        try {
            this.plugin.reload();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2713 GrokChat configuration reloaded!");
            if (!this.plugin.getConfigManager().isApiKeyValid()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "\u26a0 Warning: API key is not configured!");
            }
        }
        catch (Exception e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Error reloading configuration: " + e.getMessage());
            this.plugin.getLogger().severe("Error reloading: " + e.getMessage());
        }
    }

    private void handleInfo(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== GrokChat Information ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Version: " + String.valueOf(ChatColor.WHITE) + this.plugin.getDescription().getVersion());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Model: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfigManager().getModel());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "API Status: " + String.valueOf(ChatColor.WHITE) + (this.plugin.getConfigManager().isApiKeyValid() ? String.valueOf(ChatColor.GREEN) + "\u2713 Configured" : String.valueOf(ChatColor.RED) + "\u2717 Not Configured"));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Mention Prefix: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfigManager().getMentionPrefix());
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Command Enabled: " + String.valueOf(ChatColor.WHITE) + (this.plugin.getConfigManager().isCommandEnabled() ? "Yes" : "No"));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Mentions Enabled: " + String.valueOf(ChatColor.WHITE) + (this.plugin.getConfigManager().isMentionsEnabled() ? "Yes" : "No"));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Rate Limit: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfigManager().getMaxRequestsPerHour() + " requests/hour");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Cooldown: " + String.valueOf(ChatColor.WHITE) + this.plugin.getConfigManager().getCooldown() + " seconds");
    }

    private void handleSetKey(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /grokchat setkey <api-key>");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Get your API key at: https://console.x.ai/");
            return;
        }
        String apiKey = args[1];
        this.plugin.getConfig().set("api.key", (Object)apiKey);
        this.plugin.saveConfig();
        this.plugin.reload();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2713 API key has been set and configuration reloaded!");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Use /grokchat test to verify the connection.");
    }

    private void handleTest(CommandSender sender) {
        if (!this.plugin.getConfigManager().isApiKeyValid()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "API key is not configured!");
            return;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Testing API connection...");
        ((CompletableFuture)this.plugin.getGrokApiClient().sendMessage("Respond with just 'OK' if you can hear me.", "ServerAdmin").thenAccept(response -> this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "\u2713 API connection successful!");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Response: " + response);
        }))).exceptionally(throwable -> {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "\u2717 API connection failed!");
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Error: " + throwable.getMessage());
            });
            return null;
        });
    }

    private void handleStats(CommandSender sender, String[] args) {
        if (args.length < 2) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.showPlayerStats(sender, player);
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /grokchat stats <player>");
            }
        } else {
            Player target = this.plugin.getServer().getPlayer(args[1]);
            if (target == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
                return;
            }
            this.showPlayerStats(sender, target);
        }
    }

    private void showPlayerStats(CommandSender sender, Player player) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "=== Grok Stats for " + player.getName() + " ===");
        int remaining = this.plugin.getRateLimitManager().getRemainingRequests(player);
        int max = this.plugin.getConfigManager().getMaxRequestsPerHour();
        int used = max - remaining;
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Requests Used: " + String.valueOf(ChatColor.WHITE) + used + "/" + max);
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Requests Remaining: " + String.valueOf(ChatColor.WHITE) + remaining);
        if (this.plugin.getCooldownManager().isOnCooldown(player)) {
            long cooldown = this.plugin.getCooldownManager().getRemainingCooldown(player);
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Cooldown: " + String.valueOf(ChatColor.WHITE) + cooldown + " seconds");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Cooldown: " + String.valueOf(ChatColor.GREEN) + "Ready");
        }
    }
}

