/*
 * Decompiled with CFR 0.152.
 */
package com.grokchat.commands;

import com.grokchat.GrokChatPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class GrokChatTabCompleter
implements TabCompleter {
    private final GrokChatPlugin plugin;

    public GrokChatTabCompleter(GrokChatPlugin plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        List<String> completions = new ArrayList<String>();
        if (!sender.hasPermission("grokchat.admin")) {
            return completions;
        }
        if (args.length == 1) {
            List<String> subcommands = Arrays.asList("reload", "info", "setkey", "test", "stats");
            String input = args[0].toLowerCase();
            completions = subcommands.stream().filter(sub -> sub.startsWith(input)).collect(Collectors.toList());
        } else if (args.length == 2 && args[0].equalsIgnoreCase("stats")) {
            completions = this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        } else if (args.length == 2 && args[0].equalsIgnoreCase("setkey")) {
            completions.add("<api-key>");
        }
        return completions;
    }
}

