/*
 * Decompiled with CFR 0.152.
 */
package com.grokchat.commands;

import com.grokchat.GrokChatPlugin;
import com.grokchat.utils.MessageUtils;
import java.util.concurrent.CompletableFuture;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GrokCommand
implements CommandExecutor {
    private final GrokChatPlugin plugin;

    public GrokCommand(GrokChatPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("grokchat.command")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            return true;
        }
        if (!this.plugin.getConfigManager().isCommandEnabled()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "The /grok command is currently disabled.");
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /grok <your question>");
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "Example: /grok How do I make a diamond pickaxe?");
            return true;
        }
        String question = String.join((CharSequence)" ", args);
        if (question.length() > this.plugin.getConfigManager().getMaxMessageLength()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Your message is too long! Maximum " + this.plugin.getConfigManager().getMaxMessageLength() + " characters.");
            return true;
        }
        if (this.plugin.getCooldownManager().isOnCooldown(player)) {
            long remaining = this.plugin.getCooldownManager().getRemainingCooldown(player);
            player.sendMessage(String.valueOf(ChatColor.RED) + "Please wait " + remaining + " seconds before asking again.");
            return true;
        }
        if (!this.plugin.getRateLimitManager().canMakeRequest(player)) {
            int remaining = this.plugin.getRateLimitManager().getRemainingRequests(player);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You've reached your hourly limit. Requests remaining: " + remaining);
            return true;
        }
        if (!this.plugin.getConfigManager().isApiKeyValid()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Grok is not configured. Please contact an administrator.");
            return true;
        }
        if (this.plugin.getConfigManager().isLogQueries()) {
            this.plugin.getLogger().info(player.getName() + " asked Grok: " + question);
        }
        this.plugin.getCooldownManager().setCooldown(player);
        this.plugin.getRateLimitManager().recordRequest(player);
        if (this.plugin.getConfigManager().isShowThinking()) {
            player.sendMessage(MessageUtils.colorize(this.plugin.getConfigManager().getThinkingMessage()));
        }
        ((CompletableFuture)this.plugin.getGrokApiClient().sendMessage(question, player.getName()).thenAccept(response -> this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            MessageUtils.sendGrokResponse(player, response, this.plugin);
            if (this.plugin.getConfigManager().isLogQueries()) {
                this.plugin.getLogger().info("Grok responded to " + player.getName() + ": " + response);
            }
        }))).exceptionally(throwable -> {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(String.valueOf(ChatColor.RED) + "Error: " + throwable.getMessage()));
            return null;
        });
        return true;
    }
}

