/*
 * Decompiled with CFR 0.152.
 */
package com.grokchat.commands;

import com.grokchat.GrokChatPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class GrokTabCompleter
implements TabCompleter {
    private final GrokChatPlugin plugin;

    public GrokTabCompleter(GrokChatPlugin plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        List<String> completions = new ArrayList<String>();
        if (!sender.hasPermission("grokchat.command")) {
            return completions;
        }
        if (args.length == 1) {
            List<String> suggestions = Arrays.asList("how", "what", "where", "when", "why", "can", "help");
            String input = args[0].toLowerCase();
            completions = suggestions.stream().filter(word -> word.startsWith(input)).collect(Collectors.toList());
        } else if (args.length == 2) {
            List<String> minecraftTerms = Arrays.asList("do", "I", "make", "craft", "find", "get", "build", "enchant", "mine", "farm");
            String input = args[1].toLowerCase();
            completions = minecraftTerms.stream().filter(word -> word.startsWith(input)).collect(Collectors.toList());
        } else if (args.length == 3) {
            List<String> commonItems = Arrays.asList("diamonds", "iron", "gold", "netherite", "enchantment", "beacon", "farm", "base", "redstone", "sword", "pickaxe", "armor", "food");
            String input = args[2].toLowerCase();
            completions = commonItems.stream().filter(word -> word.startsWith(input)).collect(Collectors.toList());
        }
        return completions;
    }
}

