/*
 * Decompiled with CFR 0.152.
 */
package com.grokchat.listeners;

import com.grokchat.GrokChatPlugin;
import com.grokchat.utils.MessageUtils;
import com.grokchat.utils.PlayerDataUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatListener
implements Listener {
    private final GrokChatPlugin plugin;

    public ChatListener(GrokChatPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        String messageLower = message.toLowerCase();
        this.plugin.getChatHistoryManager().addMessage(player, message);
        if (!player.hasPermission("grokchat.use")) {
            return;
        }
        String prefix = this.plugin.getConfigManager().getMentionPrefix();
        boolean isDirectMention = messageLower.contains(prefix.toLowerCase());
        boolean isAutoResponse = false;
        String question = null;
        if (isDirectMention) {
            question = message.replaceFirst("(?i)" + prefix, "").trim();
            if (question.isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: " + prefix + " <your question>");
                return;
            }
        } else if (this.plugin.getConfigManager().isAutoResponseEnabled()) {
            String[] words = message.trim().split("\\s+");
            if (words.length < this.plugin.getConfigManager().getAutoResponseMinWords()) {
                return;
            }
            List<String> keywords = this.plugin.getConfigManager().getAutoResponseKeywords();
            if (keywords == null || keywords.isEmpty()) {
                return;
            }
            for (String keyword : keywords) {
                if (!messageLower.contains(keyword.toLowerCase())) continue;
                isAutoResponse = true;
                question = message;
                break;
            }
            if (!isAutoResponse) {
                return;
            }
        } else {
            return;
        }
        if (question.length() > this.plugin.getConfigManager().getMaxMessageLength()) {
            if (!isAutoResponse) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Your message is too long! Maximum " + this.plugin.getConfigManager().getMaxMessageLength() + " characters.");
            }
            return;
        }
        if (this.plugin.getCooldownManager().isOnCooldown(player)) {
            if (!isAutoResponse) {
                long remaining = this.plugin.getCooldownManager().getRemainingCooldown(player);
                player.sendMessage(String.valueOf(ChatColor.RED) + "Please wait " + remaining + " seconds before asking again.");
            }
            return;
        }
        if (!this.plugin.getRateLimitManager().canMakeRequest(player)) {
            if (!isAutoResponse) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You've reached your hourly limit. Please try again later.");
            }
            return;
        }
        if (!this.plugin.getConfigManager().isApiKeyValid()) {
            if (!isAutoResponse) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Grok is not configured. Please contact an administrator.");
            }
            return;
        }
        if (this.plugin.getConfigManager().isLogQueries()) {
            String logType = isAutoResponse ? "auto-response" : "direct mention";
            this.plugin.getLogger().info(player.getName() + " triggered Grok (" + logType + "): " + question);
        }
        this.plugin.getCooldownManager().setCooldown(player);
        this.plugin.getRateLimitManager().recordRequest(player);
        if (!isAutoResponse && this.plugin.getConfigManager().isShowThinking()) {
            player.sendMessage(MessageUtils.colorize(this.plugin.getConfigManager().getThinkingMessage()));
        }
        String chatContext = null;
        if (isAutoResponse && this.plugin.getConfigManager().useHistoryInAutoResponse() || !isAutoResponse && this.plugin.getConfigManager().useHistoryInDirectMention()) {
            chatContext = this.plugin.getChatHistoryManager().getHistoryContext();
        }
        String finalQuestion = question;
        boolean finalIsAutoResponse = isAutoResponse;
        String finalChatContext = chatContext;
        boolean playerDataEnabled = this.plugin.getConfigManager().isPlayerDataEnabled();
        boolean useInAutoResponse = this.plugin.getConfigManager().usePlayerDataInAutoResponse();
        boolean useInDirectMention = this.plugin.getConfigManager().usePlayerDataInDirectMention();
        if (this.plugin.getConfigManager().isDebug()) {
            this.plugin.getLogger().info("[ChatListener] Player data check - Enabled: " + playerDataEnabled + ", IsAutoResponse: " + isAutoResponse + ", UseInAutoResponse: " + useInAutoResponse + ", UseInDirectMention: " + useInDirectMention);
        }
        if (playerDataEnabled && (isAutoResponse && useInAutoResponse || !isAutoResponse && useInDirectMention)) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                String playerDataContext = PlayerDataUtils.getPlayerDataContext(player, this.plugin);
                if (this.plugin.getConfigManager().isDebug()) {
                    this.plugin.getLogger().info("[ChatListener] Player data context:\n" + playerDataContext);
                }
                ((CompletableFuture)this.plugin.getGrokApiClient().sendMessage(finalQuestion, player.getName(), finalChatContext, playerDataContext).thenAccept(response -> this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (finalIsAutoResponse) {
                        MessageUtils.sendGrokResponseToAll(this.plugin, response);
                    } else {
                        MessageUtils.sendGrokResponse(player, response, this.plugin);
                    }
                    if (this.plugin.getConfigManager().isLogQueries()) {
                        this.plugin.getLogger().info("Grok responded: " + response);
                    }
                }))).exceptionally(throwable -> {
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                        if (!finalIsAutoResponse) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + "Error: " + throwable.getMessage());
                        }
                    });
                    return null;
                });
            });
        } else {
            if (this.plugin.getConfigManager().isDebug()) {
                String reason = !playerDataEnabled ? "Player data disabled" : (isAutoResponse ? "Auto-response disabled for player data" : "Direct mention disabled for player data");
                this.plugin.getLogger().info("[ChatListener] Skipping player data - " + reason);
            }
            ((CompletableFuture)this.plugin.getGrokApiClient().sendMessage(finalQuestion, player.getName(), finalChatContext, null).thenAccept(response -> this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                if (finalIsAutoResponse) {
                    MessageUtils.sendGrokResponseToAll(this.plugin, response);
                } else {
                    MessageUtils.sendGrokResponse(player, response, this.plugin);
                }
                if (this.plugin.getConfigManager().isLogQueries()) {
                    this.plugin.getLogger().info("Grok responded: " + response);
                }
            }))).exceptionally(throwable -> {
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (!finalIsAutoResponse) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Error: " + throwable.getMessage());
                    }
                });
                return null;
            });
        }
    }
}

