/*
 * Decompiled with CFR 0.152.
 */
package com.grokchat.managers;

import com.grokchat.GrokChatPlugin;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.entity.Player;

public class ChatHistoryManager {
    private final GrokChatPlugin plugin;
    private final LinkedList<ChatMessage> globalHistory;
    private final int maxHistorySize;

    public ChatHistoryManager(GrokChatPlugin plugin) {
        this.plugin = plugin;
        this.maxHistorySize = plugin.getConfigManager().getChatHistorySize();
        this.globalHistory = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(Player player, String message) {
        if (!this.plugin.getConfigManager().isChatHistoryEnabled()) {
            return;
        }
        ChatMessage chatMessage = new ChatMessage(player.getName(), message, System.currentTimeMillis());
        LinkedList<ChatMessage> linkedList = this.globalHistory;
        synchronized (linkedList) {
            this.globalHistory.addLast(chatMessage);
            while (this.globalHistory.size() > this.maxHistorySize) {
                this.globalHistory.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHistoryContext() {
        if (!this.plugin.getConfigManager().isChatHistoryEnabled()) {
            return "";
        }
        LinkedList<ChatMessage> linkedList = this.globalHistory;
        synchronized (linkedList) {
            if (this.globalHistory.isEmpty()) {
                return "";
            }
            StringBuilder context = new StringBuilder();
            context.append("Recent chat context:\n");
            for (ChatMessage msg : this.globalHistory) {
                context.append(msg.getPlayerName()).append(": ").append(msg.getMessage()).append("\n");
            }
            return context.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChatMessage> getRecentMessages(int count) {
        LinkedList<ChatMessage> linkedList = this.globalHistory;
        synchronized (linkedList) {
            int start;
            ArrayList<ChatMessage> recent = new ArrayList<ChatMessage>();
            for (int i = start = Math.max(0, this.globalHistory.size() - count); i < this.globalHistory.size(); ++i) {
                recent.add(this.globalHistory.get(i));
            }
            return recent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHistory() {
        LinkedList<ChatMessage> linkedList = this.globalHistory;
        synchronized (linkedList) {
            this.globalHistory.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistorySize() {
        LinkedList<ChatMessage> linkedList = this.globalHistory;
        synchronized (linkedList) {
            return this.globalHistory.size();
        }
    }

    public static class ChatMessage {
        private final String playerName;
        private final String message;
        private final long timestamp;

        public ChatMessage(String playerName, String message, long timestamp) {
            this.playerName = playerName;
            this.message = message;
            this.timestamp = timestamp;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public String getMessage() {
            return this.message;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

