/*
 * Decompiled with CFR 0.152.
 */
package com.grokchat.managers;

import com.grokchat.GrokChatPlugin;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final GrokChatPlugin plugin;
    private final FileConfiguration config;

    public ConfigManager(GrokChatPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
    }

    public String getApiKey() {
        return this.config.getString("api.key", "");
    }

    public boolean isApiKeyValid() {
        String key = this.getApiKey();
        return key != null && !key.isEmpty() && !key.equals("your-xai-api-key-here");
    }

    public String getApiEndpoint() {
        return this.config.getString("api.endpoint", "https://api.x.ai/v1/chat/completions");
    }

    public String getModel() {
        return this.config.getString("api.model", "grok-beta");
    }

    public int getTimeout() {
        return this.config.getInt("api.timeout", 30);
    }

    public boolean isMentionsEnabled() {
        return this.config.getBoolean("chat.enable-mentions", true);
    }

    public String getMentionPrefix() {
        return this.config.getString("chat.mention-prefix", "@grok");
    }

    public boolean isCommandEnabled() {
        return this.config.getBoolean("chat.enable-command", true);
    }

    public int getMaxMessageLength() {
        return this.config.getInt("chat.max-message-length", 500);
    }

    public int getCooldown() {
        return this.config.getInt("chat.cooldown", 5);
    }

    public boolean isAutoResponseEnabled() {
        return this.config.getBoolean("chat.enable-auto-response", true);
    }

    public List<String> getAutoResponseKeywords() {
        return this.config.getStringList("chat.auto-response-keywords");
    }

    public int getAutoResponseMinWords() {
        return this.config.getInt("chat.auto-response-min-words", 3);
    }

    public int getMaxResponseLength() {
        return this.config.getInt("response.max-length", 256);
    }

    public String getResponseColor() {
        return this.config.getString("response.color", "AQUA");
    }

    public String getResponsePrefix() {
        return this.config.getString("response.prefix", "&b[Grok]&r ");
    }

    public boolean isShowThinking() {
        return this.config.getBoolean("response.show-thinking", true);
    }

    public String getThinkingMessage() {
        return this.config.getString("response.thinking-message", "&7Grok is thinking...");
    }

    public boolean isRateLimitEnabled() {
        return this.config.getBoolean("rate-limit.enabled", true);
    }

    public int getMaxRequestsPerHour() {
        return this.config.getInt("rate-limit.max-requests-per-hour", 20);
    }

    public boolean isChatHistoryEnabled() {
        return this.config.getBoolean("chat-history.enabled", true);
    }

    public int getChatHistorySize() {
        return this.config.getInt("chat-history.size", 10);
    }

    public boolean useHistoryInAutoResponse() {
        return this.config.getBoolean("chat-history.use-in-auto-response", true);
    }

    public boolean useHistoryInDirectMention() {
        return this.config.getBoolean("chat-history.use-in-direct-mention", false);
    }

    public boolean isPlayerDataEnabled() {
        return this.config.getBoolean("player-data.enabled", false);
    }

    public boolean includePlayerPosition() {
        return this.config.getBoolean("player-data.include-position", true);
    }

    public boolean includePlayerBiome() {
        return this.config.getBoolean("player-data.include-biome", true);
    }

    public boolean includePlayerWorld() {
        return this.config.getBoolean("player-data.include-world", true);
    }

    public boolean includePlayerHealth() {
        return this.config.getBoolean("player-data.include-health", true);
    }

    public boolean includePlayerExperience() {
        return this.config.getBoolean("player-data.include-experience", true);
    }

    public boolean includePlayerHeldItem() {
        return this.config.getBoolean("player-data.include-held-item", true);
    }

    public boolean includePlayerEquipment() {
        return this.config.getBoolean("player-data.include-equipment", true);
    }

    public boolean includePlayerGamemode() {
        return this.config.getBoolean("player-data.include-gamemode", true);
    }

    public boolean includePlayerEffects() {
        return this.config.getBoolean("player-data.include-effects", true);
    }

    public boolean usePlayerDataInAutoResponse() {
        return this.config.getBoolean("player-data.use-in-auto-response", false);
    }

    public boolean usePlayerDataInDirectMention() {
        return this.config.getBoolean("player-data.use-in-direct-mention", true);
    }

    public boolean isLogQueries() {
        return this.config.getBoolean("privacy.log-queries", false);
    }

    public boolean isShareContext() {
        return this.config.getBoolean("privacy.share-context", false);
    }

    public double getTemperature() {
        return this.config.getDouble("advanced.temperature", 0.7);
    }

    public int getMaxTokens() {
        return this.config.getInt("advanced.max-tokens", 500);
    }

    public String getSystemPrompt() {
        return this.config.getString("advanced.system-prompt", "You are Grok, an AI assistant integrated into a Minecraft server. You're helpful, witty, and concise. Keep responses brief and engaging. You're talking to player: {player}");
    }

    public boolean isDebug() {
        return this.config.getBoolean("advanced.debug", false);
    }
}

