/*
 * Decompiled with CFR 0.152.
 */
package com.grokchat.managers;

import com.grokchat.GrokChatPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class CooldownManager {
    private final GrokChatPlugin plugin;
    private final Map<UUID, Long> cooldowns;

    public CooldownManager(GrokChatPlugin plugin) {
        this.plugin = plugin;
        this.cooldowns = new HashMap<UUID, Long>();
    }

    public boolean isOnCooldown(Player player) {
        if (!this.cooldowns.containsKey(player.getUniqueId())) {
            return false;
        }
        long lastUsed = this.cooldowns.get(player.getUniqueId());
        long cooldownSeconds = this.plugin.getConfigManager().getCooldown();
        long cooldownMillis = cooldownSeconds * 1000L;
        return System.currentTimeMillis() - lastUsed < cooldownMillis;
    }

    public long getRemainingCooldown(Player player) {
        if (!this.cooldowns.containsKey(player.getUniqueId())) {
            return 0L;
        }
        long lastUsed = this.cooldowns.get(player.getUniqueId());
        long cooldownSeconds = this.plugin.getConfigManager().getCooldown();
        long cooldownMillis = cooldownSeconds * 1000L;
        long elapsed = System.currentTimeMillis() - lastUsed;
        return Math.max(0L, (cooldownMillis - elapsed) / 1000L);
    }

    public void setCooldown(Player player) {
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public void removeCooldown(Player player) {
        this.cooldowns.remove(player.getUniqueId());
    }

    public void clearAll() {
        this.cooldowns.clear();
    }
}

