/*
 * Decompiled with CFR 0.152.
 */
package com.grokchat.managers;

import com.grokchat.GrokChatPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.entity.Player;

public class RateLimitManager {
    private final GrokChatPlugin plugin;
    private final Map<UUID, ConcurrentLinkedQueue<Long>> requestTimestamps;

    public RateLimitManager(GrokChatPlugin plugin) {
        this.plugin = plugin;
        this.requestTimestamps = new HashMap<UUID, ConcurrentLinkedQueue<Long>>();
    }

    public boolean canMakeRequest(Player player) {
        if (!this.plugin.getConfigManager().isRateLimitEnabled()) {
            return true;
        }
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        long oneHourAgo = currentTime - 3600000L;
        ConcurrentLinkedQueue timestamps = this.requestTimestamps.computeIfAbsent(playerId, k -> new ConcurrentLinkedQueue());
        timestamps.removeIf(timestamp -> timestamp < oneHourAgo);
        int maxRequests = this.plugin.getConfigManager().getMaxRequestsPerHour();
        return timestamps.size() < maxRequests;
    }

    public void recordRequest(Player player) {
        UUID playerId = player.getUniqueId();
        ConcurrentLinkedQueue timestamps = this.requestTimestamps.computeIfAbsent(playerId, k -> new ConcurrentLinkedQueue());
        timestamps.add(System.currentTimeMillis());
    }

    public int getRemainingRequests(Player player) {
        if (!this.plugin.getConfigManager().isRateLimitEnabled()) {
            return Integer.MAX_VALUE;
        }
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        long oneHourAgo = currentTime - 3600000L;
        ConcurrentLinkedQueue<Long> timestamps = this.requestTimestamps.get(playerId);
        if (timestamps == null) {
            return this.plugin.getConfigManager().getMaxRequestsPerHour();
        }
        timestamps.removeIf(timestamp -> timestamp < oneHourAgo);
        int maxRequests = this.plugin.getConfigManager().getMaxRequestsPerHour();
        return Math.max(0, maxRequests - timestamps.size());
    }

    public void clearAll() {
        this.requestTimestamps.clear();
    }
}

